/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import de.jexcellence.jextranslate.util.TranslationLogger;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class TranslationBackupService {
    private static final Logger LOGGER = TranslationLogger.getLogger(TranslationBackupService.class);
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final int DEFAULT_RETENTION = 10;
    private final Path backupRoot;
    private final int retention;

    public TranslationBackupService(@NotNull Path translationsDirectory) {
        this(translationsDirectory, 10);
    }

    public TranslationBackupService(@NotNull Path translationsDirectory, int retention) {
        Objects.requireNonNull(translationsDirectory, "Translations directory cannot be null");
        this.backupRoot = translationsDirectory.resolve("backups");
        this.retention = Math.max(retention, 1);
    }

    @NotNull
    public Optional<Path> createBackup(@NotNull Path source, @NotNull String reason) throws IOException {
        Objects.requireNonNull(source, "Source cannot be null");
        Objects.requireNonNull(reason, "Reason cannot be null");
        if (!Files.exists(source, new LinkOption[0]) || Files.isDirectory(source, new LinkOption[0])) {
            return Optional.empty();
        }
        Files.createDirectories(this.backupRoot, new FileAttribute[0]);
        String baseName = source.getFileName().toString();
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
        Path backupFile = this.backupRoot.resolve(baseName + "." + timestamp + ".bak");
        Files.copy(source, backupFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        LOGGER.info(() -> TranslationLogger.message("Created backup", Map.of("source", source.toString(), "backup", backupFile.toString(), "reason", reason)));
        this.pruneBackups(baseName);
        return Optional.of(backupFile);
    }

    private void pruneBackups(@NotNull String baseName) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.backupRoot, baseName + ".*.bak");){
            ArrayList<Path> backups = new ArrayList<Path>();
            stream.forEach(backups::add);
            backups.sort(Comparator.comparing(Path::getFileName).reversed());
            backups.stream().skip(this.retention).forEach(obsolete -> {
                try {
                    Files.deleteIfExists(obsolete);
                    LOGGER.fine(() -> TranslationLogger.message("Pruned stale backup", Map.of("backup", obsolete.toString())));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, TranslationLogger.message("Failed to prune backups", Map.of("baseName", baseName)), e);
        }
    }
}

