/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import org.jetbrains.annotations.NotNull;

public final class PluralRules {
    public static final String ZERO = "zero";
    public static final String ONE = "one";
    public static final String TWO = "two";
    public static final String FEW = "few";
    public static final String MANY = "many";
    public static final String OTHER = "other";

    private PluralRules() {
    }

    @NotNull
    public static String select(@NotNull String locale, int count) {
        String language;
        return switch (language = PluralRules.extractLanguage(locale)) {
            case "en", "de" -> PluralRules.selectGermanic(count);
            case "fr" -> PluralRules.selectFrench(count);
            case "es", "it", "pt" -> PluralRules.selectRomance(count);
            case "ru", "uk" -> PluralRules.selectSlavic(count);
            case "pl" -> PluralRules.selectPolish(count);
            case "ar" -> PluralRules.selectArabic(count);
            case "ja", "ko", "zh" -> OTHER;
            default -> count == 1 ? ONE : OTHER;
        };
    }

    @NotNull
    private static String extractLanguage(@NotNull String locale) {
        return locale.split("[_-]")[0].toLowerCase();
    }

    @NotNull
    private static String selectGermanic(int count) {
        return count == 1 ? ONE : OTHER;
    }

    @NotNull
    private static String selectFrench(int count) {
        return count <= 1 ? ONE : OTHER;
    }

    @NotNull
    private static String selectRomance(int count) {
        return count == 1 ? ONE : OTHER;
    }

    @NotNull
    private static String selectSlavic(int count) {
        int absCount = Math.abs(count);
        int mod10 = absCount % 10;
        int mod100 = absCount % 100;
        if (mod10 == 1 && mod100 != 11) {
            return ONE;
        }
        if (mod10 >= 2 && mod10 <= 4 && (mod100 < 12 || mod100 > 14)) {
            return FEW;
        }
        return MANY;
    }

    @NotNull
    private static String selectPolish(int count) {
        int absCount = Math.abs(count);
        int mod10 = absCount % 10;
        int mod100 = absCount % 100;
        if (absCount == 1) {
            return ONE;
        }
        if (mod10 >= 2 && mod10 <= 4 && (mod100 < 12 || mod100 > 14)) {
            return FEW;
        }
        return MANY;
    }

    @NotNull
    private static String selectArabic(int count) {
        int absCount = Math.abs(count);
        int mod100 = absCount % 100;
        if (absCount == 0) {
            return ZERO;
        }
        if (absCount == 1) {
            return ONE;
        }
        if (absCount == 2) {
            return TWO;
        }
        if (mod100 >= 3 && mod100 <= 10) {
            return FEW;
        }
        if (mod100 >= 11 && mod100 <= 99) {
            return MANY;
        }
        return OTHER;
    }
}

