/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import java.lang.runtime.SwitchBootstraps;
import java.text.ChoiceFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderFormatter {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\\{(\\w+)(?:,\\s*(number|date|time|choice|plural)(?:,\\s*([^}]+))?)?}");
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("\\{(\\w+)}|%(\\w+)%");

    private PlaceholderFormatter() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NotNull
    public static String format(@NotNull String template, @NotNull Map<String, Object> placeholders, @NotNull Locale locale) {
        Objects.requireNonNull(template, "Template cannot be null");
        Objects.requireNonNull(placeholders, "Placeholders cannot be null");
        Objects.requireNonNull(locale, "Locale cannot be null");
        String result = template;
        result = PlaceholderFormatter.processAdvancedFormats(result, placeholders, locale);
        result = PlaceholderFormatter.processSimplePlaceholders(result, placeholders);
        return result;
    }

    private static String processAdvancedFormats(String template, Map<String, Object> placeholders, Locale locale) {
        Matcher matcher = FORMAT_PATTERN.matcher(template);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String replacement;
            String key = matcher.group(1);
            String type = matcher.group(2);
            String style = matcher.group(3);
            Object value = placeholders.get(key);
            if (value == null) {
                replacement = matcher.group(0);
            } else if (type == null) {
                replacement = value.toString();
            } else {
                replacement = switch (type.toLowerCase()) {
                    case "number" -> PlaceholderFormatter.formatNumber(value, style, locale);
                    case "date" -> PlaceholderFormatter.formatDate(value, style, locale);
                    case "time" -> PlaceholderFormatter.formatTime(value, style, locale);
                    case "choice" -> PlaceholderFormatter.formatChoice(value, style);
                    case "plural" -> PlaceholderFormatter.formatPlural(value, style, locale);
                    default -> value.toString();
                };
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String processSimplePlaceholders(String template, Map<String, Object> placeholders) {
        Matcher matcher = SIMPLE_PATTERN.matcher(template);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            Object value = placeholders.get(key);
            String replacement = value != null ? value.toString() : matcher.group(0);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @NotNull
    private static String formatNumber(@Nullable Object value, @Nullable String style, @NotNull Locale locale) {
        if (value == null) {
            return "";
        }
        Number number = PlaceholderFormatter.toNumber(value);
        if (number == null) {
            return value.toString();
        }
        NumberFormat formatter = switch (style != null ? style.toLowerCase() : "") {
            case "integer" -> NumberFormat.getIntegerInstance(locale);
            case "currency" -> NumberFormat.getCurrencyInstance(locale);
            case "percent" -> NumberFormat.getPercentInstance(locale);
            default -> NumberFormat.getNumberInstance(locale);
        };
        return formatter.format(number);
    }

    @NotNull
    private static String formatDate(@Nullable Object value, @Nullable String style, @NotNull Locale locale) {
        if (value == null) {
            return "";
        }
        FormatStyle formatStyle = PlaceholderFormatter.parseFormatStyle(style);
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(locale);
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalDate.class, LocalDateTime.class, ZonedDateTime.class, Date.class}, (Object)object2, n)) {
            case 0 -> {
                LocalDate ld = (LocalDate)object2;
                yield ld.format(formatter);
            }
            case 1 -> {
                LocalDateTime ldt = (LocalDateTime)object2;
                yield ldt.toLocalDate().format(formatter);
            }
            case 2 -> {
                ZonedDateTime zdt = (ZonedDateTime)object2;
                yield zdt.toLocalDate().format(formatter);
            }
            case 3 -> {
                Date d = (Date)object2;
                yield d.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(formatter);
            }
            default -> value.toString();
        };
    }

    @NotNull
    private static String formatTime(@Nullable Object value, @Nullable String style, @NotNull Locale locale) {
        if (value == null) {
            return "";
        }
        FormatStyle formatStyle = PlaceholderFormatter.parseFormatStyle(style);
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedTime(formatStyle).withLocale(locale);
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalDateTime.class, ZonedDateTime.class, Date.class}, (Object)object2, n)) {
            case 0 -> {
                LocalDateTime ldt = (LocalDateTime)object2;
                yield ldt.toLocalTime().format(formatter);
            }
            case 1 -> {
                ZonedDateTime zdt = (ZonedDateTime)object2;
                yield zdt.toLocalTime().format(formatter);
            }
            case 2 -> {
                Date d = (Date)object2;
                yield d.toInstant().atZone(ZoneId.systemDefault()).toLocalTime().format(formatter);
            }
            default -> value.toString();
        };
    }

    @NotNull
    private static String formatChoice(@Nullable Object value, @Nullable String pattern) {
        if (value == null || pattern == null) {
            return "";
        }
        Number number = PlaceholderFormatter.toNumber(value);
        if (number == null) {
            return value.toString();
        }
        try {
            ChoiceFormat choiceFormat = new ChoiceFormat(pattern);
            return choiceFormat.format(number.doubleValue());
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    @NotNull
    private static String formatPlural(@Nullable Object value, @Nullable String pattern, @NotNull Locale locale) {
        if (value == null || pattern == null) {
            return "";
        }
        Number number = PlaceholderFormatter.toNumber(value);
        if (number == null) {
            return value.toString();
        }
        long count = number.longValue();
        String[] parts = pattern.split("\\s+(?=one|other|zero|two|few|many)");
        String result = null;
        String otherResult = null;
        for (String part : parts) {
            if ((part = part.trim()).startsWith("one ") && count == 1L) {
                result = PlaceholderFormatter.extractPluralValue(part.substring(4), count);
                continue;
            }
            if (part.startsWith("zero ") && count == 0L) {
                result = PlaceholderFormatter.extractPluralValue(part.substring(5), count);
                continue;
            }
            if (part.startsWith("two ") && count == 2L) {
                result = PlaceholderFormatter.extractPluralValue(part.substring(4), count);
                continue;
            }
            if (!part.startsWith("other ")) continue;
            otherResult = PlaceholderFormatter.extractPluralValue(part.substring(6), count);
        }
        return result != null ? result : (otherResult != null ? otherResult : value.toString());
    }

    private static String extractPluralValue(String pattern, long count) {
        String trimmed = pattern.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
        }
        return trimmed.replace("#", String.valueOf(count));
    }

    @Nullable
    private static Number toNumber(@Nullable Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Number n;
                Number var3_4;
                yield var3_4 = (n = (Number)object);
            }
            case 1 -> {
                String s = (String)object;
                try {
                    Double var3_5 = Double.parseDouble(s);
                    yield var3_5;
                }
                catch (NumberFormatException e) {
                    Object var3_6 = null;
                    yield var3_6;
                }
            }
            default -> {
                Number var3_7;
                yield var3_7 = null;
            }
        };
    }

    private static FormatStyle parseFormatStyle(@Nullable String style) {
        if (style == null) {
            return FormatStyle.MEDIUM;
        }
        return switch (style.toLowerCase()) {
            case "short" -> FormatStyle.SHORT;
            case "long" -> FormatStyle.LONG;
            case "full" -> FormatStyle.FULL;
            default -> FormatStyle.MEDIUM;
        };
    }
}

