/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageCache {
    private static final int DEFAULT_MAX_SIZE = 1000;
    private final Map<String, Component> cache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final int maxSize;
    private long hits;
    private long misses;

    public MessageCache() {
        this(1000);
    }

    public MessageCache(int maxSize) {
        this.maxSize = maxSize > 0 ? maxSize : 1000;
        this.cache = new LinkedHashMap<String, Component>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Component> eldest) {
                return this.size() > MessageCache.this.maxSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Component get(@NotNull String key) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.lock.readLock().lock();
        try {
            Component result = this.cache.get(key);
            if (result != null) {
                ++this.hits;
            } else {
                ++this.misses;
            }
            Component component = result;
            return component;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void put(@NotNull String key, @NotNull Component component) {
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(component, "Component cannot be null");
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, component);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @NotNull
    public Component computeIfAbsent(@NotNull String key, @NotNull Function<String, Component> mapper) {
        Component cached = this.get(key);
        if (cached != null) {
            return cached;
        }
        Component computed = mapper.apply(key);
        this.put(key, computed);
        return computed;
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
            this.hits = 0L;
            this.misses = 0L;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @NotNull
    public CacheStats stats() {
        this.lock.readLock().lock();
        try {
            CacheStats cacheStats = new CacheStats(this.cache.size(), this.maxSize, this.hits, this.misses);
            return cacheStats;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public record CacheStats(int size, int maxSize, long hits, long misses) {
        public double hitRate() {
            long total = this.hits + this.misses;
            return total > 0L ? (double)this.hits / (double)total : 0.0;
        }
    }
}

