/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;

public final class LoreFormatter {
    public static final int DEFAULT_MAX_WIDTH = 40;
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final PlainTextComponentSerializer PLAIN_SERIALIZER = PlainTextComponentSerializer.plainText();

    private LoreFormatter() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NotNull
    public static List<String> formatLore(@NotNull List<Component> components) {
        return LoreFormatter.formatLore(components, 40);
    }

    @NotNull
    public static List<String> formatLore(@NotNull List<Component> components, int maxWidth) {
        Objects.requireNonNull(components, "Components cannot be null");
        if (maxWidth < 10) {
            throw new IllegalArgumentException("Max width must be at least 10");
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (Component component : components) {
            String legacy = LEGACY_SERIALIZER.serialize(component);
            if (LoreFormatter.getVisibleLength(legacy) <= maxWidth) {
                lore.add(legacy);
                continue;
            }
            lore.addAll(LoreFormatter.wrapLine(legacy, maxWidth));
        }
        return lore;
    }

    @NotNull
    public static List<String> formatPlainLore(@NotNull List<String> lines, int maxWidth) {
        Objects.requireNonNull(lines, "Lines cannot be null");
        if (maxWidth < 10) {
            throw new IllegalArgumentException("Max width must be at least 10");
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : lines) {
            if (line.length() <= maxWidth) {
                lore.add(line);
                continue;
            }
            lore.addAll(LoreFormatter.wrapPlainLine(line, maxWidth));
        }
        return lore;
    }

    @NotNull
    private static List<String> wrapLine(@NotNull String line, int maxWidth) {
        ArrayList<String> wrapped = new ArrayList<String>();
        Object lastColorCode = "";
        StringBuilder currentLine = new StringBuilder();
        int visibleLength = 0;
        int i = 0;
        while (i < line.length()) {
            if (i < line.length() - 1 && line.charAt(i) == '\u00a7') {
                char code = line.charAt(i + 1);
                String colorCode = "\u00a7" + code;
                if (code == 'r' || code == 'R') {
                    lastColorCode = "";
                } else if (LoreFormatter.isColorCode(code)) {
                    lastColorCode = colorCode;
                } else if (LoreFormatter.isFormatCode(code)) {
                    lastColorCode = (String)lastColorCode + colorCode;
                }
                currentLine.append(colorCode);
                i += 2;
                continue;
            }
            if (visibleLength >= maxWidth && line.charAt(i) == ' ') {
                wrapped.add(currentLine.toString());
                currentLine = new StringBuilder((String)lastColorCode);
                visibleLength = 0;
                ++i;
                continue;
            }
            currentLine.append(line.charAt(i));
            ++visibleLength;
            ++i;
        }
        if (currentLine.length() > 0) {
            wrapped.add(currentLine.toString());
        }
        return wrapped;
    }

    @NotNull
    private static List<String> wrapPlainLine(@NotNull String line, int maxWidth) {
        ArrayList<String> wrapped = new ArrayList<String>();
        String[] words = line.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxWidth && currentLine.length() > 0) {
                wrapped.add(currentLine.toString());
                currentLine.setLength(0);
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            wrapped.add(currentLine.toString());
        }
        return wrapped;
    }

    public static int getVisibleLength(@NotNull String text) {
        int length = 0;
        boolean skipNext = false;
        for (int i = 0; i < text.length(); ++i) {
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (text.charAt(i) == '\u00a7' && i < text.length() - 1) {
                skipNext = true;
                continue;
            }
            ++length;
        }
        return length;
    }

    @NotNull
    public static String stripColors(@NotNull String text) {
        StringBuilder result = new StringBuilder();
        boolean skipNext = false;
        for (int i = 0; i < text.length(); ++i) {
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (text.charAt(i) == '\u00a7' && i < text.length() - 1) {
                skipNext = true;
                continue;
            }
            result.append(text.charAt(i));
        }
        return result.toString();
    }

    @NotNull
    public static String toLegacy(@NotNull Component component) {
        return LEGACY_SERIALIZER.serialize(component);
    }

    @NotNull
    public static String toPlainText(@NotNull Component component) {
        return PLAIN_SERIALIZER.serialize(component);
    }

    private static boolean isColorCode(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isFormatCode(char c) {
        return c == 'k' || c == 'K' || c == 'l' || c == 'L' || c == 'm' || c == 'M' || c == 'n' || c == 'N' || c == 'o' || c == 'O';
    }
}

