/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class ColorUtil {
    private static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("[&\u00a7]([0-9a-fk-or])");
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("[&\u00a7]#([0-9a-fA-F]{6})");

    private ColorUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NotNull
    public static String convertLegacyToMiniMessage(@NotNull String text) {
        return ColorUtil.convertLegacyColorsToMiniMessage(text);
    }

    @NotNull
    public static String convertLegacyColorsToMiniMessage(@NotNull String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String result = text;
        Matcher hexMatcher = HEX_COLOR_PATTERN.matcher(result);
        StringBuilder hexBuilder = new StringBuilder();
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1);
            hexMatcher.appendReplacement(hexBuilder, "<#" + hex + ">");
        }
        hexMatcher.appendTail(hexBuilder);
        result = hexBuilder.toString();
        Matcher colorMatcher = LEGACY_COLOR_PATTERN.matcher(result);
        StringBuilder colorBuilder = new StringBuilder();
        while (colorMatcher.find()) {
            String code = colorMatcher.group(1).toLowerCase();
            String replacement = ColorUtil.convertCodeToMiniMessage(code);
            colorMatcher.appendReplacement(colorBuilder, Matcher.quoteReplacement(replacement));
        }
        colorMatcher.appendTail(colorBuilder);
        return colorBuilder.toString();
    }

    @NotNull
    private static String convertCodeToMiniMessage(@NotNull String code) {
        return switch (code) {
            case "0" -> "<black>";
            case "1" -> "<dark_blue>";
            case "2" -> "<dark_green>";
            case "3" -> "<dark_aqua>";
            case "4" -> "<dark_red>";
            case "5" -> "<dark_purple>";
            case "6" -> "<gold>";
            case "7" -> "<gray>";
            case "8" -> "<dark_gray>";
            case "9" -> "<blue>";
            case "a" -> "<green>";
            case "b" -> "<aqua>";
            case "c" -> "<red>";
            case "d" -> "<light_purple>";
            case "e" -> "<yellow>";
            case "f" -> "<white>";
            case "k" -> "<obfuscated>";
            case "l" -> "<bold>";
            case "m" -> "<strikethrough>";
            case "n" -> "<underlined>";
            case "o" -> "<italic>";
            case "r" -> "<reset>";
            default -> "";
        };
    }

    @NotNull
    public static String stripColors(@NotNull String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String result = text.replaceAll("[&\u00a7][0-9a-fk-or]", "");
        result = result.replaceAll("[&\u00a7]#[0-9a-fA-F]{6}", "");
        result = result.replaceAll("<[^>]+>", "");
        return result;
    }

    public static boolean hasColorCodes(@NotNull String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        return LEGACY_COLOR_PATTERN.matcher(text).find() || HEX_COLOR_PATTERN.matcher(text).find() || text.contains("<");
    }

    @NotNull
    public static String convertMiniMessageToLegacy(@NotNull String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String result = text;
        result = result.replace("<black>", "\u00a70");
        result = result.replace("<dark_blue>", "\u00a71");
        result = result.replace("<dark_green>", "\u00a72");
        result = result.replace("<dark_aqua>", "\u00a73");
        result = result.replace("<dark_red>", "\u00a74");
        result = result.replace("<dark_purple>", "\u00a75");
        result = result.replace("<gold>", "\u00a76");
        result = result.replace("<gray>", "\u00a77");
        result = result.replace("<grey>", "\u00a77");
        result = result.replace("<dark_gray>", "\u00a78");
        result = result.replace("<dark_grey>", "\u00a78");
        result = result.replace("<blue>", "\u00a79");
        result = result.replace("<green>", "\u00a7a");
        result = result.replace("<aqua>", "\u00a7b");
        result = result.replace("<red>", "\u00a7c");
        result = result.replace("<light_purple>", "\u00a7d");
        result = result.replace("<yellow>", "\u00a7e");
        result = result.replace("<white>", "\u00a7f");
        result = result.replace("<obfuscated>", "\u00a7k");
        result = result.replace("<bold>", "\u00a7l");
        result = result.replace("<strikethrough>", "\u00a7m");
        result = result.replace("<underlined>", "\u00a7n");
        result = result.replace("<italic>", "\u00a7o");
        result = result.replace("<reset>", "\u00a7r");
        result = result.replaceAll("</[^>]+>", "");
        result = result.replaceAll("<#[0-9a-fA-F]{6}>", "\u00a7f");
        result = result.replaceAll("<[^>]+>", "");
        return result;
    }
}

