/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.i18n.wrapper;

import de.jexcellence.jextranslate.R18nManager;
import de.jexcellence.jextranslate.i18n.wrapper.II18nVersionWrapper;
import de.jexcellence.jextranslate.util.ColorUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class UniversalI18nWrapper
implements II18nVersionWrapper<Component> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final Player player;
    private final String key;
    private final Map<String, String> placeholders;
    private final boolean includePrefix;

    public UniversalI18nWrapper(@NotNull Player player, @NotNull String key, @NotNull Map<String, String> placeholders, boolean includePrefix) {
        this.player = player;
        this.key = key;
        this.placeholders = placeholders;
        this.includePrefix = includePrefix;
    }

    @Override
    public void sendMessage() {
        R18nManager manager = R18nManager.getInstance();
        if (manager != null) {
            if (manager.getAudiences() != null) {
                manager.getAudiences().player(this.player).sendMessage(this.getFormattedMessage());
            } else {
                String legacyMessage = ColorUtil.convertMiniMessageToLegacy((String)MINI_MESSAGE.serialize(this.getFormattedMessage()));
                this.player.sendMessage(legacyMessage);
            }
        }
    }

    @Override
    public void sendMessages() {
        R18nManager manager = R18nManager.getInstance();
        if (manager != null) {
            if (manager.getAudiences() != null) {
                this.getMessagesIncludingPlaceholdersAndPrefix().forEach(message -> manager.getAudiences().player(this.player).sendMessage(message));
            } else {
                this.getMessagesIncludingPlaceholdersAndPrefix().forEach(message -> {
                    String legacyMessage = ColorUtil.convertMiniMessageToLegacy((String)MINI_MESSAGE.serialize(message));
                    this.player.sendMessage(legacyMessage);
                });
            }
        }
    }

    @Override
    @NotNull
    public Component getMessageType() {
        return Component.text((String)"Component");
    }

    @Override
    @NotNull
    public Component displayMessage() {
        return this.getFormattedMessage();
    }

    @Override
    @NotNull
    public List<Component> displayMessages() {
        return this.getMessagesIncludingPlaceholdersAndPrefix();
    }

    @Override
    @NotNull
    public Component getPrefix() {
        return this.getJoinedMessageByKey();
    }

    @Override
    @NotNull
    public List<Component> getMessagesByKey() {
        return this.getRawMessagesByKey(this.key);
    }

    @Override
    @NotNull
    public List<Component> getPrefixByKey() {
        return this.getRawMessagesByKey("prefix");
    }

    @Override
    @NotNull
    public List<Component> getMessagesIncludingPlaceholdersAndPrefix() {
        ArrayList<Component> messages = new ArrayList<Component>(this.getMessagesByKey());
        if (this.includePrefix) {
            messages.addAll(0, this.getPrefixByKey());
        }
        return messages;
    }

    @Override
    @NotNull
    public Class<Component> getType() {
        return Component.class;
    }

    @Override
    @NotNull
    public List<Component> getMessagesIncludingPlaceholders() {
        return this.getMessagesByKey();
    }

    @Override
    @NotNull
    public Component getJoinedMessage() {
        return this.joinComponents(this.getMessagesIncludingPlaceholdersAndPrefix());
    }

    @Override
    @NotNull
    public Component getMessage() {
        return this.joinComponents(this.getMessagesByKey());
    }

    @Override
    @NotNull
    public Component getFormattedMessage() {
        return this.convertLegacyColorsInComponent(this.includePrefix ? this.getPrefix().appendSpace().append(this.getMessage()) : this.getMessage());
    }

    @Override
    @NotNull
    public List<Component> getRawMessagesByKey(@NotNull String key) {
        R18nManager manager = R18nManager.getInstance();
        String locale = this.getPlayerLocale();
        List messages = null;
        if (manager != null) {
            Optional<List<String>> translation = manager.getTranslationLoader().getRawTranslation(key, locale);
            messages = translation.orElse(null);
        }
        if (messages == null || messages.isEmpty()) {
            messages = List.of("<gold>Message key <red>'" + key + "'</red> is missing!</gold>");
        }
        ArrayList<Component> result = new ArrayList<Component>();
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            String message;
            String processedMessage = message = (String)iterator.next();
            for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                String placeholderPercent = "%" + entry.getKey() + "%";
                String placeholderBracket = "{" + entry.getKey() + "}";
                String value = ColorUtil.convertLegacyColorsToMiniMessage(entry.getValue());
                processedMessage = processedMessage.replace(placeholderPercent, value);
                processedMessage = processedMessage.replace(placeholderBracket, value);
            }
            result.add(MINI_MESSAGE.deserialize((Object)processedMessage));
        }
        return result;
    }

    @Override
    @NotNull
    public List<Component> replacePlaceholders() {
        return new ArrayList<Component>();
    }

    @Override
    @NotNull
    public String asPlaceholder() {
        Component formattedMessage = this.getFormattedMessage();
        return (String)MINI_MESSAGE.serialize(formattedMessage);
    }

    private String getPlayerLocale() {
        R18nManager manager = R18nManager.getInstance();
        String defaultLocale = manager != null ? manager.getConfiguration().defaultLocale() : "en_US";
        try {
            String playerLocale = this.player.getLocale();
            String normalizedLocale = this.normalizeLocale(playerLocale);
            if (manager != null) {
                if (manager.getConfiguration().supportedLocales().contains(normalizedLocale)) {
                    return normalizedLocale;
                }
                String language = playerLocale.split("[_-]")[0].toLowerCase();
                for (String supportedLocale : manager.getConfiguration().supportedLocales()) {
                    if (!supportedLocale.toLowerCase().startsWith(language)) continue;
                    return supportedLocale;
                }
            }
            return normalizedLocale;
        }
        catch (NoSuchMethodError | UnsupportedOperationException e) {
            return defaultLocale;
        }
    }

    @NotNull
    private String normalizeLocale(@NotNull String locale) {
        if (locale == null || locale.isEmpty()) {
            return locale;
        }
        String[] parts = locale.split("[_-]");
        if (parts.length == 1) {
            return parts[0].toLowerCase();
        }
        if (parts.length >= 2) {
            return parts[0].toLowerCase() + "_" + parts[1].toUpperCase();
        }
        return locale;
    }

    private Component getJoinedMessageByKey() {
        return this.joinComponents(this.getRawMessagesByKey("prefix"));
    }

    private Component convertLegacyColorsInComponent(@NotNull Component component) {
        String serialized = (String)MINI_MESSAGE.serialize(component);
        serialized = ColorUtil.convertLegacyColorsToMiniMessage(serialized);
        return MINI_MESSAGE.deserialize((Object)serialized);
    }

    private Component joinComponents(@NotNull List<Component> components) {
        TextComponent joinedComponent = Component.empty();
        for (Component component : components) {
            joinedComponent = joinedComponent.append(component);
        }
        joinedComponent = joinedComponent.replaceText((TextReplacementConfig)TextReplacementConfig.builder().replacement((ComponentLike)Component.text((String)"")).match("\n").match("<br>").build());
        return joinedComponent;
    }
}

