/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.i18n.wrapper;

import de.jexcellence.jextranslate.R18nManager;
import de.jexcellence.jextranslate.i18n.wrapper.II18nVersionWrapper;
import de.jexcellence.jextranslate.util.ColorUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;

public class I18nConsoleWrapper
implements II18nVersionWrapper<Component> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final String key;
    private final Map<String, String> placeholders;
    private final boolean includePrefix;

    public I18nConsoleWrapper(@NotNull String key, @NotNull Map<String, String> placeholders, boolean includePrefix) {
        this.key = key;
        this.placeholders = placeholders;
        this.includePrefix = includePrefix;
    }

    @Override
    public void sendMessage() {
        R18nManager manager = R18nManager.getInstance();
        if (manager != null && manager.getAudiences() != null) {
            manager.getAudiences().console().sendMessage(this.getFormattedMessage());
        }
    }

    @Override
    public void sendMessages() {
        R18nManager manager = R18nManager.getInstance();
        if (manager != null && manager.getAudiences() != null) {
            for (Component component : this.getMessagesIncludingPlaceholdersAndPrefix()) {
                manager.getAudiences().console().sendMessage(component);
            }
        }
    }

    @Override
    @NotNull
    public Component getMessageType() {
        return Component.empty();
    }

    @Override
    @NotNull
    public Component displayMessage() {
        throw new UnsupportedOperationException("This method is not supported for the console.");
    }

    @Override
    @NotNull
    public List<Component> displayMessages() {
        throw new UnsupportedOperationException("This method is not supported for the console.");
    }

    @Override
    @NotNull
    public Component getPrefix() {
        return this.joinComponents(this.getPrefixByKey());
    }

    @Override
    @NotNull
    public List<Component> getMessagesByKey() {
        return this.getRawMessagesByKey(this.key);
    }

    @Override
    @NotNull
    public List<Component> getPrefixByKey() {
        return this.getRawMessagesByKey("prefix");
    }

    @Override
    @NotNull
    public List<Component> getMessagesIncludingPlaceholdersAndPrefix() {
        ArrayList<Component> messages = new ArrayList<Component>(this.getMessagesByKey());
        if (this.includePrefix) {
            messages.addAll(0, this.getPrefixByKey());
        }
        return messages;
    }

    @Override
    @NotNull
    public List<Component> getMessagesIncludingPlaceholders() {
        return this.getMessagesByKey();
    }

    @Override
    @NotNull
    public Component getJoinedMessage() {
        return this.joinComponents(this.getMessagesIncludingPlaceholdersAndPrefix());
    }

    @Override
    @NotNull
    public Component getMessage() {
        return this.joinComponents(this.getMessagesByKey());
    }

    @Override
    @NotNull
    public Component getFormattedMessage() {
        return this.convertLegacyColorsInComponent(this.includePrefix ? this.getPrefix().appendSpace().append(this.getMessage()) : this.getMessage());
    }

    @Override
    @NotNull
    public List<Component> getRawMessagesByKey(@NotNull String key) {
        R18nManager manager = R18nManager.getInstance();
        String defaultLocale = manager != null ? manager.getConfiguration().defaultLocale() : "en_US";
        List messages = null;
        if (manager != null) {
            Optional<List<String>> translation = manager.getTranslationLoader().getRawTranslation(key, defaultLocale);
            messages = translation.orElse(null);
        }
        if (messages == null || messages.isEmpty()) {
            messages = List.of("<gold>Message key <red>'" + key + "'</red> is missing!</gold>");
        }
        ArrayList<Component> result = new ArrayList<Component>();
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            String message;
            String processedMessage = message = (String)iterator.next();
            for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                String placeholder = "%" + entry.getKey() + "%";
                String value = ColorUtil.convertLegacyColorsToMiniMessage(entry.getValue());
                processedMessage = processedMessage.replace(placeholder, value);
            }
            result.add(MINI_MESSAGE.deserialize((Object)processedMessage));
        }
        return result;
    }

    @Override
    @NotNull
    public List<Component> replacePlaceholders() {
        return new ArrayList<Component>();
    }

    @Override
    @NotNull
    public String asPlaceholder() {
        Component formattedMessage = this.getFormattedMessage();
        return (String)MINI_MESSAGE.serialize(formattedMessage);
    }

    private Component convertLegacyColorsInComponent(@NotNull Component component) {
        String serialized = (String)MINI_MESSAGE.serialize(component);
        serialized = ColorUtil.convertLegacyColorsToMiniMessage(serialized);
        return MINI_MESSAGE.deserialize((Object)serialized);
    }

    private Component joinComponents(List<Component> components) {
        TextComponent joined = Component.empty();
        for (Component comp : components) {
            if (!joined.equals((Object)Component.empty())) {
                joined = joined.append((Component)Component.newline());
            }
            joined = joined.append(comp);
        }
        return joined;
    }
}

