/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.i18n;

import de.jexcellence.jextranslate.i18n.wrapper.I18nConsoleWrapper;
import de.jexcellence.jextranslate.i18n.wrapper.II18nVersionWrapper;
import de.jexcellence.jextranslate.i18n.wrapper.VersionWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18n {
    private final II18nVersionWrapper<?> i18nVersionWrapper;

    private I18n(@NotNull Builder builder) {
        this.i18nVersionWrapper = builder.player == null ? new I18nConsoleWrapper(builder.key, builder.placeholders, builder.includePrefix) : new VersionWrapper(builder.player, builder.key, builder.placeholders, builder.includePrefix).getI18nVersionWrapper();
    }

    public void sendMessage() {
        this.i18nVersionWrapper.sendMessage();
    }

    public void sendMultiple() {
        this.i18nVersionWrapper.sendMessages();
    }

    public <T> T component() {
        return (T)this.i18nVersionWrapper.displayMessage();
    }

    public <T> List<T> children() {
        return this.i18nVersionWrapper.displayMessages();
    }

    public II18nVersionWrapper<?> getI18nVersionWrapper() {
        return this.i18nVersionWrapper;
    }

    public static class Builder {
        private final Map<String, String> placeholders = new HashMap<String, String>();
        private final Player player;
        private final String key;
        private boolean includePrefix = false;

        public Builder(@NotNull String key, @NotNull Player player) {
            if (key == null) {
                throw new NullPointerException("Translation key cannot be null");
            }
            if (player == null) {
                throw new NullPointerException("Player cannot be null");
            }
            this.key = key;
            this.player = player;
        }

        public Builder(@NotNull String key) {
            if (key == null) {
                throw new NullPointerException("Translation key cannot be null");
            }
            this.key = key;
            this.player = null;
        }

        public Builder withPlaceholders(@NotNull Map<String, Object> placeholders) {
            for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
                String value = entry.getValue() != null ? entry.getValue().toString() : "<null>";
                this.placeholders.put(entry.getKey(), value);
            }
            return this;
        }

        public Builder includePrefix() {
            this.includePrefix = true;
            return this;
        }

        public Builder withPlaceholder(@NotNull String key, @Nullable Object value) {
            this.placeholders.put(key, value != null ? value.toString() : "<null>");
            return this;
        }

        public I18n build() {
            return new I18n(this);
        }
    }
}

