/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.core;

import de.jexcellence.jextranslate.bedrock.BedrockConverter;
import de.jexcellence.jextranslate.bedrock.BedrockDetectionCache;
import de.jexcellence.jextranslate.config.R18nConfiguration;
import de.jexcellence.jextranslate.core.VersionDetector;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VersionedMessageSender {
    private static final Logger LOGGER = Logger.getLogger(VersionedMessageSender.class.getName());
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();
    private final VersionDetector versionDetector;
    private final BukkitAudiences audiences;
    private BedrockDetectionCache bedrockDetectionCache;
    private R18nConfiguration configuration;

    public VersionedMessageSender(@NotNull VersionDetector versionDetector, @Nullable BukkitAudiences audiences) {
        this.versionDetector = versionDetector;
        this.audiences = audiences;
    }

    public void setBedrockDetectionCache(@Nullable BedrockDetectionCache cache) {
        this.bedrockDetectionCache = cache;
    }

    public void setConfiguration(@Nullable R18nConfiguration configuration) {
        this.configuration = configuration;
    }

    public void sendMessage(@NotNull Player player, @NotNull Component component) {
        if (this.isBedrockSupportEnabled() && this.isBedrockPlayer(player)) {
            this.sendBedrockMessage(player, component);
            return;
        }
        if (this.supportsComponents()) {
            if (this.audiences != null) {
                this.audiences.player(player).sendMessage(component);
            } else {
                this.sendLegacyMessage(player, component);
            }
        } else {
            this.sendLegacyMessage(player, component);
        }
    }

    public void sendMessage(@NotNull CommandSender sender, @NotNull Component component) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.sendMessage(player, component);
            return;
        }
        if (this.supportsComponents() && this.audiences != null) {
            this.audiences.sender(sender).sendMessage(component);
        } else {
            String legacyMessage = LEGACY_SERIALIZER.serialize(component);
            sender.sendMessage(legacyMessage);
        }
    }

    public void sendMessage(@NotNull Audience audience, @NotNull Component component) {
        if (this.supportsComponents() && this.audiences != null) {
            audience.sendMessage(component);
        } else {
            LOGGER.warning("Attempted to send to Adventure audience on unsupported version");
        }
    }

    public void broadcast(@NotNull Component component) {
        if (this.supportsComponents() && this.audiences != null) {
            this.audiences.all().sendMessage(component);
        } else {
            String legacyMessage = LEGACY_SERIALIZER.serialize(component);
            Bukkit.getOnlinePlayers().forEach(player -> player.sendMessage(legacyMessage));
        }
    }

    public void console(@NotNull Component component) {
        if (this.supportsComponents() && this.audiences != null) {
            this.audiences.console().sendMessage(component);
        } else {
            String legacyMessage = LEGACY_SERIALIZER.serialize(component);
            Bukkit.getConsoleSender().sendMessage(legacyMessage);
        }
    }

    private void sendLegacyMessage(@NotNull Player player, @NotNull Component component) {
        String legacyMessage = LEGACY_SERIALIZER.serialize(component);
        player.sendMessage(legacyMessage);
    }

    private boolean supportsComponents() {
        return this.versionDetector.hasNativeAdventure() || this.versionDetector.isModern() && this.audiences != null;
    }

    public boolean hasAudiences() {
        return this.audiences != null;
    }

    @NotNull
    public VersionDetector getVersionDetector() {
        return this.versionDetector;
    }

    @Nullable
    public BukkitAudiences getAudiences() {
        return this.audiences;
    }

    @NotNull
    public String toLegacyString(@NotNull Component component) {
        return LEGACY_SERIALIZER.serialize(component);
    }

    public boolean isModern() {
        return this.versionDetector.isModern();
    }

    public boolean isLegacy() {
        return this.versionDetector.isLegacy();
    }

    private void sendBedrockMessage(@NotNull Player player, @NotNull Component component) {
        Component strippedComponent = BedrockConverter.stripUnsupportedFormatting(component);
        if (this.audiences != null) {
            this.audiences.player(player).sendMessage(strippedComponent);
        } else {
            String legacyMessage = LEGACY_SERIALIZER.serialize(strippedComponent);
            player.sendMessage(legacyMessage);
        }
    }

    private boolean isBedrockSupportEnabled() {
        return this.configuration == null || this.configuration.bedrockSupportEnabled();
    }

    private boolean isBedrockPlayer(@NotNull Player player) {
        return this.bedrockDetectionCache != null && this.bedrockDetectionCache.isBedrockPlayer(player);
    }
}

