/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.core;

import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class VersionDetector {
    private static final Logger LOGGER = Logger.getLogger(VersionDetector.class.getName());
    private final boolean isPaper;
    private final boolean isPurpur;
    private final boolean isFolia;
    private final boolean isSpigot;
    private final boolean isBukkit;
    private final String serverVersion;
    private final String minecraftVersion;
    private final boolean isModern;
    private final ServerType serverType;

    public VersionDetector() {
        LOGGER.info("Detecting server environment...");
        this.isFolia = this.detectFolia();
        this.isPurpur = !this.isFolia && this.detectPurpur();
        this.isPaper = !this.isFolia && !this.isPurpur && this.detectPaper();
        this.isSpigot = !this.isPaper && !this.isPurpur && !this.isFolia && this.detectSpigot();
        boolean bl = this.isBukkit = !this.isPaper && !this.isPurpur && !this.isFolia && !this.isSpigot;
        this.serverType = this.isFolia ? ServerType.FOLIA : (this.isPurpur ? ServerType.PURPUR : (this.isPaper ? ServerType.PAPER : (this.isSpigot ? ServerType.SPIGOT : ServerType.BUKKIT)));
        this.minecraftVersion = this.detectMinecraftVersion();
        this.serverVersion = this.detectServerVersion();
        this.isModern = this.detectModernVersion();
        this.logDetectionResults();
    }

    private boolean detectFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean detectPurpur() {
        try {
            Class.forName("org.purpurmc.purpur.PurpurConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean detectPaper() {
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            return true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("io.papermc.paper.configuration.Configuration");
                return true;
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
        }
    }

    private boolean detectSpigot() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @NotNull
    private String detectMinecraftVersion() {
        try {
            return Bukkit.getVersion();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to detect Minecraft version: " + e.getMessage());
            return "unknown";
        }
    }

    @NotNull
    private String detectServerVersion() {
        try {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String[] parts = packageName.split("\\.");
            if (parts.length > 3) {
                return parts[3];
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to detect server version: " + e.getMessage());
        }
        return "unknown";
    }

    private boolean detectModernVersion() {
        if ("unknown".equals(this.serverVersion)) {
            return true;
        }
        try {
            String[] parts = this.serverVersion.substring(1).split("_");
            if (parts.length >= 2) {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                return major > 1 || major == 1 && minor >= 13;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to parse server version for modernity check: " + e.getMessage());
        }
        return true;
    }

    private void logDetectionResults() {
        LOGGER.info("=== Server Environment Detection ===");
        LOGGER.info("Server Type: " + this.serverType.getDisplayName());
        LOGGER.info("Minecraft Version: " + this.minecraftVersion);
        LOGGER.info("Server Version: " + this.serverVersion);
        LOGGER.info("Modern (1.13+): " + this.isModern);
        LOGGER.info("Native Adventure: " + this.hasNativeAdventure());
        LOGGER.info("===================================");
    }

    public boolean hasNativeAdventure() {
        return this.isPaper || this.isPurpur || this.isFolia;
    }

    public boolean requiresAdventurePlatform() {
        return !this.hasNativeAdventure();
    }

    public boolean isModern() {
        return this.isModern;
    }

    public boolean isLegacy() {
        return !this.isModern;
    }

    @NotNull
    public ServerType getServerType() {
        return this.serverType;
    }

    @NotNull
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @NotNull
    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isPaper() {
        return this.isPaper;
    }

    public boolean isPurpur() {
        return this.isPurpur;
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    public boolean isSpigot() {
        return this.isSpigot;
    }

    public boolean isBukkit() {
        return this.isBukkit;
    }

    public boolean hasClass(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isVersionAtLeast(@NotNull String targetVersion) {
        if ("unknown".equals(this.serverVersion)) {
            return false;
        }
        try {
            return this.compareVersions(this.serverVersion, targetVersion) >= 0;
        }
        catch (Exception e) {
            LOGGER.warning("Failed to compare versions: " + e.getMessage());
            return false;
        }
    }

    private int compareVersions(@NotNull String version1, @NotNull String version2) {
        int[] v2;
        int[] v1 = this.parseVersion(version1);
        if (v1[0] != (v2 = this.parseVersion(version2))[0]) {
            return Integer.compare(v1[0], v2[0]);
        }
        if (v1[1] != v2[1]) {
            return Integer.compare(v1[1], v2[1]);
        }
        return Integer.compare(v1[2], v2[2]);
    }

    private int[] parseVersion(@NotNull String version) {
        String clean = version.startsWith("v") ? version.substring(1) : version;
        String[] parts = clean.split("_");
        int major = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
        int minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        int revision = 0;
        if (parts.length > 2) {
            String revPart = parts[2];
            revision = revPart.startsWith("R") ? Integer.parseInt(revPart.substring(1)) : Integer.parseInt(revPart);
        }
        return new int[]{major, minor, revision};
    }

    @NotNull
    public String getEnvironmentSummary() {
        return String.format("%s %s (MC: %s, Modern: %s, Adventure: %s)", this.serverType.getDisplayName(), this.serverVersion, this.minecraftVersion, this.isModern ? "Yes" : "No", this.hasNativeAdventure() ? "Native" : "Platform");
    }

    public static enum ServerType {
        PAPER("Paper"),
        PURPUR("Purpur"),
        FOLIA("Folia"),
        SPIGOT("Spigot"),
        BUKKIT("Bukkit");

        private final String displayName;

        private ServerType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

