/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class TranslationMetrics {
    private final Map<String, AtomicLong> keyUsage = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> missingKeys = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> localeUsage = new ConcurrentHashMap<String, AtomicLong>();

    public void recordKeyUsage(@NotNull String key, @NotNull String locale) {
        this.keyUsage.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
        this.localeUsage.computeIfAbsent(locale, k -> new AtomicLong()).incrementAndGet();
    }

    public void recordMissingKey(@NotNull String key, @NotNull String locale) {
        String compositeKey = key + ":" + locale;
        this.missingKeys.computeIfAbsent(compositeKey, k -> new AtomicLong()).incrementAndGet();
    }

    @NotNull
    public List<Map.Entry<String, Long>> getMostUsedKeys(int limit) {
        return this.keyUsage.entrySet().stream().sorted((a, b) -> Long.compare(((AtomicLong)b.getValue()).get(), ((AtomicLong)a.getValue()).get())).limit(limit).map(e -> Map.entry((String)e.getKey(), ((AtomicLong)e.getValue()).get())).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, Long> getMissingKeyOccurrences() {
        return this.missingKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
    }

    @NotNull
    public Map<String, Long> getLocaleDistribution() {
        return this.localeUsage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
    }

    public long getTotalRequests() {
        return this.keyUsage.values().stream().mapToLong(AtomicLong::get).sum();
    }

    public long getTotalMissingKeyOccurrences() {
        return this.missingKeys.values().stream().mapToLong(AtomicLong::get).sum();
    }

    public int getUniqueKeyCount() {
        return this.keyUsage.size();
    }

    public int getUniqueMissingKeyCount() {
        return this.missingKeys.size();
    }

    public void reset() {
        this.keyUsage.clear();
        this.missingKeys.clear();
        this.localeUsage.clear();
    }
}

