/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class TranslationExportService {
    private static final Logger LOGGER = Logger.getLogger(TranslationExportService.class.getName());
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final Yaml yamlWriter;

    public TranslationExportService() {
        this.jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setIndent(2);
        this.yamlWriter = new Yaml(dumperOptions);
    }

    public void export(@NotNull Path outputPath, @NotNull ExportFormat format, @NotNull Map<String, Map<String, List<String>>> translations) throws IOException {
        Objects.requireNonNull(outputPath, "outputPath must not be null");
        Objects.requireNonNull(format, "format must not be null");
        Objects.requireNonNull(translations, "translations must not be null");
        Path parentDir = outputPath.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        switch (format.ordinal()) {
            case 0: {
                this.exportCsv(outputPath, translations);
                break;
            }
            case 1: {
                this.exportJson(outputPath, translations);
                break;
            }
            case 2: {
                this.exportYaml(outputPath, translations);
            }
        }
        LOGGER.info(String.format("Exported %d translation keys to %s in %s format", new Object[]{translations.size(), outputPath.getFileName(), format}));
    }

    private void exportCsv(@NotNull Path outputPath, @NotNull Map<String, Map<String, List<String>>> translations) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
            writer.write("key,locale,value");
            writer.newLine();
            ArrayList<String> sortedKeys = new ArrayList<String>(translations.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                Map<String, List<String>> localeMap = translations.get(key);
                if (localeMap == null) continue;
                ArrayList<String> sortedLocales = new ArrayList<String>(localeMap.keySet());
                Collections.sort(sortedLocales);
                for (String locale : sortedLocales) {
                    List<String> values = localeMap.get(locale);
                    if (values == null || values.isEmpty()) continue;
                    String value = String.join((CharSequence)"\\n", values);
                    writer.write(String.format("\"%s\",\"%s\",\"%s\"", this.escapeCsv(key), this.escapeCsv(locale), this.escapeCsv(value)));
                    writer.newLine();
                }
            }
        }
    }

    @NotNull
    private String escapeCsv(@NotNull String value) {
        return value.replace("\"", "\"\"");
    }

    private void exportJson(@NotNull Path outputPath, @NotNull Map<String, Map<String, List<String>>> translations) throws IOException {
        TreeMap<String, Map> byLocale = new TreeMap<String, Map>();
        for (Map.Entry<String, Map<String, List<String>>> keyEntry : translations.entrySet()) {
            String key = keyEntry.getKey();
            Map<String, List<String>> localeMap = keyEntry.getValue();
            for (Map.Entry<String, List<String>> localeEntry : localeMap.entrySet()) {
                String locale = localeEntry.getKey();
                List<String> values = localeEntry.getValue();
                if (values == null || values.isEmpty()) continue;
                String value = String.join((CharSequence)"\n", values);
                byLocale.computeIfAbsent(locale, k -> new TreeMap()).put(key, value);
            }
        }
        this.jsonMapper.writeValue(outputPath.toFile(), byLocale);
    }

    private void exportYaml(@NotNull Path outputPath, @NotNull Map<String, Map<String, List<String>>> translations) throws IOException {
        TreeMap<String, Map> byLocale = new TreeMap<String, Map>();
        for (Map.Entry<String, Map<String, List<String>>> keyEntry : translations.entrySet()) {
            String key = keyEntry.getKey();
            Map<String, List<String>> localeMap = keyEntry.getValue();
            for (Map.Entry<String, List<String>> localeEntry : localeMap.entrySet()) {
                String locale = localeEntry.getKey();
                List<String> values = localeEntry.getValue();
                if (values == null || values.isEmpty()) continue;
                Object value = values.size() == 1 ? values.get(0) : new ArrayList<String>(values);
                byLocale.computeIfAbsent(locale, k -> new TreeMap()).put(key, value);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
            this.yamlWriter.dump(byLocale, (Writer)writer);
        }
    }

    @NotNull
    public static String getFileExtension(@NotNull ExportFormat format) {
        return switch (format.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ".csv";
            case 1 -> ".json";
            case 2 -> ".yml";
        };
    }

    @NotNull
    public static Optional<ExportFormat> parseFormat(@NotNull String formatString) {
        try {
            return Optional.of(ExportFormat.valueOf(formatString.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static enum ExportFormat {
        CSV,
        JSON,
        YAML;

    }
}

