/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.core;

import de.jexcellence.jextranslate.config.R18nConfiguration;
import de.jexcellence.jextranslate.core.TranslationLoader;
import de.jexcellence.jextranslate.core.TranslationMetrics;
import de.jexcellence.jextranslate.core.VersionDetector;
import de.jexcellence.remapped.com.github.benmanes.caffeine.cache.Cache;
import de.jexcellence.remapped.com.github.benmanes.caffeine.cache.Caffeine;
import de.jexcellence.remapped.com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageProvider {
    private static final String PREFIX_KEY = "prefix";
    private final R18nConfiguration configuration;
    private final VersionDetector versionDetector;
    private final MiniMessage miniMessage;
    private final LegacyComponentSerializer legacySerializer;
    private final PlainTextComponentSerializer plainSerializer;
    private final boolean placeholderAPIAvailable;
    @Nullable
    private final Cache<CacheKey, Component> componentCache;
    @Nullable
    private final TranslationMetrics metrics;
    private TranslationLoader translationLoader;

    public MessageProvider(@NotNull R18nConfiguration configuration, @Nullable VersionDetector versionDetector) {
        this.configuration = configuration;
        this.versionDetector = versionDetector;
        this.miniMessage = MiniMessage.miniMessage();
        this.legacySerializer = LegacyComponentSerializer.legacySection();
        this.plainSerializer = PlainTextComponentSerializer.plainText();
        this.placeholderAPIAvailable = configuration.placeholderAPIEnabled() && versionDetector != null && versionDetector.hasClass("me.clip.placeholderapi.PlaceholderAPI");
        this.componentCache = configuration.cacheEnabled() ? Caffeine.newBuilder().maximumSize((long)configuration.cacheMaxSize()).expireAfterAccess((long)configuration.cacheExpireMinutes(), TimeUnit.MINUTES).recordStats().build() : null;
        this.metrics = configuration.metricsEnabled() ? new TranslationMetrics() : null;
    }

    @NotNull
    public Component getComponent(@NotNull String key, @NotNull String locale, @NotNull Map<String, Object> placeholders, boolean includePrefix) {
        if (this.componentCache != null) {
            int placeholderHash = this.computePlaceholderHash(placeholders, includePrefix);
            CacheKey cacheKey = new CacheKey(key, locale, placeholderHash);
            Component cached = (Component)this.componentCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            List<Component> components = this.getComponents(key, locale, placeholders, includePrefix);
            Component result = this.joinComponents(components);
            if (!components.isEmpty()) {
                this.componentCache.put((Object)cacheKey, (Object)result);
            }
            return result;
        }
        List<Component> components = this.getComponents(key, locale, placeholders, includePrefix);
        return this.joinComponents(components);
    }

    private int computePlaceholderHash(@NotNull Map<String, Object> placeholders, boolean includePrefix) {
        int hash = Boolean.hashCode(includePrefix);
        for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
            hash = 31 * hash + entry.getKey().hashCode();
            hash = 31 * hash + Objects.hashCode(entry.getValue());
        }
        return hash;
    }

    @NotNull
    public List<Component> getComponents(@NotNull String key, @NotNull String locale, @NotNull Map<String, Object> placeholders, boolean includePrefix) {
        List<String> rawMessages = this.getRawMessages(key, locale, placeholders);
        if (rawMessages.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        if (includePrefix) {
            List<String> prefixMessages = this.getRawMessages(PREFIX_KEY, locale, placeholders);
            for (String prefixMessage : prefixMessages) {
                String processed = this.processPlaceholders(prefixMessage, placeholders);
                components.add(this.parseMessage(processed));
            }
        }
        for (String message : rawMessages) {
            String processed = this.processPlaceholders(message, placeholders);
            components.add(this.parseMessage(processed));
        }
        return components;
    }

    @NotNull
    public String getString(@NotNull String key, @NotNull String locale, @NotNull Map<String, Object> placeholders, boolean includePrefix) {
        Component component = this.getComponent(key, locale, placeholders, includePrefix);
        return this.plainSerializer.serialize(component);
    }

    @NotNull
    public List<String> getStrings(@NotNull String key, @NotNull String locale, @NotNull Map<String, Object> placeholders, boolean includePrefix) {
        List<Component> components = this.getComponents(key, locale, placeholders, includePrefix);
        return components.stream().map(arg_0 -> ((PlainTextComponentSerializer)this.plainSerializer).serialize(arg_0)).toList();
    }

    @NotNull
    private List<String> getRawMessages(@NotNull String key, @NotNull String locale, @NotNull Map<String, Object> placeholders) {
        if (this.translationLoader == null) {
            this.recordMissingKeyMetric(key, locale);
            return this.handleMissingKey(key, locale, placeholders);
        }
        Optional<List<String>> translation = this.translationLoader.getRawTranslation(key, locale);
        if (translation.isPresent()) {
            this.recordKeyUsageMetric(key, locale);
            return translation.get();
        }
        this.recordMissingKeyMetric(key, locale);
        return this.handleMissingKey(key, locale, placeholders);
    }

    private void recordKeyUsageMetric(@NotNull String key, @NotNull String locale) {
        if (this.metrics != null) {
            this.metrics.recordKeyUsage(key, locale);
        }
    }

    private void recordMissingKeyMetric(@NotNull String key, @NotNull String locale) {
        if (this.metrics != null) {
            this.metrics.recordMissingKey(key, locale);
        }
    }

    @NotNull
    private List<String> handleMissingKey(@NotNull String key, @NotNull String locale, @NotNull Map<String, Object> placeholders) {
        R18nConfiguration.MissingKeyHandler handler = this.configuration.missingKeyHandler();
        String fallbackMessage = handler.handle(key, locale, placeholders);
        if (fallbackMessage == null) {
            return List.of();
        }
        return List.of(fallbackMessage);
    }

    @NotNull
    private String processPlaceholders(@NotNull String message, @NotNull Map<String, Object> placeholders) {
        String processed = message;
        for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            if (this.configuration.legacyColorSupport()) {
                value = this.convertLegacyColors(value);
            }
            value = this.escapeMiniMessage(value);
            processed = processed.replace("{" + key + "}", value);
            processed = processed.replace("%" + key + "%", value);
        }
        return processed;
    }

    @NotNull
    private Component parseMessage(@NotNull String message) {
        try {
            String converted = this.configuration.legacyColorSupport() ? this.convertLegacyColors(message) : message;
            return this.miniMessage.deserialize((Object)converted);
        }
        catch (Exception e) {
            return Component.text((String)message);
        }
    }

    @NotNull
    private String convertLegacyColors(@NotNull String text) {
        if (!this.configuration.legacyColorSupport()) {
            return text;
        }
        String converted = text.replace("&", "\u00a7");
        converted = converted.replace("\u00a70", "<black>").replace("\u00a71", "<dark_blue>").replace("\u00a72", "<dark_green>").replace("\u00a73", "<dark_aqua>").replace("\u00a74", "<dark_red>").replace("\u00a75", "<dark_purple>").replace("\u00a76", "<gold>").replace("\u00a77", "<gray>").replace("\u00a78", "<dark_gray>").replace("\u00a79", "<blue>").replace("\u00a7a", "<green>").replace("\u00a7b", "<aqua>").replace("\u00a7c", "<red>").replace("\u00a7d", "<light_purple>").replace("\u00a7e", "<yellow>").replace("\u00a7f", "<white>").replace("\u00a7k", "<obfuscated>").replace("\u00a7l", "<bold>").replace("\u00a7m", "<strikethrough>").replace("\u00a7n", "<underlined>").replace("\u00a7o", "<italic>").replace("\u00a7r", "<reset>");
        return converted;
    }

    @NotNull
    private String escapeMiniMessage(@NotNull String text) {
        return text.replace("<", "\\<").replace(">", "\\>");
    }

    @NotNull
    private Component joinComponents(@NotNull List<Component> components) {
        if (components.isEmpty()) {
            return Component.empty();
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        Component result = components.get(0);
        for (int i = 1; i < components.size(); ++i) {
            result = result.appendNewline().append(components.get(i));
        }
        return result;
    }

    public void setTranslationLoader(@NotNull TranslationLoader translationLoader) {
        this.translationLoader = translationLoader;
    }

    public boolean isPlaceholderAPIAvailable() {
        return this.placeholderAPIAvailable;
    }

    @NotNull
    public VersionDetector getVersionDetector() {
        return this.versionDetector;
    }

    @NotNull
    public R18nConfiguration getConfiguration() {
        return this.configuration;
    }

    public void invalidateCache() {
        if (this.componentCache != null) {
            this.componentCache.invalidateAll();
        }
    }

    @Nullable
    public CacheStats getCacheStats() {
        return this.componentCache != null ? this.componentCache.stats() : null;
    }

    public boolean isCacheEnabled() {
        return this.componentCache != null;
    }

    @Nullable
    public TranslationMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    public record CacheKey(@NotNull String key, @NotNull String locale, int placeholderHash) {
        public CacheKey(@NotNull String key, @NotNull String locale, int placeholderHash) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(locale, "locale cannot be null");
        }
    }
}

