/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.config;

import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.jextranslate.config.R18nConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@CSAlways
public class R18nSection {
    private String defaultLanguage;
    private List<String> supportedLanguages;
    private Map<String, Object> settings;

    @NotNull
    public String getDefaultLanguage() {
        return this.defaultLanguage == null || this.defaultLanguage.isEmpty() ? "en_US" : this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @NotNull
    public List<String> getSupportedLanguages() {
        return this.supportedLanguages == null || this.supportedLanguages.isEmpty() ? Collections.singletonList(this.getDefaultLanguage()) : this.supportedLanguages;
    }

    public void setSupportedLanguages(List<String> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
    }

    @NotNull
    public Map<String, Object> getSettings() {
        return this.settings == null ? Collections.emptyMap() : this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    public boolean isValidateKeysEnabled() {
        return this.getBooleanSetting("validateKeys", true);
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.getBooleanSetting("placeholderAPI", false);
    }

    public boolean isLegacyColorsEnabled() {
        return this.getBooleanSetting("legacyColors", true);
    }

    public boolean isDebugEnabled() {
        return this.getBooleanSetting("debug", false);
    }

    public boolean isCacheTranslationsEnabled() {
        return this.getBooleanSetting("cacheTranslations", true);
    }

    @NotNull
    public R18nConfiguration toConfiguration() {
        return new R18nConfiguration.Builder().defaultLocale(this.getDefaultLanguage()).supportedLocales(this.getSupportedLanguages().toArray(new String[0])).keyValidationEnabled(this.isValidateKeysEnabled()).placeholderAPIEnabled(this.isPlaceholderAPIEnabled()).legacyColorSupport(this.isLegacyColorsEnabled()).debugMode(this.isDebugEnabled()).build();
    }

    private boolean getBooleanSetting(String key, boolean defaultValue) {
        if (this.settings == null) {
            return defaultValue;
        }
        Object value = this.settings.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }
}

