/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.config;

import de.jexcellence.jextranslate.bedrock.BedrockFormatMode;
import de.jexcellence.jextranslate.bedrock.HexColorFallback;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record R18nConfiguration(@NotNull String defaultLocale, @NotNull Set<String> supportedLocales, @NotNull String translationDirectory, boolean keyValidationEnabled, boolean placeholderAPIEnabled, boolean legacyColorSupport, boolean debugMode, boolean cacheEnabled, int cacheMaxSize, int cacheExpireMinutes, boolean watchFiles, boolean metricsEnabled, @NotNull MissingKeyHandler missingKeyHandler, boolean bedrockSupportEnabled, @NotNull HexColorFallback hexColorFallback, @NotNull BedrockFormatMode bedrockFormatMode) {
    public static final MissingKeyHandler DEFAULT_MISSING_KEY_HANDLER = (key, locale, placeholders) -> "<gold>Missing: <red>" + key + "</red></gold>";
    public static final Set<String> AUTO_DETECT_LOCALES = Set.of("*");

    public R18nConfiguration(@NotNull String defaultLocale, @NotNull Set<String> supportedLocales, @NotNull String translationDirectory, boolean keyValidationEnabled, boolean placeholderAPIEnabled, boolean legacyColorSupport, boolean debugMode, boolean cacheEnabled, int cacheMaxSize, int cacheExpireMinutes, boolean watchFiles, boolean metricsEnabled, @NotNull MissingKeyHandler missingKeyHandler, boolean bedrockSupportEnabled, @NotNull HexColorFallback hexColorFallback, @NotNull BedrockFormatMode bedrockFormatMode) {
        if (defaultLocale == null || defaultLocale.trim().isEmpty()) {
            throw new IllegalArgumentException("Default locale cannot be null or empty");
        }
        if (supportedLocales == null) {
            throw new IllegalArgumentException("Supported locales cannot be null");
        }
        if (!(supportedLocales.isEmpty() || supportedLocales.equals(AUTO_DETECT_LOCALES) || supportedLocales.contains(defaultLocale))) {
            throw new IllegalArgumentException("Default locale must be in supported locales (or use empty set for auto-detection)");
        }
        if (translationDirectory == null || translationDirectory.trim().isEmpty()) {
            throw new IllegalArgumentException("Translation directory cannot be null or empty");
        }
        if (cacheMaxSize < 0) {
            throw new IllegalArgumentException("Cache max size cannot be negative");
        }
        if (cacheExpireMinutes < 0) {
            throw new IllegalArgumentException("Cache expire minutes cannot be negative");
        }
        if (missingKeyHandler == null) {
            throw new IllegalArgumentException("Missing key handler cannot be null");
        }
        if (hexColorFallback == null) {
            throw new IllegalArgumentException("Hex color fallback cannot be null");
        }
        if (bedrockFormatMode == null) {
            throw new IllegalArgumentException("Bedrock format mode cannot be null");
        }
        supportedLocales = Collections.unmodifiableSet(new HashSet<String>(supportedLocales));
        defaultLocale = defaultLocale.trim();
        translationDirectory = translationDirectory.trim();
    }

    @NotNull
    public static R18nConfiguration defaultConfiguration() {
        return new R18nConfiguration("en_US", Set.of("en_US"), "translations", true, false, true, false, true, 1000, 30, false, false, DEFAULT_MISSING_KEY_HANDLER, true, HexColorFallback.NEAREST_LEGACY, BedrockFormatMode.CONSERVATIVE);
    }

    @NotNull
    public R18nConfiguration withDefaultLocale(@NotNull String defaultLocale) {
        HashSet<String> newSupportedLocales = new HashSet<String>(this.supportedLocales);
        newSupportedLocales.add(defaultLocale);
        return new R18nConfiguration(defaultLocale, newSupportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withAutoDetectLocales() {
        return new R18nConfiguration(this.defaultLocale, Set.of(), this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withSupportedLocales(String ... locales) {
        return this.withSupportedLocales(Set.of(locales));
    }

    @NotNull
    public R18nConfiguration withSupportedLocales(@NotNull Set<String> supportedLocales) {
        HashSet<String> newSupportedLocales = new HashSet<String>(supportedLocales);
        newSupportedLocales.add(this.defaultLocale);
        return new R18nConfiguration(this.defaultLocale, newSupportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withTranslationDirectory(@NotNull String translationDirectory) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withKeyValidationEnabled(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, enabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withPlaceholderAPIEnabled(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, enabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withLegacyColorSupport(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, enabled, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withDebugMode(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, enabled, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withCacheEnabled(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, enabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withCacheMaxSize(int maxSize) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, maxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withCacheExpireMinutes(int minutes) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, minutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withWatchFiles(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, enabled, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withMetricsEnabled(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, enabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withMissingKeyHandler(@NotNull MissingKeyHandler handler) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, handler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withBedrockSupportEnabled(boolean enabled) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, enabled, this.hexColorFallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withHexColorFallback(@NotNull HexColorFallback fallback) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, fallback, this.bedrockFormatMode);
    }

    @NotNull
    public R18nConfiguration withBedrockFormatMode(@NotNull BedrockFormatMode mode) {
        return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, mode);
    }

    public boolean isLocaleSupported(@NotNull String locale) {
        return this.supportedLocales.contains(locale);
    }

    @NotNull
    public String getBestMatchingLocale(@NotNull String locale) {
        if (this.supportedLocales.contains(locale)) {
            return locale;
        }
        String language = locale.split("[_-]")[0];
        if (this.supportedLocales.contains(language)) {
            return language;
        }
        for (String supported : this.supportedLocales) {
            if (!supported.startsWith(language + "_") && !supported.startsWith(language + "-")) continue;
            return supported;
        }
        return this.defaultLocale;
    }

    @NotNull
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @NotNull
    public Set<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder().defaultLocale(this.defaultLocale).supportedLocales(this.supportedLocales).translationDirectory(this.translationDirectory).keyValidationEnabled(this.keyValidationEnabled).placeholderAPIEnabled(this.placeholderAPIEnabled).legacyColorSupport(this.legacyColorSupport).debugMode(this.debugMode).enableCache(this.cacheEnabled).cacheMaxSize(this.cacheMaxSize).cacheExpireMinutes(this.cacheExpireMinutes).enableFileWatcher(this.watchFiles).enableMetrics(this.metricsEnabled).onMissingKey(this.missingKeyHandler).bedrockSupportEnabled(this.bedrockSupportEnabled).hexColorFallback(this.hexColorFallback).bedrockFormatMode(this.bedrockFormatMode);
    }

    @FunctionalInterface
    public static interface MissingKeyHandler {
        @Nullable
        public String handle(@NotNull String var1, @NotNull String var2, @NotNull Map<String, Object> var3);
    }

    public static final class Builder {
        private String defaultLocale = "en_US";
        private Set<String> supportedLocales = new HashSet<String>(Set.of("en_US"));
        private String translationDirectory = "translations";
        private boolean keyValidationEnabled = true;
        private boolean placeholderAPIEnabled = false;
        private boolean legacyColorSupport = true;
        private boolean debugMode = false;
        private boolean cacheEnabled = true;
        private int cacheMaxSize = 1000;
        private int cacheExpireMinutes = 30;
        private boolean watchFiles = false;
        private boolean metricsEnabled = false;
        private MissingKeyHandler missingKeyHandler = DEFAULT_MISSING_KEY_HANDLER;
        private boolean bedrockSupportEnabled = true;
        private HexColorFallback hexColorFallback = HexColorFallback.NEAREST_LEGACY;
        private BedrockFormatMode bedrockFormatMode = BedrockFormatMode.CONSERVATIVE;

        @NotNull
        public Builder defaultLocale(@NotNull String defaultLocale) {
            this.defaultLocale = defaultLocale;
            this.supportedLocales.add(defaultLocale);
            return this;
        }

        @NotNull
        public Builder supportedLocales(String ... locales) {
            return this.supportedLocales(Set.of(locales));
        }

        @NotNull
        public Builder supportedLocales(@NotNull Set<String> supportedLocales) {
            this.supportedLocales = new HashSet<String>(supportedLocales);
            this.supportedLocales.add(this.defaultLocale);
            return this;
        }

        @NotNull
        public Builder translationDirectory(@NotNull String translationDirectory) {
            this.translationDirectory = translationDirectory;
            return this;
        }

        @NotNull
        public Builder keyValidationEnabled(boolean enabled) {
            this.keyValidationEnabled = enabled;
            return this;
        }

        @NotNull
        public Builder placeholderAPIEnabled(boolean enabled) {
            this.placeholderAPIEnabled = enabled;
            return this;
        }

        @NotNull
        public Builder legacyColorSupport(boolean enabled) {
            this.legacyColorSupport = enabled;
            return this;
        }

        @NotNull
        public Builder debugMode(boolean enabled) {
            this.debugMode = enabled;
            return this;
        }

        @NotNull
        public Builder enableCache(boolean enabled) {
            this.cacheEnabled = enabled;
            return this;
        }

        @NotNull
        public Builder cacheMaxSize(int maxSize) {
            this.cacheMaxSize = maxSize;
            return this;
        }

        @NotNull
        public Builder cacheExpireMinutes(int minutes) {
            this.cacheExpireMinutes = minutes;
            return this;
        }

        @NotNull
        public Builder enableFileWatcher(boolean enabled) {
            this.watchFiles = enabled;
            return this;
        }

        @NotNull
        public Builder enableMetrics(boolean enabled) {
            this.metricsEnabled = enabled;
            return this;
        }

        @NotNull
        public Builder onMissingKey(@NotNull MissingKeyHandler handler) {
            this.missingKeyHandler = handler;
            return this;
        }

        @NotNull
        public Builder bedrockSupportEnabled(boolean enabled) {
            this.bedrockSupportEnabled = enabled;
            return this;
        }

        @NotNull
        public Builder hexColorFallback(@NotNull HexColorFallback fallback) {
            this.hexColorFallback = fallback;
            return this;
        }

        @NotNull
        public Builder bedrockFormatMode(@NotNull BedrockFormatMode mode) {
            this.bedrockFormatMode = mode;
            return this;
        }

        @NotNull
        public R18nConfiguration build() {
            return new R18nConfiguration(this.defaultLocale, this.supportedLocales, this.translationDirectory, this.keyValidationEnabled, this.placeholderAPIEnabled, this.legacyColorSupport, this.debugMode, this.cacheEnabled, this.cacheMaxSize, this.cacheExpireMinutes, this.watchFiles, this.metricsEnabled, this.missingKeyHandler, this.bedrockSupportEnabled, this.hexColorFallback, this.bedrockFormatMode);
        }
    }
}

