/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.command;

import de.jexcellence.jextranslate.R18nManager;
import de.jexcellence.jextranslate.command.ER18nPermission;
import de.jexcellence.jextranslate.core.TranslationExportService;
import de.jexcellence.jextranslate.core.TranslationLoader;
import de.jexcellence.jextranslate.core.TranslationMetrics;
import de.jexcellence.jextranslate.core.VersionedMessageSender;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PR18nCommand
implements CommandExecutor,
TabCompleter {
    private static final List<String> SUBCOMMANDS = List.of("reload", "missing", "export", "metrics", "help");
    private static final List<String> EXPORT_FORMATS = List.of("csv", "json", "yaml");
    private static final int KEYS_PER_PAGE = 12;
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final JavaPlugin loadedPlugin;
    private final R18nManager r18nManager;
    private final VersionedMessageSender messageSender;
    private final TranslationExportService exportService;

    public PR18nCommand(@NotNull JavaPlugin loadedPlugin, @NotNull R18nManager r18nManager) {
        this.loadedPlugin = loadedPlugin;
        this.r18nManager = r18nManager;
        this.messageSender = r18nManager.getMessageSender();
        this.exportService = new TranslationExportService();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        Player player;
        boolean isPlayer = sender instanceof Player;
        Player player2 = player = isPlayer ? (Player)sender : null;
        if (args.length == 3 && "missing".equalsIgnoreCase(args[0])) {
            if (isPlayer) {
                this.handlePaginationRouting(player, args[1], args[2]);
            } else {
                this.handleConsoleMissingSubcommand(sender, args);
            }
            return true;
        }
        if (args.length == 0) {
            if (isPlayer) {
                this.sendEnhancedUsageMessage(player);
            } else {
                this.sendConsoleUsageMessage(sender);
            }
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                if (isPlayer) {
                    this.handleReloadSubcommand(player);
                    break;
                }
                this.handleConsoleReloadSubcommand(sender);
                break;
            }
            case "missing": {
                if (isPlayer) {
                    this.handleMissingSubcommand(player, args);
                    break;
                }
                this.handleConsoleMissingSubcommand(sender, args);
                break;
            }
            case "export": {
                this.handleExportSubcommand(sender, args, isPlayer, player);
                break;
            }
            case "metrics": {
                this.handleMetricsSubcommand(sender, isPlayer, player);
                break;
            }
            default: {
                if (isPlayer) {
                    this.sendEnhancedUsageMessage(player);
                    break;
                }
                this.sendConsoleUsageMessage(sender);
            }
        }
        return true;
    }

    private void handlePaginationRouting(@NotNull Player player, @NotNull String localeArg, @NotNull String pageArg) {
        if (!player.hasPermission(ER18nPermission.MISSING.getFallbackNode())) {
            return;
        }
        try {
            int page = Integer.parseInt(pageArg);
            this.displayMissingKeysForLocale(player, localeArg, page);
        }
        catch (NumberFormatException e) {
            this.sendEnhancedUsageMessage(player);
        }
    }

    private void handleReloadSubcommand(@NotNull Player player) {
        if (!player.hasPermission(ER18nPermission.RELOAD.getFallbackNode())) {
            this.sendNoPermission(player);
            return;
        }
        this.reloadTranslationsWithEnhancedFeedback(player);
    }

    private void handleMissingSubcommand(@NotNull Player player, @NotNull String[] args) {
        if (!player.hasPermission(ER18nPermission.MISSING.getFallbackNode())) {
            this.sendNoPermission(player);
            return;
        }
        if (args.length > 1) {
            int page = args.length > 2 ? this.parsePageNumber(args[2]) : 1;
            this.displayMissingKeysForLocale(player, args[1], page);
        } else {
            this.displayEnhancedLocaleSelection(player);
        }
    }

    private int parsePageNumber(String arg) {
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private void sendNoPermission(@NotNull Player player) {
        Component msg = MINI_MESSAGE.deserialize((Object)"<red>You don't have permission to use this command.</red>");
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, msg);
        }
    }

    private void handleExportSubcommand(@NotNull CommandSender sender, @NotNull String[] args, boolean isPlayer, @Nullable Player player) {
        if (!sender.hasPermission(ER18nPermission.EXPORT.getFallbackNode())) {
            if (isPlayer && player != null) {
                this.sendNoPermission(player);
            } else {
                sender.sendMessage("[R18n] You don't have permission to use this command.");
            }
            return;
        }
        if (args.length < 2) {
            this.sendExportUsage(sender, isPlayer, player);
            return;
        }
        String formatArg = args[1].toUpperCase();
        Optional<TranslationExportService.ExportFormat> formatOpt = TranslationExportService.parseFormat(formatArg);
        if (formatOpt.isEmpty()) {
            if (isPlayer && player != null) {
                Component errorMsg = MINI_MESSAGE.deserialize((Object)("<red>Invalid export format: <white>" + args[1] + "</white></red>\n<gray>Valid formats: <yellow>csv</yellow>, <yellow>json</yellow>, <yellow>yaml</yellow></gray>"));
                if (this.messageSender != null) {
                    this.messageSender.sendMessage(player, errorMsg);
                }
            } else {
                sender.sendMessage("[R18n] Invalid export format: " + args[1]);
                sender.sendMessage("[R18n] Valid formats: csv, json, yaml");
            }
            return;
        }
        TranslationExportService.ExportFormat format = formatOpt.get();
        this.performExport(sender, format, isPlayer, player);
    }

    private void sendExportUsage(@NotNull CommandSender sender, boolean isPlayer, @Nullable Player player) {
        if (isPlayer && player != null) {
            Component usage = MINI_MESSAGE.deserialize((Object)"<gradient:#f39c12:#e67e22>\ud83d\udce4 Export Usage</gradient>\n<gray>Usage: <yellow>/r18n export <format></yellow></gray>\n<gray>Formats: <green>csv</green>, <green>json</green>, <green>yaml</green></gray>");
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, usage);
            }
        } else {
            sender.sendMessage("[R18n] Usage: /r18n export <format>");
            sender.sendMessage("[R18n] Formats: csv, json, yaml");
        }
    }

    private void performExport(@NotNull CommandSender sender, @NotNull TranslationExportService.ExportFormat format, boolean isPlayer, @Nullable Player player) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String fileName = "translations_" + timestamp + TranslationExportService.getFileExtension(format);
        Path exportPath = this.loadedPlugin.getDataFolder().toPath().resolve(fileName);
        Map<String, Map<String, List<String>>> translations = this.r18nManager.getTranslationLoader().getAllTranslations();
        if (isPlayer && player != null) {
            Component exportingMsg = MINI_MESSAGE.deserialize((Object)("<gradient:#f39c12:#e67e22>\ud83d\udce4 Exporting translations to " + String.valueOf((Object)format) + " format...</gradient>"));
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, exportingMsg);
            }
        } else {
            sender.sendMessage("[R18n] Exporting translations to " + String.valueOf((Object)format) + " format...");
        }
        try {
            this.exportService.export(exportPath, format, translations);
            int keyCount = translations.size();
            HashSet<String> locales = new HashSet<String>();
            for (Map<String, List<String>> localeMap : translations.values()) {
                locales.addAll(localeMap.keySet());
            }
            if (isPlayer && player != null) {
                Component successMsg = MINI_MESSAGE.deserialize((Object)("<gradient:#2ecc71:#27ae60>\u2713 Export Complete!</gradient>\n<gray>Exported <white>" + keyCount + "</white> keys across <white>" + locales.size() + "</white> locales</gray>\n<gray>File: <yellow>" + fileName + "</yellow></gray>"));
                if (this.messageSender != null) {
                    this.messageSender.sendMessage(player, successMsg);
                }
            } else {
                sender.sendMessage("[R18n] Export Complete!");
                sender.sendMessage("[R18n] Exported " + keyCount + " keys across " + locales.size() + " locales");
                sender.sendMessage("[R18n] File: " + String.valueOf(exportPath.toAbsolutePath()));
            }
        }
        catch (IOException e) {
            this.loadedPlugin.getLogger().log(Level.SEVERE, "Failed to export translations", e);
            if (isPlayer && player != null) {
                Component errorMsg = MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u2717 Export Failed!</gradient>\n<gray>An error occurred while exporting translations.</gray>\n<gray>Check the console for details.</gray>");
                if (this.messageSender != null) {
                    this.messageSender.sendMessage(player, errorMsg);
                }
            }
            sender.sendMessage("[R18n] Export Failed!");
            sender.sendMessage("[R18n] Error: " + e.getMessage());
        }
    }

    private void handleMetricsSubcommand(@NotNull CommandSender sender, boolean isPlayer, @Nullable Player player) {
        if (!sender.hasPermission(ER18nPermission.METRICS.getFallbackNode())) {
            if (isPlayer && player != null) {
                this.sendNoPermission(player);
            } else {
                sender.sendMessage("[R18n] You don't have permission to use this command.");
            }
            return;
        }
        TranslationMetrics metrics = this.r18nManager.getMetrics();
        if (metrics == null) {
            if (isPlayer && player != null) {
                Component msg = MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u2717 Metrics Disabled</gradient>\n<gray>Translation metrics are not enabled in the configuration.</gray>\n<gray>Enable metrics with <yellow>metricsEnabled: true</yellow> in your config.</gray>");
                if (this.messageSender != null) {
                    this.messageSender.sendMessage(player, msg);
                }
            } else {
                sender.sendMessage("[R18n] Metrics are not enabled in the configuration.");
                sender.sendMessage("[R18n] Enable metrics with metricsEnabled: true");
            }
            return;
        }
        if (isPlayer && player != null) {
            this.displayPlayerMetrics(player, metrics);
        } else {
            this.displayConsoleMetrics(sender, metrics);
        }
    }

    private void displayPlayerMetrics(@NotNull Player player, @NotNull TranslationMetrics metrics) {
        Map<String, Long> missingKeys;
        Map<String, Long> localeDistribution;
        List<Map.Entry<String, Long>> topKeys;
        Component headerLine = MINI_MESSAGE.deserialize((Object)"<gradient:#3498db:#2980b9>\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac</gradient>");
        Component title = MINI_MESSAGE.deserialize((Object)"<gradient:#3498db:#2980b9>\ud83d\udcca Translation Metrics</gradient>");
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, title);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
        Component summaryTitle = MINI_MESSAGE.deserialize((Object)"<gradient:#9b59b6:#8e44ad>\ud83d\udcc8 Summary</gradient>");
        Component totalRequests = MINI_MESSAGE.deserialize((Object)("<dark_gray>\u25aa <gray>Total Requests: <white>" + metrics.getTotalRequests() + "</white></gray>"));
        Component uniqueKeys = MINI_MESSAGE.deserialize((Object)("<dark_gray>\u25aa <gray>Unique Keys Used: <white>" + metrics.getUniqueKeyCount() + "</white></gray>"));
        Component missingOccurrences = MINI_MESSAGE.deserialize((Object)("<dark_gray>\u25aa <gray>Missing Key Occurrences: <red>" + metrics.getTotalMissingKeyOccurrences() + "</red></gray>"));
        Component uniqueMissing = MINI_MESSAGE.deserialize((Object)("<dark_gray>\u25aa <gray>Unique Missing Keys: <red>" + metrics.getUniqueMissingKeyCount() + "</red></gray>"));
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, summaryTitle);
            this.messageSender.sendMessage(player, totalRequests);
            this.messageSender.sendMessage(player, uniqueKeys);
            this.messageSender.sendMessage(player, missingOccurrences);
            this.messageSender.sendMessage(player, uniqueMissing);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
        if (!(topKeys = metrics.getMostUsedKeys(5)).isEmpty()) {
            Component topKeysTitle = MINI_MESSAGE.deserialize((Object)"<gradient:#2ecc71:#27ae60>\ud83d\udd11 Top Used Keys</gradient>");
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, topKeysTitle);
            }
            for (int i = 0; i < topKeys.size(); ++i) {
                Map.Entry<String, Long> entry2 = topKeys.get(i);
                Component keyLine = MINI_MESSAGE.deserialize((Object)("<dark_gray>" + (i + 1) + ". <gray>" + entry2.getKey() + " <dark_gray>- <white>" + String.valueOf(entry2.getValue()) + "</white> uses</gray>"));
                if (this.messageSender == null) continue;
                this.messageSender.sendMessage(player, keyLine);
            }
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, (Component)Component.empty());
            }
        }
        if (!(localeDistribution = metrics.getLocaleDistribution()).isEmpty()) {
            Component localeTitle = MINI_MESSAGE.deserialize((Object)"<gradient:#f39c12:#e67e22>\ud83c\udf10 Locale Distribution</gradient>");
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, localeTitle);
            }
            localeDistribution.entrySet().stream().sorted((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue())).limit(5L).forEach(entry -> {
                Component localeLine = MINI_MESSAGE.deserialize((Object)("<dark_gray>\u25aa <gray>" + ((String)entry.getKey()).toUpperCase() + ": <white>" + String.valueOf(entry.getValue()) + "</white> requests</gray>"));
                if (this.messageSender != null) {
                    this.messageSender.sendMessage(player, localeLine);
                }
            });
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, (Component)Component.empty());
            }
        }
        if (!(missingKeys = metrics.getMissingKeyOccurrences()).isEmpty()) {
            Component missingTitle = MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u26a0 Most Frequent Missing Keys</gradient>");
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, missingTitle);
            }
            missingKeys.entrySet().stream().sorted((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue())).limit(5L).forEach(entry -> {
                Component missingLine = MINI_MESSAGE.deserialize((Object)("<dark_gray>\u25aa <red>" + (String)entry.getKey() + "</red> <dark_gray>- <white>" + String.valueOf(entry.getValue()) + "</white> times</gray>"));
                if (this.messageSender != null) {
                    this.messageSender.sendMessage(player, missingLine);
                }
            });
        }
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
    }

    private void displayConsoleMetrics(@NotNull CommandSender sender, @NotNull TranslationMetrics metrics) {
        Map<String, Long> missingKeys;
        Map<String, Long> localeDistribution;
        sender.sendMessage("========== Translation Metrics ==========");
        sender.sendMessage("");
        sender.sendMessage("--- Summary ---");
        sender.sendMessage("Total Requests: " + metrics.getTotalRequests());
        sender.sendMessage("Unique Keys Used: " + metrics.getUniqueKeyCount());
        sender.sendMessage("Missing Key Occurrences: " + metrics.getTotalMissingKeyOccurrences());
        sender.sendMessage("Unique Missing Keys: " + metrics.getUniqueMissingKeyCount());
        sender.sendMessage("");
        List<Map.Entry<String, Long>> topKeys = metrics.getMostUsedKeys(5);
        if (!topKeys.isEmpty()) {
            sender.sendMessage("--- Top Used Keys ---");
            for (int i = 0; i < topKeys.size(); ++i) {
                Map.Entry<String, Long> entry2 = topKeys.get(i);
                sender.sendMessage(i + 1 + ". " + entry2.getKey() + " - " + String.valueOf(entry2.getValue()) + " uses");
            }
            sender.sendMessage("");
        }
        if (!(localeDistribution = metrics.getLocaleDistribution()).isEmpty()) {
            sender.sendMessage("--- Locale Distribution ---");
            localeDistribution.entrySet().stream().sorted((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue())).limit(5L).forEach(entry -> sender.sendMessage("  " + ((String)entry.getKey()).toUpperCase() + ": " + String.valueOf(entry.getValue()) + " requests"));
            sender.sendMessage("");
        }
        if (!(missingKeys = metrics.getMissingKeyOccurrences()).isEmpty()) {
            sender.sendMessage("--- Most Frequent Missing Keys ---");
            missingKeys.entrySet().stream().sorted((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue())).limit(5L).forEach(entry -> sender.sendMessage("  " + (String)entry.getKey() + " - " + String.valueOf(entry.getValue()) + " times"));
        }
        sender.sendMessage("=========================================");
    }

    private void displayEnhancedLocaleSelection(@NotNull Player player) {
        Set<String> availableLocales = this.getAvailableLocales();
        Component headerLine = MINI_MESSAGE.deserialize((Object)"<gradient:#9b59b6:#e74c3c>\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac</gradient>");
        Component title = MINI_MESSAGE.deserialize((Object)"<gradient:#9b59b6:#8e44ad>\ud83c\udf10 Translation Keys Browser</gradient>");
        Component subtitle = MINI_MESSAGE.deserialize((Object)"<gray>Select a locale to analyze missing translation keys</gray>");
        Component instructions = MINI_MESSAGE.deserialize((Object)"<dark_gray>\u25aa <yellow>Click</yellow> <dark_gray>\u00bb</dark_gray> <gray>View missing keys for locale</gray>");
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, title);
            this.messageSender.sendMessage(player, subtitle);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, instructions);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
        this.sendLocaleButtonsGrid(player, availableLocales);
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
    }

    private void sendLocaleButtonsGrid(@NotNull Player player, @NotNull Set<String> locales) {
        ArrayList<String> localeList = new ArrayList<String>(locales);
        int buttonsPerRow = 4;
        for (int i = 0; i < localeList.size(); i += buttonsPerRow) {
            TextComponent row = Component.text((String)" ");
            for (int j = 0; j < buttonsPerRow && i + j < localeList.size(); ++j) {
                String locale = (String)localeList.get(i + j);
                Set<String> missingKeys = this.findMissingKeysForLocale(locale);
                if (j > 0) {
                    row = row.append((Component)Component.text((String)" "));
                }
                Component localeButton = this.createEnhancedLocaleButton(locale, missingKeys.size());
                row = row.append(localeButton);
            }
            if (this.messageSender == null) continue;
            this.messageSender.sendMessage(player, (Component)row);
        }
    }

    private Component createEnhancedLocaleButton(@NotNull String locale, int missingCount) {
        String statusColor;
        String buttonColor;
        String string = missingCount == 0 ? "#2ecc71" : (buttonColor = missingCount < 10 ? "#f39c12" : "#e74c3c");
        String statusIcon = missingCount == 0 ? "\u2713" : (missingCount < 10 ? "\u26a0" : "\u2717");
        String darkerShade = this.getDarkerShade(buttonColor);
        Component button = MINI_MESSAGE.deserialize((Object)("<gradient:" + buttonColor + ":" + darkerShade + ">[" + statusIcon + " " + locale.toUpperCase() + "]</gradient>"));
        String string2 = missingCount == 0 ? "green" : (statusColor = missingCount < 10 ? "yellow" : "red");
        String statusText = missingCount == 0 ? "<green>Complete</green>" : (missingCount < 10 ? "<yellow>Minor Issues</yellow>" : "<red>Needs Attention</red>");
        Component hoverText = MINI_MESSAGE.deserialize((Object)("<gradient:#9b59b6:#8e44ad>Locale Information</gradient>\n\n<dark_gray>\u25aa <gray>Language: <white>" + locale.toUpperCase() + "</white></gray>\n<dark_gray>\u25aa <gray>Missing Keys: <" + statusColor + ">" + missingCount + "</" + statusColor + "></gray>\n<dark_gray>\u25aa <gray>Status: " + statusText + "</gray>\n\n<gradient:#f1c40f:#f39c12>Click</gradient> <dark_gray>\u00bb</dark_gray> <gray>View missing keys</gray>"));
        return button.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText)).clickEvent(ClickEvent.runCommand((String)("/r18n missing " + locale + " 1")));
    }

    private String getDarkerShade(@NotNull String hexColor) {
        return switch (hexColor) {
            case "#2ecc71" -> "#27ae60";
            case "#f39c12" -> "#e67e22";
            case "#e74c3c" -> "#c0392b";
            default -> "#7f8c8d";
        };
    }

    private void displayMissingKeysForLocale(@NotNull Player player, @NotNull String locale, int page) {
        Set<String> missingKeys = this.findMissingKeysForLocale(locale);
        if (missingKeys.isEmpty()) {
            this.sendNoMissingKeysMessage(player, locale);
            return;
        }
        ArrayList<String> keysList = new ArrayList<String>(missingKeys);
        int totalPages = (int)Math.ceil((double)keysList.size() / 12.0);
        int currentPage = Math.max(1, Math.min(page, totalPages));
        int startIndex = (currentPage - 1) * 12;
        int endIndex = Math.min(startIndex + 12, keysList.size());
        this.sendEnhancedMissingKeysHeader(player, locale, currentPage, totalPages, missingKeys.size());
        this.sendMissingKeysList(player, keysList, startIndex, endIndex);
        this.sendEnhancedNavigationBar(player, locale, currentPage, totalPages);
    }

    private void sendEnhancedMissingKeysHeader(@NotNull Player player, @NotNull String locale, int currentPage, int totalPages, int totalKeys) {
        Component headerLine = MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac</gradient>");
        Component title = MINI_MESSAGE.deserialize((Object)("<gradient:#e74c3c:#c0392b>\ud83d\udd0d Missing Keys Analysis</gradient> <dark_gray>\u00bb</dark_gray> <gradient:#ecf0f1:#bdc3c7>" + locale.toUpperCase() + "</gradient>"));
        Component pageInfo = MINI_MESSAGE.deserialize((Object)("<gray>Page <gradient:#f39c12:#e67e22>" + currentPage + "</gradient><gray>/<gradient:#f39c12:#e67e22>" + totalPages + "</gradient> <dark_gray>\u2022</dark_gray> <gradient:#e74c3c:#c0392b>" + totalKeys + "</gradient> <gray>missing keys</gray>"));
        Component instructions = MINI_MESSAGE.deserialize((Object)"<dark_gray>\u25aa <yellow>Click</yellow> <dark_gray>\u00bb</dark_gray> <gray>Copy key to clipboard</gray>");
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, title);
            this.messageSender.sendMessage(player, pageInfo);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, instructions);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
    }

    private void sendMissingKeysList(@NotNull Player player, @NotNull List<String> keysList, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            String key = keysList.get(i);
            Component keyComponent = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"").append((Component)Component.text((String)" "))).append(MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u2717</gradient>"))).append((Component)Component.text((String)" "))).append(MINI_MESSAGE.deserialize((Object)("<gradient:#ecf0f1:#95a5a6>" + key + "</gradient>")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MINI_MESSAGE.deserialize((Object)("<gradient:#9b59b6:#8e44ad>Translation Key Details</gradient>\n\n<dark_gray>\u25aa <gray>Key: <gradient:#ecf0f1:#bdc3c7>" + key + "</gradient></gray>\n<dark_gray>\u25aa <gray>Status: <gradient:#e74c3c:#c0392b>Missing</gradient></gray>\n\n<gradient:#f1c40f:#f39c12>Click</gradient> <dark_gray>\u00bb</dark_gray> <gray>Copy to clipboard</gray>")))).clickEvent(ClickEvent.copyToClipboard((String)key)));
            if (this.messageSender == null) continue;
            this.messageSender.sendMessage(player, keyComponent);
        }
    }

    private void sendEnhancedNavigationBar(@NotNull Player player, @NotNull String locale, int currentPage, int totalPages) {
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
        TextComponent navigation = Component.text((String)" ");
        if (currentPage > 1) {
            Component prevButton = MINI_MESSAGE.deserialize((Object)"<gradient:#2ecc71:#27ae60>[\u2190 Previous]</gradient>").hoverEvent((HoverEventSource)HoverEvent.showText((Component)MINI_MESSAGE.deserialize((Object)("<gradient:#2ecc71:#27ae60>Go to page " + (currentPage - 1) + "</gradient>")))).clickEvent(ClickEvent.runCommand((String)("/r18n missing " + locale + " " + (currentPage - 1))));
            navigation = navigation.append(prevButton);
        } else {
            navigation = navigation.append(MINI_MESSAGE.deserialize((Object)"<dark_gray>[\u2190 Previous]</dark_gray>"));
        }
        navigation = navigation.append((Component)Component.text((String)" ")).append(MINI_MESSAGE.deserialize((Object)("<gradient:#9b59b6:#8e44ad>[Page " + currentPage + "/" + totalPages + "]</gradient>"))).append((Component)Component.text((String)" "));
        if (currentPage < totalPages) {
            Component nextButton = MINI_MESSAGE.deserialize((Object)"<gradient:#2ecc71:#27ae60>[Next \u2192]</gradient>").hoverEvent((HoverEventSource)HoverEvent.showText((Component)MINI_MESSAGE.deserialize((Object)("<gradient:#2ecc71:#27ae60>Go to page " + (currentPage + 1) + "</gradient>")))).clickEvent(ClickEvent.runCommand((String)("/r18n missing " + locale + " " + (currentPage + 1))));
            navigation = navigation.append(nextButton);
        } else {
            navigation = navigation.append(MINI_MESSAGE.deserialize((Object)"<dark_gray>[Next \u2192]</dark_gray>"));
        }
        navigation = navigation.append((Component)Component.text((String)" ")).append(MINI_MESSAGE.deserialize((Object)"<gradient:#3498db:#2980b9>[\u2190 Back to Locales]</gradient>").hoverEvent((HoverEventSource)HoverEvent.showText((Component)MINI_MESSAGE.deserialize((Object)"<gradient:#3498db:#2980b9>Return to locale selection</gradient>"))).clickEvent(ClickEvent.runCommand((String)"/r18n missing")));
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)navigation);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac</gradient>"));
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
    }

    private void sendNoMissingKeysMessage(@NotNull Player player, @NotNull String locale) {
        Component headerLine = MINI_MESSAGE.deserialize((Object)"<gradient:#2ecc71:#27ae60>\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac</gradient>");
        Component successMessage = MINI_MESSAGE.deserialize((Object)("<gradient:#2ecc71:#27ae60>\u2713 Perfect Translation Coverage</gradient>\n\n<gray>No missing translation keys found for locale: <gradient:#ecf0f1:#bdc3c7>" + locale.toUpperCase() + "</gradient></gray>\n<gray>All translations are complete and ready for use!</gray>"));
        Component backButton = MINI_MESSAGE.deserialize((Object)"<gradient:#3498db:#2980b9>[\u2190 Back to Locales]</gradient>").hoverEvent((HoverEventSource)HoverEvent.showText((Component)MINI_MESSAGE.deserialize((Object)"<gradient:#3498db:#2980b9>Return to locale selection</gradient>"))).clickEvent(ClickEvent.runCommand((String)"/r18n missing"));
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, successMessage);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, Component.text((String)" ").append(backButton));
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
    }

    private void sendEnhancedUsageMessage(@NotNull Player player) {
        Component headerLine = MINI_MESSAGE.deserialize((Object)"<gradient:#9b59b6:#8e44ad>\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac</gradient>");
        Component title = MINI_MESSAGE.deserialize((Object)"<gradient:#9b59b6:#8e44ad>\ud83d\udee0 R18n Administration Commands</gradient>");
        Component reloadCommand = MINI_MESSAGE.deserialize((Object)"<dark_gray>\u25aa <gradient:#2ecc71:#27ae60>/r18n reload</gradient> <dark_gray>\u00bb</dark_gray> <gray>Reload translation files</gray>");
        Component missingCommand = MINI_MESSAGE.deserialize((Object)"<dark_gray>\u25aa <gradient:#e74c3c:#c0392b>/r18n missing</gradient> <dark_gray>\u00bb</dark_gray> <gray>Analyze missing translation keys</gray>");
        Component exportCommand = MINI_MESSAGE.deserialize((Object)"<dark_gray>\u25aa <gradient:#f39c12:#e67e22>/r18n export <format></gradient> <dark_gray>\u00bb</dark_gray> <gray>Export translations (csv/json/yaml)</gray>");
        Component metricsCommand = MINI_MESSAGE.deserialize((Object)"<dark_gray>\u25aa <gradient:#3498db:#2980b9>/r18n metrics</gradient> <dark_gray>\u00bb</dark_gray> <gray>View translation usage statistics</gray>");
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, title);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, reloadCommand);
            this.messageSender.sendMessage(player, missingCommand);
            this.messageSender.sendMessage(player, exportCommand);
            this.messageSender.sendMessage(player, metricsCommand);
            this.messageSender.sendMessage(player, (Component)Component.empty());
            this.messageSender.sendMessage(player, headerLine);
            this.messageSender.sendMessage(player, (Component)Component.empty());
        }
    }

    private void reloadTranslationsWithEnhancedFeedback(@NotNull Player player) {
        Component loadingMessage = MINI_MESSAGE.deserialize((Object)"<gradient:#f39c12:#e67e22>\ud83d\udd04 Reloading translation files...</gradient>");
        if (this.messageSender != null) {
            this.messageSender.sendMessage(player, loadingMessage);
        }
        ((CompletableFuture)this.r18nManager.reload().thenRun(() -> {
            TranslationLoader loader = this.r18nManager.getTranslationLoader();
            int localeCount = loader.getLoadedLocales().size();
            int keyCount = loader.getTotalKeyCount();
            Component successMessage = MINI_MESSAGE.deserialize((Object)("<gradient:#2ecc71:#27ae60>\u2713 Translation Reload Complete</gradient>\n<gray>Loaded <white>" + localeCount + "</white> locales with <white>" + keyCount + "</white> translation keys!</gray>"));
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, successMessage);
            }
        })).exceptionally(ex -> {
            Component failureMessage = MINI_MESSAGE.deserialize((Object)"<gradient:#e74c3c:#c0392b>\u2717 Translation Reload Failed</gradient>\n<gray>An error occurred while reloading translation files.</gray>\n<gray>Check the console for detailed error information.</gray>");
            if (this.messageSender != null) {
                this.messageSender.sendMessage(player, failureMessage);
            }
            this.loadedPlugin.getLogger().log(Level.WARNING, "Failed to load translations", (Throwable)ex);
            return null;
        });
    }

    private void handleConsoleReloadSubcommand(@NotNull CommandSender sender) {
        if (!sender.hasPermission(ER18nPermission.RELOAD.getFallbackNode())) {
            sender.sendMessage("[R18n] You don't have permission to use this command.");
            return;
        }
        this.reloadTranslationsForConsole(sender);
    }

    private void reloadTranslationsForConsole(@NotNull CommandSender sender) {
        sender.sendMessage("[R18n] Reloading translation files...");
        ((CompletableFuture)this.r18nManager.reload().thenRun(() -> {
            TranslationLoader loader = this.r18nManager.getTranslationLoader();
            int localeCount = loader.getLoadedLocales().size();
            int keyCount = loader.getTotalKeyCount();
            sender.sendMessage("[R18n] Translation Reload Complete!");
            sender.sendMessage("[R18n] Loaded " + localeCount + " locales with " + keyCount + " translation keys.");
        })).exceptionally(ex -> {
            sender.sendMessage("[R18n] Translation Reload Failed!");
            sender.sendMessage("[R18n] Check the console for detailed error information.");
            this.loadedPlugin.getLogger().log(Level.WARNING, "Failed to load translations", (Throwable)ex);
            return null;
        });
    }

    private void sendConsoleUsageMessage(@NotNull CommandSender sender) {
        sender.sendMessage("========== R18n Administration Commands ==========");
        sender.sendMessage("/r18n reload - Reload translation files");
        sender.sendMessage("/r18n missing [locale] [page] - Analyze missing translation keys");
        sender.sendMessage("/r18n export <format> - Export translations (csv/json/yaml)");
        sender.sendMessage("/r18n metrics - View translation usage statistics");
        sender.sendMessage("==================================================");
    }

    private void handleConsoleMissingSubcommand(@NotNull CommandSender sender, @NotNull String[] args) {
        if (!sender.hasPermission(ER18nPermission.MISSING.getFallbackNode())) {
            sender.sendMessage("[R18n] You don't have permission to use this command.");
            return;
        }
        if (args.length > 1) {
            int page = args.length > 2 ? this.parsePageNumber(args[2]) : 1;
            this.displayConsoleMissingKeysForLocale(sender, args[1], page);
        } else {
            this.displayConsoleLocaleSelection(sender);
        }
    }

    private void displayConsoleLocaleSelection(@NotNull CommandSender sender) {
        Set<String> availableLocales = this.getAvailableLocales();
        sender.sendMessage("========== Translation Keys Browser ==========");
        sender.sendMessage("Available locales:");
        sender.sendMessage("");
        for (String locale : availableLocales) {
            Set<String> missingKeys = this.findMissingKeysForLocale(locale);
            String status = missingKeys.isEmpty() ? "[OK]" : "[" + missingKeys.size() + " missing]";
            sender.sendMessage("  " + locale.toUpperCase() + " " + status);
        }
        sender.sendMessage("");
        sender.sendMessage("Use: /r18n missing <locale> [page] to view missing keys");
        sender.sendMessage("==============================================");
    }

    private void displayConsoleMissingKeysForLocale(@NotNull CommandSender sender, @NotNull String locale, int page) {
        Set<String> missingKeys = this.findMissingKeysForLocale(locale);
        if (missingKeys.isEmpty()) {
            sender.sendMessage("========== Missing Keys: " + locale.toUpperCase() + " ==========");
            sender.sendMessage("No missing translation keys found!");
            sender.sendMessage("All translations are complete for this locale.");
            sender.sendMessage("==============================================");
            return;
        }
        ArrayList<String> keysList = new ArrayList<String>(missingKeys);
        int totalPages = (int)Math.ceil((double)keysList.size() / 12.0);
        int currentPage = Math.max(1, Math.min(page, totalPages));
        int startIndex = (currentPage - 1) * 12;
        int endIndex = Math.min(startIndex + 12, keysList.size());
        sender.sendMessage("========== Missing Keys: " + locale.toUpperCase() + " ==========");
        sender.sendMessage("Page " + currentPage + "/" + totalPages + " | Total: " + missingKeys.size() + " missing keys");
        sender.sendMessage("");
        for (int i = startIndex; i < endIndex; ++i) {
            sender.sendMessage("  [X] " + (String)keysList.get(i));
        }
        sender.sendMessage("");
        this.sendConsolePaginationInfo(sender, locale, currentPage, totalPages);
        sender.sendMessage("==============================================");
    }

    private void sendConsolePaginationInfo(@NotNull CommandSender sender, @NotNull String locale, int currentPage, int totalPages) {
        StringBuilder navInfo = new StringBuilder("Navigation: ");
        if (currentPage > 1) {
            navInfo.append("/r18n missing ").append(locale).append(" ").append(currentPage - 1).append(" (prev)");
        }
        if (currentPage > 1 && currentPage < totalPages) {
            navInfo.append(" | ");
        }
        if (currentPage < totalPages) {
            navInfo.append("/r18n missing ").append(locale).append(" ").append(currentPage + 1).append(" (next)");
        }
        if (currentPage == 1 && currentPage == totalPages) {
            navInfo.append("Single page");
        }
        sender.sendMessage(navInfo.toString());
    }

    private Set<String> getAvailableLocales() {
        return this.r18nManager.getTranslationLoader().getLoadedLocales().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<String> findMissingKeysForLocale(@NotNull String locale) {
        return this.r18nManager.getTranslationLoader().getMissingKeys(locale).stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return SUBCOMMANDS.stream().filter(subcommand -> subcommand.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && "missing".equalsIgnoreCase(args[0])) {
            return this.getAvailableLocales().stream().filter(locale -> locale.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && "export".equalsIgnoreCase(args[0])) {
            return EXPORT_FORMATS.stream().filter(format -> format.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && "missing".equalsIgnoreCase(args[0])) {
            return List.of("1", "2", "3", "4", "5");
        }
        return List.of();
    }
}

