/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.bedrock;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BedrockDetectionCache
implements Listener {
    private static final Logger LOGGER = Logger.getLogger(BedrockDetectionCache.class.getName());
    private final Map<UUID, Boolean> cache = new ConcurrentHashMap<UUID, Boolean>();
    private Object geyserService;
    private Method isBedrockPlayerMethod;
    private boolean geyserServiceLookupAttempted = false;
    private boolean geyserServiceAvailable = false;

    public boolean isBedrockPlayer(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        Boolean cached = this.cache.get(playerId);
        if (cached != null) {
            return cached;
        }
        boolean isBedrock = this.lookupBedrockStatus(player);
        this.cache.put(playerId, isBedrock);
        return isBedrock;
    }

    public boolean isBedrockPlayer(@NotNull UUID playerId) {
        Boolean cached = this.cache.get(playerId);
        return cached != null && cached != false;
    }

    public void invalidate(@NotNull UUID playerId) {
        this.cache.remove(playerId);
    }

    public void invalidateAll() {
        this.cache.clear();
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public boolean isGeyserServiceAvailable() {
        this.ensureGeyserServiceLookup();
        return this.geyserServiceAvailable;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.invalidate(event.getPlayer().getUniqueId());
    }

    public void registerListener(@NotNull Plugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void shutdown() {
        this.invalidateAll();
    }

    private boolean lookupBedrockStatus(@NotNull Player player) {
        this.ensureGeyserServiceLookup();
        if (!this.geyserServiceAvailable || this.geyserService == null || this.isBedrockPlayerMethod == null) {
            return false;
        }
        try {
            Object result = this.isBedrockPlayerMethod.invoke(this.geyserService, player);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error checking Bedrock player status", e);
            return false;
        }
    }

    private synchronized void ensureGeyserServiceLookup() {
        if (this.geyserServiceLookupAttempted) {
            return;
        }
        this.geyserServiceLookupAttempted = true;
        try {
            Class<?> rPlatformClass = Class.forName("com.raindropcentral.rplatform.RPlatform");
            Method getInstanceMethod = rPlatformClass.getMethod("getInstance", new Class[0]);
            Object rPlatform = getInstanceMethod.invoke(null, new Object[0]);
            if (rPlatform == null) {
                LOGGER.info("RPlatform not available - Bedrock detection disabled");
                return;
            }
            Method getGeyserServiceMethod = rPlatformClass.getMethod("getGeyserService", new Class[0]);
            this.geyserService = getGeyserServiceMethod.invoke(rPlatform, new Object[0]);
            if (this.geyserService == null) {
                LOGGER.info("GeyserService not available - Bedrock detection disabled");
                return;
            }
            this.isBedrockPlayerMethod = this.geyserService.getClass().getMethod("isBedrockPlayer", Player.class);
            this.geyserServiceAvailable = true;
            LOGGER.info("GeyserService integration initialized for Bedrock detection");
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("RPlatform not found - Bedrock detection disabled");
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning("GeyserService API incompatible - Bedrock detection disabled");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error initializing GeyserService integration", e);
        }
    }
}

