/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate.bedrock;

import de.jexcellence.jextranslate.bedrock.BedrockFormatMode;
import de.jexcellence.jextranslate.bedrock.HexColorFallback;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;

public final class BedrockConverter {
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();
    private static final PlainTextComponentSerializer PLAIN_SERIALIZER = PlainTextComponentSerializer.plainText();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([0-9a-fA-F]{6})>");
    private static final Pattern AMPERSAND_HEX_PATTERN = Pattern.compile("[&\u00a7]#([0-9a-fA-F]{6})");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient(?::[^>]*)?>([^<]*)</gradient>");
    private static final Map<NamedTextColor, int[]> LEGACY_COLOR_RGB = Map.ofEntries(Map.entry(NamedTextColor.BLACK, new int[]{0, 0, 0}), Map.entry(NamedTextColor.DARK_BLUE, new int[]{0, 0, 170}), Map.entry(NamedTextColor.DARK_GREEN, new int[]{0, 170, 0}), Map.entry(NamedTextColor.DARK_AQUA, new int[]{0, 170, 170}), Map.entry(NamedTextColor.DARK_RED, new int[]{170, 0, 0}), Map.entry(NamedTextColor.DARK_PURPLE, new int[]{170, 0, 170}), Map.entry(NamedTextColor.GOLD, new int[]{255, 170, 0}), Map.entry(NamedTextColor.GRAY, new int[]{170, 170, 170}), Map.entry(NamedTextColor.DARK_GRAY, new int[]{85, 85, 85}), Map.entry(NamedTextColor.BLUE, new int[]{85, 85, 255}), Map.entry(NamedTextColor.GREEN, new int[]{85, 255, 85}), Map.entry(NamedTextColor.AQUA, new int[]{85, 255, 255}), Map.entry(NamedTextColor.RED, new int[]{255, 85, 85}), Map.entry(NamedTextColor.LIGHT_PURPLE, new int[]{255, 85, 255}), Map.entry(NamedTextColor.YELLOW, new int[]{255, 255, 85}), Map.entry(NamedTextColor.WHITE, new int[]{255, 255, 255}));

    private BedrockConverter() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NotNull
    public static String toLegacyString(@NotNull Component component) {
        Component stripped = BedrockConverter.stripUnsupportedFormatting(component);
        return LEGACY_SERIALIZER.serialize(stripped);
    }

    @NotNull
    public static String toLegacyString(@NotNull Component component, @NotNull HexColorFallback fallback, @NotNull BedrockFormatMode mode) {
        Component stripped = BedrockConverter.stripUnsupportedFormatting(component);
        if (mode == BedrockFormatMode.MODERN) {
            return LEGACY_SERIALIZER.serialize(stripped);
        }
        return BedrockConverter.convertHexColors(LEGACY_SERIALIZER.serialize(stripped), fallback);
    }

    @NotNull
    public static String fromMiniMessage(@NotNull String miniMessage) {
        return BedrockConverter.fromMiniMessage(miniMessage, HexColorFallback.NEAREST_LEGACY, BedrockFormatMode.CONSERVATIVE);
    }

    @NotNull
    public static String fromMiniMessage(@NotNull String miniMessage, @NotNull HexColorFallback fallback, @NotNull BedrockFormatMode mode) {
        if (miniMessage == null || miniMessage.isEmpty()) {
            return "";
        }
        String processed = miniMessage;
        if (mode == BedrockFormatMode.CONSERVATIVE) {
            processed = BedrockConverter.handleGradients(processed, fallback);
        }
        try {
            Component component = MINI_MESSAGE.deserialize((Object)processed);
            return BedrockConverter.toLegacyString(component, fallback, mode);
        }
        catch (Exception e) {
            return PLAIN_SERIALIZER.serialize(MINI_MESSAGE.deserialize((Object)miniMessage));
        }
    }

    @NotNull
    public static String hexToNearestLegacy(@NotNull String hexColor) {
        String hex = hexColor.replace("#", "").replace("\u00a7", "").replace("&", "");
        if (hex.length() != 6) {
            return "\u00a7f";
        }
        try {
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            NamedTextColor nearest = BedrockConverter.findNearestLegacyColor(r, g, b);
            return "\u00a7" + BedrockConverter.getLegacyCode(nearest);
        }
        catch (NumberFormatException e) {
            return "\u00a7f";
        }
    }

    @NotNull
    public static String hexToGrayscale(@NotNull String hexColor) {
        String hex = hexColor.replace("#", "").replace("\u00a7", "").replace("&", "");
        if (hex.length() != 6) {
            return "\u00a7f";
        }
        try {
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            double luminance = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
            if (luminance > 170.0) {
                return "\u00a7f";
            }
            if (luminance > 85.0) {
                return "\u00a77";
            }
            return "\u00a78";
        }
        catch (NumberFormatException e) {
            return "\u00a7f";
        }
    }

    @NotNull
    public static Component stripUnsupportedFormatting(@NotNull Component component) {
        return BedrockConverter.stripRecursive(component);
    }

    @NotNull
    public static String extractDominantColor(@NotNull String startHex, @NotNull String endHex) {
        try {
            String start = startHex.replace("#", "");
            String end = endHex.replace("#", "");
            int r1 = Integer.parseInt(start.substring(0, 2), 16);
            int g1 = Integer.parseInt(start.substring(2, 4), 16);
            int b1 = Integer.parseInt(start.substring(4, 6), 16);
            int r2 = Integer.parseInt(end.substring(0, 2), 16);
            int g2 = Integer.parseInt(end.substring(2, 4), 16);
            int b2 = Integer.parseInt(end.substring(4, 6), 16);
            int r = (r1 + r2) / 2;
            int g = (g1 + g2) / 2;
            int b = (b1 + b2) / 2;
            return String.format("#%02X%02X%02X", r, g, b);
        }
        catch (Exception e) {
            return "#FFFFFF";
        }
    }

    private static Component stripRecursive(@NotNull Component component) {
        TextComponent.Builder builder;
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            builder = Component.text().content(textComponent.content());
        } else {
            builder = Component.text().content(PLAIN_SERIALIZER.serialize(component));
        }
        if (component.color() != null) {
            builder.color(component.color());
        }
        for (TextDecoration decoration : TextDecoration.values()) {
            TextDecoration.State state = component.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            builder.decoration(decoration, state);
        }
        for (Component child : component.children()) {
            builder.append(BedrockConverter.stripRecursive(child));
        }
        return builder.build();
    }

    private static NamedTextColor findNearestLegacyColor(int r, int g, int b) {
        NamedTextColor nearest = NamedTextColor.WHITE;
        double minDistance = Double.MAX_VALUE;
        for (Map.Entry<NamedTextColor, int[]> entry : LEGACY_COLOR_RGB.entrySet()) {
            int[] rgb = entry.getValue();
            double distance = BedrockConverter.colorDistance(r, g, b, rgb[0], rgb[1], rgb[2]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearest = entry.getKey();
        }
        return nearest;
    }

    private static double colorDistance(int r1, int g1, int b1, int r2, int g2, int b2) {
        int dr = r1 - r2;
        int dg = g1 - g2;
        int db = b1 - b2;
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    private static String getLegacyCode(NamedTextColor color) {
        return switch (color.toString()) {
            case "black" -> "0";
            case "dark_blue" -> "1";
            case "dark_green" -> "2";
            case "dark_aqua" -> "3";
            case "dark_red" -> "4";
            case "dark_purple" -> "5";
            case "gold" -> "6";
            case "gray" -> "7";
            case "dark_gray" -> "8";
            case "blue" -> "9";
            case "green" -> "a";
            case "aqua" -> "b";
            case "red" -> "c";
            case "light_purple" -> "d";
            case "yellow" -> "e";
            default -> "f";
        };
    }

    private static String convertHexColors(@NotNull String text, @NotNull HexColorFallback fallback) {
        String result = text;
        Matcher hexMatcher = HEX_PATTERN.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1);
            String replacement = switch (fallback) {
                default -> throw new MatchException(null, null);
                case HexColorFallback.STRIP -> "";
                case HexColorFallback.NEAREST_LEGACY -> BedrockConverter.hexToNearestLegacy(hex);
                case HexColorFallback.GRAYSCALE -> BedrockConverter.hexToGrayscale(hex);
            };
            hexMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        hexMatcher.appendTail(sb);
        result = sb.toString();
        Matcher ampHexMatcher = AMPERSAND_HEX_PATTERN.matcher(result);
        sb = new StringBuffer();
        while (ampHexMatcher.find()) {
            String hex = ampHexMatcher.group(1);
            String replacement = switch (fallback) {
                default -> throw new MatchException(null, null);
                case HexColorFallback.STRIP -> "";
                case HexColorFallback.NEAREST_LEGACY -> BedrockConverter.hexToNearestLegacy(hex);
                case HexColorFallback.GRAYSCALE -> BedrockConverter.hexToGrayscale(hex);
            };
            ampHexMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        ampHexMatcher.appendTail(sb);
        return sb.toString();
    }

    private static String handleGradients(@NotNull String text, @NotNull HexColorFallback fallback) {
        Matcher gradientMatcher = GRADIENT_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (gradientMatcher.find()) {
            String content = gradientMatcher.group(1);
            gradientMatcher.appendReplacement(sb, Matcher.quoteReplacement(content));
        }
        gradientMatcher.appendTail(sb);
        return sb.toString();
    }
}

