/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate;

import de.jexcellence.jextranslate.MessageBuilder;
import de.jexcellence.jextranslate.bedrock.BedrockDetectionCache;
import de.jexcellence.jextranslate.command.PR18nCommand;
import de.jexcellence.jextranslate.config.R18nConfiguration;
import de.jexcellence.jextranslate.core.MessageProvider;
import de.jexcellence.jextranslate.core.TranslationExportService;
import de.jexcellence.jextranslate.core.TranslationFileWatcher;
import de.jexcellence.jextranslate.core.TranslationLoader;
import de.jexcellence.jextranslate.core.TranslationMetrics;
import de.jexcellence.jextranslate.core.VersionDetector;
import de.jexcellence.jextranslate.core.VersionedMessageSender;
import de.jexcellence.jextranslate.validation.KeyValidator;
import de.jexcellence.remapped.com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class R18nManager {
    private static final AtomicReference<R18nManager> instance = new AtomicReference();
    private final JavaPlugin plugin;
    private final R18nConfiguration configuration;
    private final TranslationLoader translationLoader;
    private final MessageProvider messageProvider;
    private final KeyValidator keyValidator;
    private final VersionDetector versionDetector;
    private final Logger logger;
    private BukkitAudiences audiences;
    private VersionedMessageSender messageSender;
    private TranslationFileWatcher fileWatcher;
    private Thread fileWatcherThread;
    private BedrockDetectionCache bedrockDetectionCache;
    private boolean initialized = false;

    @Nullable
    public static R18nManager getInstance() {
        return instance.get();
    }

    private R18nManager(@NotNull Builder builder) {
        this.plugin = builder.plugin;
        this.configuration = builder.configuration;
        this.logger = this.plugin.getLogger();
        this.versionDetector = new VersionDetector();
        this.translationLoader = new TranslationLoader(this.plugin, this.configuration);
        this.keyValidator = new KeyValidator(this.configuration);
        this.messageProvider = new MessageProvider(this.configuration, this.versionDetector);
    }

    @NotNull
    public static Builder builder(@NotNull JavaPlugin plugin) {
        return new Builder(plugin);
    }

    @NotNull
    public CompletableFuture<Void> initialize() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.logger.info("Initializing R18n v2.0.0...");
                this.initializeAdventure();
                this.messageSender = new VersionedMessageSender(this.versionDetector, this.audiences);
                if (this.configuration.bedrockSupportEnabled()) {
                    this.bedrockDetectionCache = new BedrockDetectionCache();
                    this.bedrockDetectionCache.registerListener((Plugin)this.plugin);
                    this.messageSender.setBedrockDetectionCache(this.bedrockDetectionCache);
                    this.messageSender.setConfiguration(this.configuration);
                    this.logger.info("Bedrock detection cache initialized");
                }
                this.translationLoader.loadTranslations().join();
                this.messageProvider.setTranslationLoader(this.translationLoader);
                if (this.configuration.keyValidationEnabled()) {
                    this.keyValidator.validateAllKeys();
                }
                if (this.configuration.watchFiles()) {
                    this.startFileWatcher();
                }
                this.initialized = true;
                instance.set(this);
                int languageCount = this.translationLoader.getLoadedLocales().size();
                int keyCount = this.translationLoader.getTotalKeyCount();
                boolean modernMode = this.versionDetector.isModern() && this.audiences != null;
                this.logger.info(String.format("R18n initialized successfully! Loaded %d languages with %d translation keys. Server: %s, Version: %s, Modern: %s", new Object[]{languageCount, keyCount, this.versionDetector.getServerType(), this.versionDetector.getMinecraftVersion(), modernMode}));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to initialize R18n", e);
                throw new RuntimeException("R18n initialization failed", e);
            }
        });
    }

    @NotNull
    public MessageBuilder message(@NotNull String key) {
        if (!this.initialized) {
            throw new IllegalStateException("R18n is not initialized. Call initialize() first.");
        }
        return new MessageBuilder(this, key);
    }

    @NotNull
    public CompletableFuture<Void> reload() {
        return this.translationLoader.loadTranslations().thenRun(() -> {
            this.messageProvider.invalidateCache();
            if (this.configuration.keyValidationEnabled()) {
                this.keyValidator.validateAllKeys();
            }
            this.logger.info("R18n translations reloaded successfully");
        });
    }

    public void shutdown() {
        this.stopFileWatcher();
        if (this.bedrockDetectionCache != null) {
            this.bedrockDetectionCache.shutdown();
            this.bedrockDetectionCache = null;
        }
        if (this.audiences != null) {
            this.audiences.close();
            this.audiences = null;
        }
        this.messageSender = null;
        this.initialized = false;
        instance.set(null);
        this.logger.info("R18n shutdown complete");
    }

    @Nullable
    public CacheStats getCacheStats() {
        return this.messageProvider.getCacheStats();
    }

    @Nullable
    public TranslationMetrics getMetrics() {
        return this.messageProvider.getMetrics();
    }

    public void exportTranslations(@NotNull Path outputPath, @NotNull TranslationExportService.ExportFormat format) throws IOException {
        TranslationExportService exportService = new TranslationExportService();
        exportService.export(outputPath, format, this.translationLoader.getAllTranslations());
    }

    @NotNull
    public R18nConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public TranslationLoader getTranslationLoader() {
        return this.translationLoader;
    }

    @NotNull
    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    @NotNull
    public KeyValidator getKeyValidator() {
        return this.keyValidator;
    }

    @NotNull
    public VersionDetector getVersionDetector() {
        return this.versionDetector;
    }

    @Nullable
    public BukkitAudiences getAudiences() {
        return this.audiences;
    }

    @Nullable
    public VersionedMessageSender getMessageSender() {
        return this.messageSender;
    }

    @Nullable
    public BedrockDetectionCache getBedrockDetectionCache() {
        return this.bedrockDetectionCache;
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean registerCommand() {
        return this.registerCommand("r18n");
    }

    public boolean registerCommand(@NotNull String commandName) {
        if (!this.initialized) {
            this.logger.warning("Cannot register command before R18n is initialized. Call initialize() first.");
            return false;
        }
        PluginCommand command = this.plugin.getCommand(commandName);
        if (command == null) {
            this.logger.warning("Command '" + commandName + "' not found in plugin.yml. Please add the following to your plugin.yml:\ncommands:\n  " + commandName + ":\n    description: R18n translation management commands\n    usage: /" + commandName + " [reload|missing|export|metrics]\n    permission: r18n.admin");
            return false;
        }
        PR18nCommand commandHandler = new PR18nCommand(this.plugin, this);
        command.setExecutor((CommandExecutor)commandHandler);
        command.setTabCompleter((TabCompleter)commandHandler);
        this.logger.info("Registered /" + commandName + " command for R18n administration");
        return true;
    }

    private void initializeAdventure() {
        try {
            this.audiences = BukkitAudiences.create((Plugin)this.plugin);
            this.logger.info("Adventure platform initialized for " + String.valueOf((Object)this.versionDetector.getServerType()));
        }
        catch (Exception | NoClassDefFoundError e) {
            this.logger.info("Adventure platform not available, using legacy mode: " + e.getMessage());
            this.audiences = null;
        }
    }

    private void startFileWatcher() {
        try {
            File translationDir = new File(this.plugin.getDataFolder(), this.configuration.translationDirectory());
            if (!translationDir.exists()) {
                this.logger.warning("Translation directory does not exist, file watcher not started");
                return;
            }
            this.fileWatcher = new TranslationFileWatcher(translationDir.toPath(), () -> {
                this.logger.info("File change detected, reloading translations...");
                this.reload().exceptionally(ex -> {
                    this.logger.log(Level.SEVERE, "Failed to reload translations after file change", (Throwable)ex);
                    return null;
                });
            });
            this.fileWatcherThread = new Thread((Runnable)this.fileWatcher, "R18n-FileWatcher");
            this.fileWatcherThread.setDaemon(true);
            this.fileWatcherThread.start();
            this.logger.info("File watcher started for hot reload");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to start file watcher", e);
        }
    }

    private void stopFileWatcher() {
        if (this.fileWatcher != null) {
            this.fileWatcher.stop();
            this.fileWatcher = null;
        }
        if (this.fileWatcherThread != null) {
            this.fileWatcherThread.interrupt();
            try {
                this.fileWatcherThread.join(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.fileWatcherThread = null;
        }
    }

    public static final class Builder {
        private final JavaPlugin plugin;
        private R18nConfiguration configuration;

        private Builder(@NotNull JavaPlugin plugin) {
            this.plugin = plugin;
            this.configuration = R18nConfiguration.defaultConfiguration();
        }

        @NotNull
        public Builder defaultLocale(@NotNull String locale) {
            this.configuration = this.configuration.withDefaultLocale(locale);
            return this;
        }

        @NotNull
        public Builder supportedLocales(String ... locales) {
            this.configuration = this.configuration.withSupportedLocales(locales);
            return this;
        }

        @NotNull
        public Builder autoDetectLocales() {
            this.configuration = this.configuration.withAutoDetectLocales();
            return this;
        }

        @NotNull
        public Builder enableKeyValidation(boolean enabled) {
            this.configuration = this.configuration.withKeyValidationEnabled(enabled);
            return this;
        }

        @NotNull
        public Builder enablePlaceholderAPI(boolean enabled) {
            this.configuration = this.configuration.withPlaceholderAPIEnabled(enabled);
            return this;
        }

        @NotNull
        public Builder translationDirectory(@NotNull String directory) {
            this.configuration = this.configuration.withTranslationDirectory(directory);
            return this;
        }

        @NotNull
        public Builder configuration(@NotNull R18nConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @NotNull
        public Builder enableFileWatcher(boolean enabled) {
            this.configuration = this.configuration.withWatchFiles(enabled);
            return this;
        }

        @NotNull
        public R18nManager build() {
            return new R18nManager(this);
        }
    }
}

