/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.jextranslate;

import de.jexcellence.jextranslate.R18nManager;
import de.jexcellence.jextranslate.bedrock.BedrockConverter;
import de.jexcellence.jextranslate.bedrock.BedrockDetectionCache;
import de.jexcellence.jextranslate.util.PluralRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageBuilder {
    private final R18nManager manager;
    private final String key;
    private final Map<String, Object> placeholders;
    private final Map<String, Integer> countPlaceholders;
    private boolean includePrefix;
    private String targetLocale;

    MessageBuilder(@NotNull R18nManager manager, @NotNull String key) {
        this.manager = manager;
        this.key = key;
        this.placeholders = new HashMap<String, Object>();
        this.countPlaceholders = new HashMap<String, Integer>();
        this.includePrefix = false;
        this.targetLocale = null;
    }

    @NotNull
    public MessageBuilder placeholder(@NotNull String key, @Nullable Object value) {
        this.placeholders.put(key, value != null ? value : "null");
        return this;
    }

    @NotNull
    public MessageBuilder placeholders(@NotNull Map<String, Object> placeholders) {
        this.placeholders.putAll(placeholders);
        return this;
    }

    @NotNull
    public MessageBuilder count(@NotNull String placeholder, int value) {
        this.countPlaceholders.put(placeholder, value);
        this.placeholders.put(placeholder, String.valueOf(value));
        return this;
    }

    @NotNull
    public MessageBuilder withPrefix() {
        this.includePrefix = true;
        return this;
    }

    @NotNull
    public MessageBuilder locale(@NotNull String locale) {
        this.targetLocale = locale;
        return this;
    }

    public void send(@NotNull Player player) {
        Component component = this.toComponent(player);
        if (this.manager.getMessageSender() != null) {
            this.manager.getMessageSender().sendMessage(player, component);
        }
    }

    public void send(@NotNull CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.send(player);
        } else {
            Component component = this.toComponent(null);
            if (this.manager.getMessageSender() != null) {
                this.manager.getMessageSender().sendMessage(sender, component);
            }
        }
    }

    public void send(@NotNull Audience audience) {
        Component component = this.toComponent(null);
        if (this.manager.getMessageSender() != null) {
            this.manager.getMessageSender().sendMessage(audience, component);
        }
    }

    public void broadcast() {
        Component component = this.toComponent(null);
        if (this.manager.getMessageSender() != null) {
            this.manager.getMessageSender().broadcast(component);
        }
    }

    public void console() {
        Component component = this.toComponent(null);
        if (this.manager.getMessageSender() != null) {
            this.manager.getMessageSender().console(component);
        }
    }

    @NotNull
    public Component toComponent(@Nullable Player player) {
        String locale = this.determineLocale(player);
        String resolvedKey = this.resolvePluralKey(this.key, locale);
        return this.manager.getMessageProvider().getComponent(resolvedKey, locale, this.placeholders, this.includePrefix);
    }

    @NotNull
    public List<Component> toComponents(@Nullable Player player) {
        String locale = this.determineLocale(player);
        String resolvedKey = this.resolvePluralKey(this.key, locale);
        return this.manager.getMessageProvider().getComponents(resolvedKey, locale, this.placeholders, this.includePrefix);
    }

    @NotNull
    public String toString(@Nullable Player player) {
        String locale = this.determineLocale(player);
        String resolvedKey = this.resolvePluralKey(this.key, locale);
        return this.manager.getMessageProvider().getString(resolvedKey, locale, this.placeholders, this.includePrefix);
    }

    @NotNull
    public List<String> toStrings(@Nullable Player player) {
        String locale = this.determineLocale(player);
        String resolvedKey = this.resolvePluralKey(this.key, locale);
        return this.manager.getMessageProvider().getStrings(resolvedKey, locale, this.placeholders, this.includePrefix);
    }

    public boolean exists(@Nullable Player player) {
        String locale = this.determineLocale(player);
        return this.manager.getTranslationLoader().hasKey(this.key, locale);
    }

    @NotNull
    public String toBedrockString(@Nullable Player player) {
        Component component = this.toComponent(player);
        return BedrockConverter.toLegacyString(component, this.manager.getConfiguration().hexColorFallback(), this.manager.getConfiguration().bedrockFormatMode());
    }

    @NotNull
    public List<String> toBedrockStrings(@Nullable Player player) {
        List<Component> components = this.toComponents(player);
        ArrayList<String> result = new ArrayList<String>(components.size());
        for (Component component : components) {
            result.add(BedrockConverter.toLegacyString(component, this.manager.getConfiguration().hexColorFallback(), this.manager.getConfiguration().bedrockFormatMode()));
        }
        return result;
    }

    @NotNull
    public String toPlainString(@Nullable Player player) {
        Component component = this.toComponent(player);
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    @NotNull
    public List<String> toPlainStrings(@Nullable Player player) {
        List<Component> components = this.toComponents(player);
        ArrayList<String> result = new ArrayList<String>(components.size());
        PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
        for (Component component : components) {
            result.add(serializer.serialize(component));
        }
        return result;
    }

    public boolean isBedrockPlayer(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        BedrockDetectionCache cache = this.manager.getBedrockDetectionCache();
        return cache != null && cache.isBedrockPlayer(player);
    }

    @NotNull
    private String determineLocale(@Nullable Player player) {
        if (this.targetLocale != null) {
            return this.targetLocale;
        }
        if (player != null) {
            try {
                String playerLocale = player.getLocale();
                String normalizedLocale = this.normalizeLocale(playerLocale);
                if (this.manager.getConfiguration().supportedLocales().contains(normalizedLocale)) {
                    return normalizedLocale;
                }
                String language = playerLocale.split("[_-]")[0].toLowerCase();
                if (this.manager.getConfiguration().supportedLocales().contains(language)) {
                    return language;
                }
                for (String supportedLocale : this.manager.getConfiguration().supportedLocales()) {
                    if (!supportedLocale.toLowerCase().startsWith(language)) continue;
                    return supportedLocale;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.manager.getConfiguration().defaultLocale();
    }

    @NotNull
    private String normalizeLocale(@NotNull String locale) {
        if (locale == null || locale.isEmpty()) {
            return locale;
        }
        String[] parts = locale.split("[_-]");
        if (parts.length == 1) {
            return parts[0].toLowerCase();
        }
        if (parts.length >= 2) {
            return parts[0].toLowerCase() + "_" + parts[1].toUpperCase();
        }
        return locale;
    }

    @NotNull
    private String resolvePluralKey(@NotNull String baseKey, @NotNull String locale) {
        if (this.countPlaceholders.isEmpty()) {
            return baseKey;
        }
        Map.Entry<String, Integer> entry = this.countPlaceholders.entrySet().iterator().next();
        int count = entry.getValue();
        String pluralForm = PluralRules.select(locale, count);
        String pluralKey = baseKey + "." + pluralForm;
        if (this.manager.getTranslationLoader().hasKey(pluralKey, locale)) {
            return pluralKey;
        }
        String otherKey = baseKey + ".other";
        if (this.manager.getTranslationLoader().hasKey(otherKey, locale)) {
            return otherKey;
        }
        return baseKey;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public Map<String, Object> getPlaceholders() {
        return new HashMap<String, Object>(this.placeholders);
    }

    public boolean isIncludePrefix() {
        return this.includePrefix;
    }

    @Nullable
    public String getTargetLocale() {
        return this.targetLocale;
    }

    @NotNull
    public Map<String, Integer> getCountPlaceholders() {
        return new HashMap<String, Integer>(this.countPlaceholders);
    }
}

