/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.util;

import de.jexcellence.hibernate.repository.BaseRepository;
import jakarta.persistence.Entity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class EntitySeeder<T, ID> {
    private final BaseRepository<T, ID> repository;
    private final Logger logger;

    public EntitySeeder(@NotNull BaseRepository<T, ID> repository, @NotNull Logger logger) {
        this.repository = repository;
        this.logger = logger;
    }

    public void seedFromPackage(@NotNull String packagePath) {
        if (packagePath.isBlank()) {
            throw new IllegalArgumentException("packagePath must not be blank");
        }
        this.logger.log(Level.INFO, "Scanning package {0} for entities", packagePath);
        Reflections reflections = new Reflections(packagePath, new Scanner[0]);
        Set entityClasses = reflections.getTypesAnnotatedWith(Entity.class);
        for (Class entityClass : entityClasses) {
            try {
                Object instance = entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ID identifier = this.extractId(entityClass, instance);
                if (identifier != null && !this.repository.findById(identifier).isEmpty()) continue;
                CompletableFuture<T> future = this.repository.createAsync(instance);
                future.exceptionally(throwable -> {
                    this.logger.log(Level.SEVERE, "Failed to persist entity {0}", entityClass.getSimpleName());
                    this.logger.log(Level.FINE, (Throwable)throwable, throwable::getMessage);
                    return null;
                });
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                this.logger.log(Level.SEVERE, "Failed to instantiate entity {0}", entityClass.getName());
                this.logger.log(Level.FINE, exception, exception::getMessage);
            }
        }
    }

    @Nullable
    private ID extractId(@NotNull Class<?> entityClass, @NotNull T instance) {
        try {
            Method getId = entityClass.getMethod("getId", new Class[0]);
            return (ID)getId.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }
}

