/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.util;

import de.jexcellence.hibernate.persistence.PersistenceUnitProvider;
import de.jexcellence.hibernate.util.ConfigLoader;
import jakarta.persistence.EntityManagerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.jetbrains.annotations.NotNull;

public final class ConnectionFactory
implements AutoCloseable {
    private final EntityManagerFactory entityManagerFactory;

    public ConnectionFactory(@NotNull String filePath) {
        if (filePath.isBlank()) {
            throw new IllegalArgumentException("File path must not be blank.");
        }
        this.entityManagerFactory = this.createEntityManagerFactory(filePath);
    }

    @NotNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public void close() {
        if (this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
    }

    @NotNull
    private EntityManagerFactory createEntityManagerFactory(@NotNull String filePath) {
        try {
            Properties properties = new ConfigLoader().loadAndValidateProperties(filePath);
            return new HibernatePersistenceProvider().createContainerEntityManagerFactory(PersistenceUnitProvider.get(), (Map)properties);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to load Hibernate properties", exception);
        }
    }
}

