/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.repository;

import de.jexcellence.hibernate.repository.BaseRepository;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RepositoryMetadata<T, ID, K> {
    private final Class<? extends BaseRepository<T, ID>> repositoryClass;
    private final Class<T> entityClass;
    private final Function<T, K> keyExtractor;

    public RepositoryMetadata(@NotNull Class<? extends BaseRepository<T, ID>> repositoryClass, @NotNull Class<T> entityClass, @Nullable Function<T, K> keyExtractor) {
        this.repositoryClass = repositoryClass;
        this.entityClass = entityClass;
        if (!BaseRepository.class.isAssignableFrom(repositoryClass)) {
            throw new IllegalArgumentException("Repository class " + repositoryClass.getName() + " must extend BaseRepository");
        }
        this.keyExtractor = keyExtractor;
    }

    @NotNull
    public Class<? extends BaseRepository<T, ID>> getRepositoryClass() {
        return this.repositoryClass;
    }

    @NotNull
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Nullable
    public Function<T, K> getKeyExtractor() {
        return this.keyExtractor;
    }

    public boolean hasKeyExtractor() {
        return this.keyExtractor != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMetadata that = (RepositoryMetadata)o;
        return Objects.equals(this.repositoryClass, that.repositoryClass) && Objects.equals(this.entityClass, that.entityClass);
    }

    public int hashCode() {
        return Objects.hash(this.repositoryClass, this.entityClass);
    }

    public String toString() {
        return "RepositoryMetadata{repositoryClass=" + this.repositoryClass.getName() + ", entityClass=" + this.entityClass.getName() + ", hasKeyExtractor=" + this.hasKeyExtractor() + "}";
    }
}

