/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.repository;

import de.jexcellence.hibernate.repository.BaseRepository;
import de.jexcellence.hibernate.repository.CachedRepository;
import de.jexcellence.hibernate.repository.InjectRepository;
import de.jexcellence.hibernate.repository.RepositoryMetadata;
import jakarta.persistence.EntityManagerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class RepositoryManager {
    private static volatile RepositoryManager instance;
    private final ExecutorService executor;
    private final EntityManagerFactory entityManagerFactory;
    private final ConcurrentHashMap<Class<?>, RepositoryMetadata<?, ?, ?>> registrations;
    private final ConcurrentHashMap<Class<?>, Object> instances;

    private RepositoryManager(@NotNull ExecutorService executor, @NotNull EntityManagerFactory entityManagerFactory) {
        this.executor = executor;
        this.entityManagerFactory = entityManagerFactory;
        this.registrations = new ConcurrentHashMap();
        this.instances = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(@NotNull ExecutorService executor, @NotNull EntityManagerFactory entityManagerFactory) {
        Class<RepositoryManager> clazz = RepositoryManager.class;
        synchronized (RepositoryManager.class) {
            instance = new RepositoryManager(executor, entityManagerFactory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static RepositoryManager getInstance() {
        RepositoryManager current = instance;
        if (current == null) {
            throw new IllegalStateException("RepositoryManager not initialized. Call initialize() first.");
        }
        return current;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    @NotNull
    public static <T> T get(@NotNull Class<T> repositoryClass) {
        return RepositoryManager.getInstance().getRepository(repositoryClass);
    }

    public <T, ID> void register(@NotNull Class<? extends BaseRepository<T, ID>> repositoryClass, @NotNull Class<T> entityClass) {
        RepositoryMetadata metadata = new RepositoryMetadata(repositoryClass, entityClass, null);
        this.registrations.put(repositoryClass, metadata);
    }

    public <T, ID, K> void register(@NotNull Class<? extends CachedRepository<T, ID, K>> repositoryClass, @NotNull Class<T> entityClass, @NotNull Function<T, K> keyExtractor) {
        RepositoryMetadata metadata = new RepositoryMetadata(repositoryClass, entityClass, keyExtractor);
        this.registrations.put(repositoryClass, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> T getRepository(@NotNull Class<T> repositoryClass) {
        Object existing = this.instances.get(repositoryClass);
        if (existing != null) {
            return (T)existing;
        }
        ConcurrentHashMap<Class<?>, Object> concurrentHashMap = this.instances;
        synchronized (concurrentHashMap) {
            existing = this.instances.get(repositoryClass);
            if (existing != null) {
                return (T)existing;
            }
            RepositoryMetadata<?, ?, ?> metadata = this.registrations.get(repositoryClass);
            if (metadata == null) {
                throw new IllegalStateException("Repository not registered: " + repositoryClass.getName() + ". Call register() first.");
            }
            T newInstance = this.instantiateRepository(repositoryClass, metadata);
            this.instances.put(repositoryClass, newInstance);
            return newInstance;
        }
    }

    public void injectInto(@NotNull Object target) {
        Class<?> targetClass;
        for (Class<?> current = targetClass = target.getClass(); current != null; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.isAnnotationPresent(InjectRepository.class)) continue;
                Class<?> fieldType = field.getType();
                if (!this.registrations.containsKey(fieldType)) {
                    throw new IllegalStateException("Repository not registered: " + fieldType.getName() + " (field: " + field.getName() + " in " + targetClass.getName() + ")");
                }
                try {
                    field.setAccessible(true);
                    field.set(target, this.getRepository(fieldType));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failed to inject " + field.getName(), e);
                }
            }
        }
    }

    @NotNull
    public <T> T createWithInjection(@NotNull Class<T> targetClass) {
        return this.createWithInjection(targetClass, new Object[0]);
    }

    @NotNull
    public <T> T createWithInjection(@NotNull Class<T> targetClass, Object ... constructorArgs) {
        try {
            Constructor<T> constructor = this.findConstructor(targetClass, constructorArgs);
            constructor.setAccessible(true);
            T instance = constructor.newInstance(constructorArgs);
            this.injectInto(instance);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to create " + targetClass.getName(), e);
        }
    }

    public void clearInstances() {
        this.instances.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class<RepositoryManager> clazz = RepositoryManager.class;
        synchronized (RepositoryManager.class) {
            if (instance != null) {
                RepositoryManager.instance.instances.clear();
                RepositoryManager.instance.registrations.clear();
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    private <T> T instantiateRepository(@NotNull Class<T> repositoryClass, @NotNull RepositoryMetadata<?, ?, ?> metadata) {
        try {
            if (metadata.hasKeyExtractor() && CachedRepository.class.isAssignableFrom(repositoryClass)) {
                Constructor<T> constructor = repositoryClass.getDeclaredConstructor(ExecutorService.class, EntityManagerFactory.class, Class.class, Function.class);
                constructor.setAccessible(true);
                return constructor.newInstance(this.executor, this.entityManagerFactory, metadata.getEntityClass(), metadata.getKeyExtractor());
            }
            Constructor<T> constructor = repositoryClass.getDeclaredConstructor(ExecutorService.class, EntityManagerFactory.class, Class.class);
            constructor.setAccessible(true);
            return constructor.newInstance(this.executor, this.entityManagerFactory, metadata.getEntityClass());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to instantiate " + repositoryClass.getName(), e);
        }
    }

    @NotNull
    private <T> Constructor<T> findConstructor(@NotNull Class<T> targetClass, @NotNull Object[] args) throws NoSuchMethodException {
        if (args.length == 0) {
            return targetClass.getDeclaredConstructor(new Class[0]);
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        for (Constructor<?> constructor : targetClass.getDeclaredConstructors()) {
            if (!this.isCompatible(constructor.getParameterTypes(), argTypes)) continue;
            return constructor;
        }
        throw new NoSuchMethodException("No matching constructor for " + targetClass.getName());
    }

    private boolean isCompatible(@NotNull Class<?>[] paramTypes, @NotNull Class<?>[] argTypes) {
        if (paramTypes.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].isAssignableFrom(argTypes[i]) || this.isPrimitiveMatch(paramTypes[i], argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimitiveMatch(@NotNull Class<?> param, @NotNull Class<?> arg) {
        return param == Integer.TYPE && arg == Integer.class || param == Long.TYPE && arg == Long.class || param == Boolean.TYPE && arg == Boolean.class || param == Double.TYPE && arg == Double.class || param == Float.TYPE && arg == Float.class || param == Byte.TYPE && arg == Byte.class || param == Short.TYPE && arg == Short.class || param == Character.TYPE && arg == Character.class;
    }
}

