/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.repository;

import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.RollbackException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.StaleObjectStateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptimisticLockHandler {
    private static final Logger LOGGER = Logger.getLogger(OptimisticLockHandler.class.getName());
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final long RETRY_DELAY_MS = 100L;

    private OptimisticLockHandler() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <T> T executeWithRetry(@NotNull Callable<T> operation, @NotNull String entityName) throws Exception {
        if (entityName.isBlank()) {
            throw new IllegalArgumentException("entityName must not be blank");
        }
        int attempts = 0;
        Exception lastException = null;
        while (attempts < 3) {
            try {
                return operation.call();
            }
            catch (Exception exception) {
                lastException = exception;
                if (!OptimisticLockHandler.isOptimisticLockException(exception)) {
                    throw exception;
                }
                LOGGER.log(Level.WARNING, "Optimistic lock on {0}, retry {1}/{2}", new Object[]{entityName, ++attempts, 3});
                if (attempts >= 3) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                    throw interrupted;
                }
            }
        }
        throw lastException;
    }

    private static boolean isOptimisticLockException(@Nullable Throwable throwable) {
        RollbackException rollback;
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof OptimisticLockException || throwable instanceof StaleObjectStateException) {
            return true;
        }
        if (throwable instanceof RollbackException && (rollback = (RollbackException)throwable).getCause() != null) {
            return OptimisticLockHandler.isOptimisticLockException(rollback.getCause());
        }
        String message = throwable.getMessage();
        if (message != null && (message.contains("OptimisticLockException") || message.contains("StaleObjectStateException") || message.contains("Row was updated or deleted by another transaction"))) {
            return true;
        }
        return OptimisticLockHandler.isOptimisticLockException(throwable.getCause());
    }
}

