/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.persistence;

import com.google.common.reflect.ClassPath;
import de.jexcellence.hibernate.JEHibernate;
import jakarta.persistence.Entity;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistenceUnitProvider {
    private static final Logger LOGGER = Logger.getLogger(PersistenceUnitProvider.class.getName());

    private PersistenceUnitProvider() {
    }

    @NotNull
    public static PersistenceUnitInfo get() {
        return new PersistenceUnitInfo(){

            @NotNull
            public String getPersistenceUnitName() {
                return "JEPersistenceUnit";
            }

            @Nullable
            public String getPersistenceProviderClassName() {
                return null;
            }

            @NotNull
            public String getScopeAnnotationName() {
                return "";
            }

            @NotNull
            public List<String> getQualifierAnnotationNames() {
                return List.of();
            }

            @NotNull
            public PersistenceUnitTransactionType getTransactionType() {
                return PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }

            @Nullable
            public DataSource getJtaDataSource() {
                return null;
            }

            @Nullable
            public DataSource getNonJtaDataSource() {
                return null;
            }

            @NotNull
            public List<String> getMappingFileNames() {
                return Collections.emptyList();
            }

            @NotNull
            public List<URL> getJarFileUrls() {
                return Collections.emptyList();
            }

            @Nullable
            public URL getPersistenceUnitRootUrl() {
                return null;
            }

            @NotNull
            public List<String> getManagedClassNames() {
                ArrayList<String> managed = new ArrayList<String>();
                try {
                    ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getAllClasses().stream().filter(info -> info.getPackageName().contains("database.entity")).forEach(info -> {
                        try {
                            Class candidate = info.load();
                            if (candidate.isAnnotationPresent(Entity.class)) {
                                managed.add(candidate.getName());
                            }
                        }
                        catch (Throwable throwable) {
                            LOGGER.log(Level.WARNING, "Failed to load class {0}", info.getName());
                            LOGGER.log(Level.FINE, throwable, throwable::getMessage);
                        }
                    });
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Classpath scanning failed", exception);
                }
                return managed;
            }

            public boolean excludeUnlistedClasses() {
                return false;
            }

            @NotNull
            public SharedCacheMode getSharedCacheMode() {
                return SharedCacheMode.UNSPECIFIED;
            }

            @NotNull
            public ValidationMode getValidationMode() {
                return ValidationMode.AUTO;
            }

            @NotNull
            public Properties getProperties() {
                return new Properties();
            }

            @NotNull
            public String getPersistenceXMLSchemaVersion() {
                return "3.1";
            }

            @NotNull
            public ClassLoader getClassLoader() {
                return JEHibernate.class.getClassLoader();
            }

            public void addTransformer(ClassTransformer classTransformer) {
            }

            @NotNull
            public ClassLoader getNewTempClassLoader() {
                return JEHibernate.class.getClassLoader();
            }
        };
    }
}

