/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.naming;

import java.util.Locale;
import java.util.regex.Pattern;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnakeCaseNamingStrategy
extends PhysicalNamingStrategyStandardImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SnakeCaseNamingStrategy.class);
    private static final Pattern CAMEL_CASE = Pattern.compile("([a-z])([A-Z])");

    public Identifier toPhysicalTableName(@NotNull Identifier logicalName, @NotNull JdbcEnvironment context) {
        return this.convert(logicalName);
    }

    public Identifier toPhysicalColumnName(@NotNull Identifier logicalName, @NotNull JdbcEnvironment context) {
        return this.convert(logicalName);
    }

    public Identifier toPhysicalSequenceName(@NotNull Identifier logicalName, @NotNull JdbcEnvironment context) {
        return this.convert(logicalName);
    }

    private Identifier convert(@NotNull Identifier logicalName) {
        String converted = CAMEL_CASE.matcher(logicalName.getText()).replaceAll("$1_$2").replace('-', '_').toLowerCase(Locale.ROOT);
        LOGGER.trace("Physical name: {} -> {}", (Object)logicalName.getText(), (Object)converted);
        return Identifier.toIdentifier((String)converted, (boolean)logicalName.isQuoted());
    }
}

