/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.entity;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MappedSuperclass
public abstract class BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Version
    private int version;
    @CreationTimestamp
    @Column(name="created_at", updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;
    @Column(name="deleted", nullable=false)
    private boolean deleted = false;

    protected BaseEntity() {
    }

    @PrePersist
    protected void onPrePersist() {
        LocalDateTime now = LocalDateTime.now();
        if (this.createdAt == null) {
            this.createdAt = now;
        }
        if (this.updatedAt == null) {
            this.updatedAt = now;
        }
    }

    @PreUpdate
    protected void onPreUpdate() {
        this.updatedAt = LocalDateTime.now();
    }

    @PostPersist
    protected void onPostPersist() {
    }

    @PostUpdate
    protected void onPostUpdate() {
    }

    @PreRemove
    protected void onPreRemove() {
    }

    public void softDelete() {
        if (!this.deleted) {
            this.deleted = true;
            this.onPreUpdate();
        }
    }

    public boolean isNew() {
        return this.id == null;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(@NotNull Long id) {
        if (!this.isNew()) {
            throw new IllegalStateException("Id cannot be set after persistence");
        }
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Nullable
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(@NotNull LocalDateTime createdAt) {
        if (!this.isNew()) {
            throw new IllegalStateException("createdAt cannot be changed after persistence");
        }
        this.createdAt = createdAt;
    }

    @Nullable
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(@NotNull LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        if (deleted) {
            this.softDelete();
        } else {
            this.deleted = false;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseEntity)) {
            return false;
        }
        BaseEntity that = (BaseEntity)other;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", version=" + this.version + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", deleted=" + this.deleted + "}";
    }
}

