/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@Converter(autoApply=true)
public final class UuidBytesConverter
implements AttributeConverter<UUID, byte[]> {
    private static final int UUID_BYTE_LENGTH = 16;

    public byte @Nullable [] convertToDatabaseColumn(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return buffer.array();
    }

    @Nullable
    public UUID convertToEntityAttribute(byte @Nullable [] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("UUID column must contain exactly 16 bytes");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long mostSignificant = buffer.getLong();
        long leastSignificant = buffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }
}

