/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.hibernate;

import de.jexcellence.hibernate.util.ConnectionFactory;
import jakarta.persistence.EntityManagerFactory;
import org.jetbrains.annotations.NotNull;

public final class JEHibernate
implements AutoCloseable {
    private final EntityManagerFactory entityManagerFactory;

    public JEHibernate(@NotNull String filePath) {
        if (filePath.isBlank()) {
            throw new IllegalArgumentException("File path must not be blank.");
        }
        this.entityManagerFactory = new ConnectionFactory(filePath).getEntityManagerFactory();
    }

    @NotNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public void close() {
        if (this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
    }
}

