/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.tokenizer;

import de.jexcellence.gpeee.error.AEvaluatorError;
import de.jexcellence.gpeee.error.UnknownTokenError;
import de.jexcellence.gpeee.logging.DebugLogSource;
import de.jexcellence.gpeee.tokenizer.FTokenReader;
import de.jexcellence.gpeee.tokenizer.ITokenizer;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import de.jexcellence.gpeee.tokenizer.TokenizerState;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class Tokenizer
implements ITokenizer {
    private final String rawText;
    private final Logger logger;
    private final char[] text;
    private final Stack<TokenizerState> saveStates;
    private TokenizerState state;

    public Tokenizer(Logger logger, String text) {
        this.rawText = text;
        this.logger = logger;
        this.text = text.toCharArray();
        this.state = new TokenizerState();
        this.saveStates = new Stack();
    }

    @Override
    public String getRawText() {
        return this.rawText;
    }

    @Override
    public boolean hasNextChar() {
        return this.state.charIndex < this.text.length;
    }

    @Override
    public boolean isConsideredWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    @Override
    public void saveState(boolean debugLog) {
        this.saveStates.push(this.state.copy());
        if (debugLog) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Saved state " + this.saveStates.size() + " (charIndex=" + this.state.charIndex + ")");
        }
    }

    @Override
    public void restoreState(boolean debugLog) {
        int sizeBefore = this.saveStates.size();
        this.state = this.saveStates.pop();
        if (debugLog) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Restored state " + sizeBefore + " (charIndex=" + this.state.charIndex + ")");
        }
    }

    @Override
    public TokenizerState discardState(boolean debugLog) {
        int sizeBefore = this.saveStates.size();
        TokenizerState state = this.saveStates.pop();
        if (debugLog) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Discarded state " + sizeBefore + " (charIndex=" + state.charIndex + ")");
        }
        return state;
    }

    @Override
    public char nextChar() {
        char next;
        if ((next = this.text[this.state.charIndex++]) == '\n') {
            ++this.state.row;
            this.state.colStack.push(this.state.col);
            this.state.col = 0;
        } else {
            ++this.state.col;
        }
        return next;
    }

    @Override
    public char peekNextChar() {
        return this.text[this.state.charIndex];
    }

    @Override
    public void undoNextChar() {
        char lastChar = this.text[this.state.charIndex - 1];
        if (lastChar == '\n') {
            --this.state.row;
            this.state.col = this.state.colStack.pop();
        } else {
            --this.state.col;
        }
        --this.state.charIndex;
    }

    @Override
    @Nullable
    public Token peekToken() throws AEvaluatorError {
        if (this.state.currentToken == null) {
            this.readNextToken();
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Peeked token " + String.valueOf(this.state.currentToken));
        return this.state.currentToken;
    }

    @Override
    @Nullable
    public Token consumeToken() throws AEvaluatorError {
        this.state.previousToken = this.state.currentToken;
        if (this.state.currentToken == null) {
            this.readNextToken();
        }
        Token result = this.state.currentToken;
        this.readNextToken();
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Consumed token " + String.valueOf(result));
        return result;
    }

    @Override
    @Nullable
    public Token previousToken() throws AEvaluatorError {
        return this.state.previousToken;
    }

    @Override
    public int getCurrentRow() {
        return this.state.row;
    }

    @Override
    public int getCurrentCol() {
        return this.state.col;
    }

    private void eatWhitespace() {
        int ate = 0;
        while (this.hasNextChar() && (this.isConsideredWhitespace(this.peekNextChar()) || this.peekNextChar() == '\n')) {
            ++ate;
            this.nextChar();
        }
        if (ate > 0) {
            int ateFinal = ate;
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Ate " + ateFinal + " character(s) of whitespace");
        }
    }

    private void readNextToken() throws AEvaluatorError {
        this.eatWhitespace();
        if (!this.hasNextChar()) {
            this.state.currentToken = null;
            return;
        }
        this.saveState(false);
        String comment = TokenType.COMMENT.getTokenReader().apply(this);
        if (comment != null) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Ate comment: " + comment);
            this.discardState(false);
            this.readNextToken();
            return;
        }
        this.restoreState(false);
        for (TokenType tryType : TokenType.valuesInTrialOrder) {
            FTokenReader reader = tryType.getTokenReader();
            this.saveState(false);
            String result = reader.apply(this);
            if (result != null) {
                TokenizerState previousState = this.discardState(false);
                this.state.currentToken = new Token(tryType, previousState.row, previousState.col, result);
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.TOKENIZER) + "Reader for " + String.valueOf((Object)tryType) + " was successful");
                return;
            }
            this.restoreState(false);
        }
        throw new UnknownTokenError(this.state.row, this.state.col, this.rawText);
    }
}

