/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.tokenizer;

import de.jexcellence.gpeee.error.NegativeExponentOnLongError;
import de.jexcellence.gpeee.error.UnterminatedStringError;
import de.jexcellence.gpeee.tokenizer.CollectorResult;
import de.jexcellence.gpeee.tokenizer.FTokenReader;
import de.jexcellence.gpeee.tokenizer.ITokenizer;
import de.jexcellence.gpeee.tokenizer.TokenCategory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public enum TokenType {
    TRUE(TokenCategory.LITERAL, "true", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "true".toCharArray())),
    FALSE(TokenCategory.LITERAL, "false", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "false".toCharArray())),
    NULL(TokenCategory.LITERAL, "null", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "null".toCharArray())),
    IDENTIFIER(TokenCategory.VALUE, null, tokenizer -> {
        StringBuilder result = new StringBuilder();
        char firstChar = tokenizer.nextChar();
        if (!TokenType.isIdentifierChar(firstChar, true)) {
            return null;
        }
        result.append(firstChar);
        while (tokenizer.hasNextChar() && TokenType.isIdentifierChar(tokenizer.peekNextChar(), false)) {
            result.append(tokenizer.nextChar());
        }
        return result.toString();
    }),
    LONG(TokenCategory.VALUE, null, tokenizer -> {
        StringBuilder result = new StringBuilder();
        if (TokenType.collectDigits(tokenizer, result, false) != CollectorResult.READ_OKAY) {
            return null;
        }
        TokenType.possiblyCollectExponent(tokenizer, result, false);
        return result.toString();
    }),
    DOUBLE(TokenCategory.VALUE, null, tokenizer -> {
        StringBuilder result = new StringBuilder();
        if (tokenizer.peekNextChar() == '.') {
            result.append('0');
            result.append(tokenizer.nextChar());
            if (TokenType.collectDigits(tokenizer, result, false) != CollectorResult.READ_OKAY) {
                return null;
            }
            return result.toString();
        }
        if (TokenType.collectDigits(tokenizer, result, true) != CollectorResult.READ_OKAY) {
            return null;
        }
        if (!tokenizer.hasNextChar() || tokenizer.nextChar() != '.') {
            return null;
        }
        result.append('.');
        if (TokenType.collectDigits(tokenizer, result, false) != CollectorResult.READ_OKAY) {
            return null;
        }
        TokenType.possiblyCollectExponent(tokenizer, result, true);
        return result.toString();
    }),
    STRING(TokenCategory.VALUE, null, tokenizer -> {
        int startRow = tokenizer.getCurrentRow();
        int startCol = tokenizer.getCurrentCol();
        if (tokenizer.nextChar() != '\"') {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean isTerminated = false;
        while (tokenizer.hasNextChar()) {
            Character previousPrevious;
            char c = tokenizer.nextChar();
            @Nullable Character previous = result.length() == 0 ? null : Character.valueOf(result.charAt(result.length() - 1));
            Character c2 = previousPrevious = result.length() <= 1 ? null : Character.valueOf(result.charAt(result.length() - 2));
            if (previous != null && previous.charValue() == '\\' && previousPrevious != null && previousPrevious.charValue() == '\\') {
                result.deleteCharAt(result.length() - 1);
            }
            if (c == '\"') {
                if (previous != null && previous.charValue() == '\\' && (previousPrevious == null || previousPrevious.charValue() != '\\')) {
                    result.deleteCharAt(result.length() - 1);
                    result.append(c);
                    continue;
                }
                isTerminated = true;
                break;
            }
            if (c == 's' && previous != null && previous.charValue() == '\\' && (previousPrevious == null || previousPrevious.charValue() != '\\')) {
                result.deleteCharAt(result.length() - 1);
                result.append('\'');
                continue;
            }
            result.append(c);
        }
        if (!isTerminated) {
            throw new UnterminatedStringError(startRow, startCol, tokenizer.getRawText());
        }
        return result.toString();
    }),
    EXPONENT(TokenCategory.OPERATOR, "^", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '^')),
    MULTIPLICATION(TokenCategory.OPERATOR, "*", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '*')),
    DIVISION(TokenCategory.OPERATOR, "/", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '/')),
    MODULO(TokenCategory.OPERATOR, "%", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '%')),
    PLUS(TokenCategory.OPERATOR, "+", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '+')),
    MINUS(TokenCategory.OPERATOR, "-", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, c -> c.charValue() == '>', '-')),
    GREATER_THAN(TokenCategory.OPERATOR, ">", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, c -> c.charValue() == '=', '>')),
    GREATER_THAN_OR_EQUAL(TokenCategory.OPERATOR, ">=", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '>', '=')),
    LESS_THAN(TokenCategory.OPERATOR, "<", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, c -> c.charValue() == '=', '<')),
    LESS_THAN_OR_EQUAL(TokenCategory.OPERATOR, "<=", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '<', '=')),
    VALUE_EQUALS(TokenCategory.OPERATOR, "==", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, c -> c.charValue() == '=', '=', '=')),
    VALUE_NOT_EQUALS(TokenCategory.OPERATOR, "!=", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, c -> c.charValue() == '=', '!', '=')),
    VALUE_EQUALS_EXACT(TokenCategory.OPERATOR, "===", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '=', '=', '=')),
    VALUE_NOT_EQUALS_EXACT(TokenCategory.OPERATOR, "!==", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '!', '=', '=')),
    CONCATENATE(TokenCategory.OPERATOR, "&", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '&')),
    BOOL_NOT(TokenCategory.KEYWORD, "not", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "not".toCharArray())),
    BOOL_AND(TokenCategory.KEYWORD, "and", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "and".toCharArray())),
    BOOL_OR(TokenCategory.KEYWORD, "or", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "or".toCharArray())),
    KW_IF(TokenCategory.KEYWORD, "if", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "if".toCharArray())),
    KW_THEN(TokenCategory.KEYWORD, "then", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "then".toCharArray())),
    KW_ELSE(TokenCategory.KEYWORD, "else", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "else".toCharArray())),
    ARROW(TokenCategory.OPERATOR, "=>", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "=>".toCharArray())),
    ASSIGN(TokenCategory.OPERATOR, "=", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, c -> c.charValue() == '=', '=')),
    NULL_COALESCE(TokenCategory.OPERATOR, "??", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, "??".toCharArray())),
    PARENTHESIS_OPEN(TokenCategory.SYMBOL, "(", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '(')),
    OPTIONAL_PARENTHESIS_OPEN(TokenCategory.SYMBOL, "?(", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '?', '(')),
    PARENTHESIS_CLOSE(TokenCategory.SYMBOL, ")", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, ')')),
    COMMA(TokenCategory.SYMBOL, ",", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, ',')),
    DOT(TokenCategory.SYMBOL, ".", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, TokenType::isDigit, '.')),
    OPTIONAL_DOT(TokenCategory.SYMBOL, "?.", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, TokenType::isDigit, '?', '.')),
    BRACKET_OPEN(TokenCategory.SYMBOL, "[", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '[')),
    OPTIONAL_BRACKET_OPEN(TokenCategory.SYMBOL, "?[", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, '?', '[')),
    BRACKET_CLOSE(TokenCategory.SYMBOL, "]", tokenizer -> TokenType.tryCollectSequenceWithNextCheck(tokenizer, null, ']')),
    COMMENT(TokenCategory.INVISIBLE, null, tokenizer -> {
        StringBuilder result = new StringBuilder();
        if (tokenizer.nextChar() != '#') {
            return null;
        }
        while (tokenizer.hasNextChar() && tokenizer.peekNextChar() != '\n') {
            result.append(tokenizer.nextChar());
        }
        return result.toString();
    });

    private final TokenCategory category;
    private final String representation;
    private final FTokenReader tokenReader;
    public static final TokenType[] valuesInTrialOrder;
    public static final TokenType[] nonNumericTypes;
    public static final TokenType[] valueTypes;

    private TokenType(TokenCategory category, String representation, FTokenReader tokenReader) {
        this.category = category;
        this.representation = representation;
        this.tokenReader = tokenizer -> {
            if (!tokenizer.hasNextChar()) {
                return null;
            }
            return tokenReader.apply(tokenizer);
        };
    }

    public TokenCategory getCategory() {
        return this.category;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public FTokenReader getTokenReader() {
        return this.tokenReader;
    }

    private static void possiblyCollectExponent(ITokenizer tokenizer, StringBuilder result, boolean allowNegativeExponent) {
        if (!tokenizer.hasNextChar() || tokenizer.peekNextChar() != 'e') {
            return;
        }
        tokenizer.saveState(true);
        result.append(tokenizer.nextChar());
        boolean hasNegativeSign = false;
        int negativeSignRow = tokenizer.getCurrentRow();
        int negativeSignCol = tokenizer.getCurrentCol();
        if (tokenizer.hasNextChar() && tokenizer.peekNextChar() == '-') {
            hasNegativeSign = true;
            result.append(tokenizer.nextChar());
        }
        if (TokenType.collectDigits(tokenizer, result, false) == CollectorResult.READ_OKAY) {
            if (!allowNegativeExponent && hasNegativeSign) {
                throw new NegativeExponentOnLongError(negativeSignRow, negativeSignCol, tokenizer.getRawText());
            }
            tokenizer.discardState(true);
            return;
        }
        tokenizer.restoreState(true);
        if (hasNegativeSign) {
            result.deleteCharAt(result.length() - 1);
        }
        result.deleteCharAt(result.length() - 1);
    }

    private static CollectorResult collectDigits(ITokenizer tokenizer, StringBuilder result, boolean stopBeforeDot) {
        if (!tokenizer.hasNextChar()) {
            return CollectorResult.NO_NEXT_CHAR;
        }
        int initialLength = result.length();
        while (tokenizer.hasNextChar()) {
            char c = tokenizer.nextChar();
            if (TokenType.isDigit(c)) {
                result.append(c);
                continue;
            }
            if (tokenizer.isConsideredWhitespace(c) || c == '\n') break;
            if (c == '.' && stopBeforeDot) {
                tokenizer.undoNextChar();
                break;
            }
            tokenizer.undoNextChar();
            if (result.length() - initialLength > 0 && TokenType.wouldFollow(tokenizer, nonNumericTypes)) {
                return CollectorResult.READ_OKAY;
            }
            return CollectorResult.CHAR_MISMATCH;
        }
        return result.length() > 0 ? CollectorResult.READ_OKAY : CollectorResult.CHAR_MISMATCH;
    }

    @Nullable
    private static String tryCollectSequenceWithNextCheck(ITokenizer tokenizer, @Nullable Function<Character, Boolean> notNextCheck, char ... sequence) {
        StringBuilder result = new StringBuilder();
        if (TokenType.collectSequence(tokenizer, result, sequence) != CollectorResult.READ_OKAY) {
            return null;
        }
        if (notNextCheck != null && tokenizer.hasNextChar() && notNextCheck.apply(Character.valueOf(tokenizer.peekNextChar())).booleanValue()) {
            return null;
        }
        return result.toString();
    }

    private static char charToLowerCase(char input) {
        if (input >= 'A' && input <= 'Z') {
            input = (char)(input + 32);
        }
        return input;
    }

    private static CollectorResult collectSequence(ITokenizer tokenizer, StringBuilder result, char ... sequence) {
        for (char c : sequence) {
            if (!tokenizer.hasNextChar()) {
                return CollectorResult.NO_NEXT_CHAR;
            }
            if (TokenType.charToLowerCase(tokenizer.nextChar()) != TokenType.charToLowerCase(c)) {
                return CollectorResult.CHAR_MISMATCH;
            }
            result.append(c);
        }
        return CollectorResult.READ_OKAY;
    }

    private static boolean wouldFollow(ITokenizer tokenizer, TokenType ... types) {
        for (TokenType type : types) {
            FTokenReader reader = type.getTokenReader();
            if (reader == null) continue;
            tokenizer.saveState(false);
            boolean success = type.getTokenReader().apply(tokenizer) != null;
            tokenizer.restoreState(false);
            if (!success) continue;
            return true;
        }
        return false;
    }

    private static boolean isIdentifierChar(char c, boolean isFirst) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || !isFirst && (c == '_' || TokenType.isDigit(c));
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static {
        valuesInTrialOrder = (TokenType[])Arrays.stream(TokenType.values()).sorted(Comparator.comparingInt(tt -> tt.getCategory().ordinal())).toArray(TokenType[]::new);
        nonNumericTypes = (TokenType[])Arrays.stream(TokenType.values()).filter(type -> type != LONG && type != DOUBLE).toArray(TokenType[]::new);
        valueTypes = (TokenType[])Arrays.stream(TokenType.values()).filter(type -> type.getCategory() == TokenCategory.VALUE).toArray(TokenType[]::new);
    }
}

