/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.parser.MathOperation;
import de.jexcellence.gpeee.parser.expression.ABinaryExpression;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import org.jetbrains.annotations.Nullable;

public class MathExpression
extends ABinaryExpression {
    private final MathOperation operation;

    public MathExpression(AExpression lhs, AExpression rhs, MathOperation operation, Token head, Token tail, String fullContainingExpression) {
        super(lhs, rhs, head, tail, fullContainingExpression);
        this.operation = operation;
    }

    public MathOperation getOperation() {
        return this.operation;
    }

    @Override
    public boolean canBeCombinedToOptimize(ABinaryExpression other) {
        if (other instanceof MathExpression) {
            return ((MathExpression)other).getOperation().equals((Object)this.operation);
        }
        return false;
    }

    @Override
    @Nullable
    protected String getInfixSymbol() {
        switch (this.operation) {
            case ADDITION: {
                return TokenType.PLUS.getRepresentation();
            }
            case SUBTRACTION: {
                return TokenType.MINUS.getRepresentation();
            }
            case MULTIPLICATION: {
                return TokenType.MULTIPLICATION.getRepresentation();
            }
            case DIVISION: {
                return TokenType.DIVISION.getRepresentation();
            }
            case MODULO: {
                return TokenType.MODULO.getRepresentation();
            }
            case POWER: {
                return TokenType.EXPONENT.getRepresentation();
            }
        }
        return null;
    }
}

