/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.parser.expression.IdentifierExpression;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FunctionInvocationExpression
extends AExpression {
    private final IdentifierExpression name;
    private final List<Tuple<AExpression, @Nullable IdentifierExpression>> arguments;
    private final boolean optional;

    public FunctionInvocationExpression(IdentifierExpression name, List<Tuple<AExpression, @Nullable IdentifierExpression>> arguments, boolean optional, Token head, Token tail, String fullContainingExpression) {
        super(head, tail, fullContainingExpression);
        this.name = name;
        this.arguments = arguments;
        this.optional = optional;
    }

    public IdentifierExpression getName() {
        return this.name;
    }

    public List<Tuple<AExpression, IdentifierExpression>> getArguments() {
        return this.arguments;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public String expressionify() {
        StringBuilder argExpression = new StringBuilder();
        for (int i = 0; i < this.arguments.size(); ++i) {
            Tuple<AExpression, @Nullable IdentifierExpression> argument = this.arguments.get(i);
            argExpression.append(i == 0 ? "" : ", ");
            if (argument.b != null) {
                argExpression.append(((IdentifierExpression)argument.b).expressionify()).append(TokenType.ASSIGN.getRepresentation());
            }
            argExpression.append(((AExpression)argument.a).expressionify());
        }
        return this.name.expressionify() + TokenType.PARENTHESIS_OPEN.getRepresentation() + String.valueOf(argExpression) + TokenType.PARENTHESIS_CLOSE.getRepresentation();
    }
}

