/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.parser.EqualityOperation;
import de.jexcellence.gpeee.parser.expression.ABinaryExpression;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import org.jetbrains.annotations.Nullable;

public class EqualityExpression
extends ABinaryExpression {
    private final EqualityOperation operation;

    public EqualityExpression(AExpression lhs, AExpression rhs, EqualityOperation operation, Token head, Token tail, String fullContainingExpression) {
        super(lhs, rhs, head, tail, fullContainingExpression);
        this.operation = operation;
    }

    public EqualityOperation getOperation() {
        return this.operation;
    }

    @Override
    public boolean canBeCombinedToOptimize(ABinaryExpression other) {
        if (other instanceof EqualityExpression) {
            return ((EqualityExpression)other).getOperation().equals((Object)this.operation);
        }
        return false;
    }

    @Override
    @Nullable
    protected String getInfixSymbol() {
        switch (this.operation) {
            case EQUAL: {
                return TokenType.VALUE_EQUALS.getRepresentation();
            }
            case NOT_EQUAL: {
                return TokenType.VALUE_NOT_EQUALS.getRepresentation();
            }
            case EQUAL_EXACT: {
                return TokenType.VALUE_EQUALS_EXACT.getRepresentation();
            }
            case NOT_EQUAL_EXACT: {
                return TokenType.VALUE_NOT_EQUALS_EXACT.getRepresentation();
            }
        }
        return null;
    }
}

