/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.parser.ComparisonOperation;
import de.jexcellence.gpeee.parser.expression.ABinaryExpression;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import org.jetbrains.annotations.Nullable;

public class ComparisonExpression
extends ABinaryExpression {
    private final ComparisonOperation operation;

    public ComparisonExpression(AExpression lhs, AExpression rhs, ComparisonOperation operation, Token head, Token tail, String fullContainingExpression) {
        super(lhs, rhs, head, tail, fullContainingExpression);
        this.operation = operation;
    }

    public ComparisonOperation getOperation() {
        return this.operation;
    }

    @Override
    public boolean canBeCombinedToOptimize(ABinaryExpression other) {
        if (other instanceof ComparisonExpression) {
            return ((ComparisonExpression)other).getOperation().equals((Object)this.operation);
        }
        return false;
    }

    @Override
    @Nullable
    protected String getInfixSymbol() {
        switch (this.operation) {
            case LESS_THAN: {
                return TokenType.LESS_THAN.getRepresentation();
            }
            case GREATER_THAN: {
                return TokenType.GREATER_THAN.getRepresentation();
            }
            case LESS_THAN_OR_EQUAL: {
                return TokenType.LESS_THAN_OR_EQUAL.getRepresentation();
            }
            case GREATER_THAN_OR_EQUAL: {
                return TokenType.GREATER_THAN_OR_EQUAL.getRepresentation();
            }
        }
        return null;
    }
}

