/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.parser.expression.IdentifierExpression;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import java.util.List;

public class CallbackExpression
extends AExpression {
    private final List<IdentifierExpression> signature;
    private AExpression body;

    public CallbackExpression(List<IdentifierExpression> signature, AExpression body, Token head, Token tail, String fullContainingExpression) {
        super(head, tail, fullContainingExpression);
        this.signature = signature;
        this.body = body;
    }

    public List<IdentifierExpression> getSignature() {
        return this.signature;
    }

    public AExpression getBody() {
        return this.body;
    }

    public void setBody(AExpression body) {
        this.body = body;
    }

    @Override
    public String expressionify() {
        StringBuilder argExpression = new StringBuilder();
        for (int i = 0; i < this.signature.size(); ++i) {
            IdentifierExpression argument = this.signature.get(i);
            argExpression.append(i == 0 ? "" : ", ").append(argument.getSymbol());
        }
        return TokenType.PARENTHESIS_OPEN.getRepresentation() + String.valueOf(argExpression) + TokenType.PARENTHESIS_CLOSE.getRepresentation() + " " + TokenType.ARROW.getRepresentation() + " " + this.body.expressionify();
    }
}

