/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.parser.expression.StringifyExclude;
import de.jexcellence.gpeee.tokenizer.Token;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class AExpression {
    @StringifyExclude
    private final Token head;
    @StringifyExclude
    private final Token tail;
    @StringifyExclude
    private final String fullContainingExpression;

    public AExpression(Token head, Token tail, String fullContainingExpression) {
        this.head = head;
        this.tail = tail;
        this.fullContainingExpression = fullContainingExpression;
    }

    public Token getHead() {
        return this.head;
    }

    public Token getTail() {
        return this.tail;
    }

    public String getFullContainingExpression() {
        return this.fullContainingExpression;
    }

    public abstract String expressionify();

    public String stringify(String indentWidth, int indentLevel) throws Exception {
        String indent = String.join((CharSequence)"", Collections.nCopies(indentLevel, indentWidth));
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName() + " {\n");
        boolean firstField = true;
        for (Class<?> currentClass = this.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field f : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(StringifyExclude.class)) continue;
                try {
                    f.setAccessible(true);
                }
                catch (Exception e) {
                    continue;
                }
                if (!firstField) {
                    result.append(",\n");
                }
                Object value = f.get(this);
                result.append(indent).append(indentWidth).append(f.getName()).append('=');
                result.append(this.stringifyObject(value, indent, indentWidth, indentLevel + 1));
                firstField = false;
            }
        }
        if (!firstField) {
            result.append("\n");
        }
        result.append(indent).append("}");
        return result.toString();
    }

    private String stringifyObject(@Nullable Object object, String indent, String indentWidth, int indentLevel) throws Exception {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof AExpression) {
            return ((AExpression)object).stringify(indentWidth, indentLevel);
        }
        if (object instanceof List) {
            List valueList = (List)object;
            StringBuilder listBuilder = new StringBuilder("[\n");
            for (Object item : valueList) {
                listBuilder.append(indent).append(String.join((CharSequence)"", Collections.nCopies(2, indentWidth))).append(this.stringifyObject(item, indent, indentWidth, indentLevel + 2)).append('\n');
            }
            listBuilder.append(indent).append(indentWidth).append("]");
            return listBuilder.toString();
        }
        if (object instanceof Tuple) {
            Tuple tuple = (Tuple)object;
            return "Tuple(a=" + this.stringifyObject(tuple.a, indent, indentWidth, indentLevel - 1) + ", b=" + this.stringifyObject(tuple.b, indent, indentWidth, indentLevel - 1) + ")";
        }
        return object.toString();
    }
}

