/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser.expression;

import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import org.jetbrains.annotations.Nullable;

public abstract class ABinaryExpression
extends AExpression {
    protected AExpression lhs;
    protected AExpression rhs;

    public ABinaryExpression(AExpression lhs, AExpression rhs, Token head, Token tail, String fullContainingExpression) {
        super(head, tail, fullContainingExpression);
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public AExpression getLhs() {
        return this.lhs;
    }

    public AExpression getRhs() {
        return this.rhs;
    }

    public void setLhs(AExpression lhs) {
        this.lhs = lhs;
    }

    public void setRhs(AExpression rhs) {
        this.rhs = rhs;
    }

    @Override
    public String expressionify() {
        return TokenType.PARENTHESIS_OPEN.getRepresentation() + this.lhs.expressionify() + " " + this.getInfixSymbol() + " " + this.rhs.expressionify() + TokenType.PARENTHESIS_CLOSE.getRepresentation();
    }

    public abstract boolean canBeCombinedToOptimize(ABinaryExpression var1);

    @Nullable
    protected abstract String getInfixSymbol();
}

