/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser;

import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.error.AEvaluatorError;
import de.jexcellence.gpeee.error.UnexpectedTokenError;
import de.jexcellence.gpeee.logging.DebugLogSource;
import de.jexcellence.gpeee.parser.ComparisonOperation;
import de.jexcellence.gpeee.parser.EqualityOperation;
import de.jexcellence.gpeee.parser.FBinaryExpressionWrapper;
import de.jexcellence.gpeee.parser.FExpressionParser;
import de.jexcellence.gpeee.parser.FUnaryExpressionWrapper;
import de.jexcellence.gpeee.parser.LiteralType;
import de.jexcellence.gpeee.parser.MathOperation;
import de.jexcellence.gpeee.parser.PrecedenceMode;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.parser.expression.AssignmentExpression;
import de.jexcellence.gpeee.parser.expression.CallbackExpression;
import de.jexcellence.gpeee.parser.expression.ComparisonExpression;
import de.jexcellence.gpeee.parser.expression.ConcatenationExpression;
import de.jexcellence.gpeee.parser.expression.ConjunctionExpression;
import de.jexcellence.gpeee.parser.expression.DisjunctionExpression;
import de.jexcellence.gpeee.parser.expression.DoubleExpression;
import de.jexcellence.gpeee.parser.expression.EqualityExpression;
import de.jexcellence.gpeee.parser.expression.FlipSignExpression;
import de.jexcellence.gpeee.parser.expression.FunctionInvocationExpression;
import de.jexcellence.gpeee.parser.expression.IdentifierExpression;
import de.jexcellence.gpeee.parser.expression.IfThenElseExpression;
import de.jexcellence.gpeee.parser.expression.IndexExpression;
import de.jexcellence.gpeee.parser.expression.InvertExpression;
import de.jexcellence.gpeee.parser.expression.LiteralExpression;
import de.jexcellence.gpeee.parser.expression.LongExpression;
import de.jexcellence.gpeee.parser.expression.MathExpression;
import de.jexcellence.gpeee.parser.expression.MemberAccessExpression;
import de.jexcellence.gpeee.parser.expression.NullCoalesceExpression;
import de.jexcellence.gpeee.parser.expression.ProgramExpression;
import de.jexcellence.gpeee.parser.expression.StringExpression;
import de.jexcellence.gpeee.tokenizer.ITokenizer;
import de.jexcellence.gpeee.tokenizer.Token;
import de.jexcellence.gpeee.tokenizer.TokenType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Parser {
    private final Logger logger;
    private final FExpressionParser[] precedenceLadder;

    public Parser(Logger logger) {
        this.logger = logger;
        this.precedenceLadder = new FExpressionParser[]{this::parseAssignmentExpression, this::parseNullCoalesceExpression, this::parseConcatenationExpression, this::parseDisjunctionExpression, this::parseConjunctionExpression, this::parseEqualityExpression, this::parseComparisonExpression, this::parseAdditiveExpression, this::parseMultiplicativeExpression, this::parseExponentiationExpression, this::parseNegationExpression, this::parseFlipSignExpression, this::parseIndexExpression, this::parseMemberAccessExpression, this::parseFunctionInvocationExpression, this::parseIfThenElseExpression, this::parseCallbackExpression, this::parseParenthesisExpression, (tk, s) -> this.parsePrimaryExpression(tk)};
    }

    public ProgramExpression parse(ITokenizer tokenizer) throws AEvaluatorError {
        ArrayList<AExpression> lines = new ArrayList<AExpression>();
        while (tokenizer.peekToken() != null) {
            lines.add(this.invokeLowestPrecedenceParser(tokenizer));
        }
        if (lines.isEmpty()) {
            throw new UnexpectedTokenError(tokenizer, null, TokenType.valuesInTrialOrder);
        }
        return new ProgramExpression(lines, ((AExpression)lines.getFirst()).getHead(), ((AExpression)lines.getLast()).getTail(), tokenizer.getRawText());
    }

    private AExpression parseIfThenElseExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a if then else expression");
        Token tk = tokenizer.peekToken();
        if (tk == null || tk.getType() != TokenType.KW_IF) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a if then else expression");
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        Token head = tokenizer.consumeToken();
        AExpression condition = this.invokeLowestPrecedenceParser(tokenizer);
        tk = tokenizer.consumeToken();
        if (tk == null || tk.getType() != TokenType.KW_THEN) {
            throw new UnexpectedTokenError(tokenizer, tk, TokenType.KW_ELSE);
        }
        AExpression positiveBody = this.invokeLowestPrecedenceParser(tokenizer);
        tk = tokenizer.consumeToken();
        if (tk == null || tk.getType() != TokenType.KW_ELSE) {
            throw new UnexpectedTokenError(tokenizer, tk, TokenType.KW_ELSE);
        }
        AExpression negativeBody = this.invokeLowestPrecedenceParser(tokenizer);
        return new IfThenElseExpression(condition, positiveBody, negativeBody, head, tk, tokenizer.getRawText());
    }

    private AExpression parseCallbackExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a callback expression");
        Token tk = tokenizer.previousToken();
        if (tk != null && tk.getType() == TokenType.DOT) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a callback expression");
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        tk = tokenizer.peekToken();
        if (tk == null || tk.getType() != TokenType.PARENTHESIS_OPEN) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a callback expression");
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        tokenizer.saveState(true);
        Token head = tokenizer.consumeToken();
        ArrayList<IdentifierExpression> signature = new ArrayList<IdentifierExpression>();
        while ((tk = tokenizer.peekToken()) != null && tk.getType() != TokenType.PARENTHESIS_CLOSE) {
            AExpression identifier;
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Parsing argument " + signature.size());
            if (!signature.isEmpty()) {
                if (tk.getType() != TokenType.COMMA) {
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a callback expression");
                    tokenizer.restoreState(true);
                    return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
                }
                tokenizer.consumeToken();
            }
            try {
                identifier = this.parsePrimaryExpression(tokenizer);
            }
            catch (UnexpectedTokenError e) {
                identifier = null;
            }
            if (!(identifier instanceof IdentifierExpression)) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a callback expression");
                tokenizer.restoreState(true);
                return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
            }
            signature.add((IdentifierExpression)identifier);
        }
        tk = tokenizer.consumeToken();
        if (tk == null || tk.getType() != TokenType.PARENTHESIS_CLOSE) {
            throw new UnexpectedTokenError(tokenizer, tk, TokenType.PARENTHESIS_CLOSE);
        }
        tk = tokenizer.consumeToken();
        if (tk == null || tk.getType() != TokenType.ARROW) {
            throw new UnexpectedTokenError(tokenizer, tk, TokenType.ARROW);
        }
        AExpression body = this.invokeLowestPrecedenceParser(tokenizer);
        return new CallbackExpression(signature, body, head, body.getTail(), tokenizer.getRawText());
    }

    private AExpression parseFunctionInvocationExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a function invocation expression");
        Token tk = tokenizer.peekToken();
        if (tk == null || tk.getType() != TokenType.IDENTIFIER) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a function invocation expression");
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        tokenizer.saveState(true);
        Token tokenIdentifier = tk;
        tokenizer.consumeToken();
        tk = tokenizer.peekToken();
        if (tk == null || tk.getType() != TokenType.PARENTHESIS_OPEN && tk.getType() != TokenType.OPTIONAL_PARENTHESIS_OPEN) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a function invocation expression");
            tokenizer.restoreState(true);
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        tokenizer.discardState(true);
        Token paren = tk;
        tokenizer.consumeToken();
        ArrayList<Tuple<AExpression, @Nullable IdentifierExpression>> arguments = new ArrayList<Tuple<AExpression, IdentifierExpression>>();
        while ((tk = tokenizer.peekToken()) != null && tk.getType() != TokenType.PARENTHESIS_CLOSE) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Parsing argument " + arguments.size());
            if (!arguments.isEmpty()) {
                if (tk.getType() != TokenType.COMMA) {
                    throw new UnexpectedTokenError(tokenizer, tk, TokenType.COMMA);
                }
                tokenizer.consumeToken();
            }
            Token identifier = null;
            tk = tokenizer.peekToken();
            if (tk != null && tk.getType() == TokenType.IDENTIFIER) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a named argument");
                tokenizer.saveState(true);
                identifier = tokenizer.consumeToken();
                tk = tokenizer.peekToken();
                if (tk == null || tk.getType() != TokenType.ASSIGN) {
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not a named argument");
                    tokenizer.restoreState(true);
                    identifier = null;
                } else {
                    tokenizer.discardState(true);
                    tokenizer.consumeToken();
                }
            }
            arguments.add(new Tuple<AExpression, IdentifierExpression>(this.invokeLowestPrecedenceParser(tokenizer), identifier == null ? null : new IdentifierExpression(identifier.getValue(), identifier, identifier, tokenizer.getRawText())));
        }
        tk = tokenizer.consumeToken();
        if (tk == null || tk.getType() != TokenType.PARENTHESIS_CLOSE) {
            throw new UnexpectedTokenError(tokenizer, tk, TokenType.PARENTHESIS_CLOSE);
        }
        IdentifierExpression identifierExpression = new IdentifierExpression(tokenIdentifier.getValue(), tokenIdentifier, tokenIdentifier, tokenizer.getRawText());
        return new FunctionInvocationExpression(identifierExpression, arguments, paren.getType() == TokenType.OPTIONAL_PARENTHESIS_OPEN, tokenIdentifier, tk, tokenizer.getRawText());
    }

    private AExpression parseNegationExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseUnaryExpression((input, h, t, op) -> new InvertExpression(input, h, t, tokenizer.getRawText()), tokenizer, precedenceSelf, false, new TokenType[]{TokenType.BOOL_NOT}, null);
    }

    private AExpression parseParenthesisExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseUnaryExpression((input, h, t, op) -> input, tokenizer, precedenceSelf, true, new TokenType[]{TokenType.PARENTHESIS_OPEN}, new TokenType[]{TokenType.PARENTHESIS_CLOSE});
    }

    private AExpression parseFlipSignExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseUnaryExpression((input, h, t, op) -> new FlipSignExpression(input, h, t, tokenizer.getRawText()), tokenizer, precedenceSelf, false, new TokenType[]{TokenType.MINUS}, null);
    }

    private AExpression parseMemberAccessExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new MemberAccessExpression(lhs, rhs, op.getType() == TokenType.OPTIONAL_DOT, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.DOT, TokenType.OPTIONAL_DOT}, null);
    }

    private AExpression parseIndexExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new IndexExpression(lhs, rhs, op.getType() == TokenType.OPTIONAL_BRACKET_OPEN, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.RESET, precedenceSelf, new TokenType[]{TokenType.BRACKET_OPEN, TokenType.OPTIONAL_BRACKET_OPEN}, new TokenType[]{TokenType.BRACKET_CLOSE, TokenType.BRACKET_CLOSE});
    }

    private AExpression parseComparisonExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> {
            ComparisonOperation operator = switch (op.getType()) {
                case TokenType.GREATER_THAN -> ComparisonOperation.GREATER_THAN;
                case TokenType.GREATER_THAN_OR_EQUAL -> ComparisonOperation.GREATER_THAN_OR_EQUAL;
                case TokenType.LESS_THAN -> ComparisonOperation.LESS_THAN;
                case TokenType.LESS_THAN_OR_EQUAL -> ComparisonOperation.LESS_THAN_OR_EQUAL;
                default -> throw new IllegalStateException();
            };
            return new ComparisonExpression(lhs, rhs, operator, h, t, tokenizer.getRawText());
        }, tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.GREATER_THAN, TokenType.GREATER_THAN_OR_EQUAL, TokenType.LESS_THAN, TokenType.LESS_THAN_OR_EQUAL}, null);
    }

    private AExpression parseAssignmentExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse an assignment expression");
        Token tk = tokenizer.peekToken();
        if (tk == null || tk.getType() != TokenType.IDENTIFIER) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not an assignment expression");
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        tokenizer.saveState(true);
        Token identifier = tk;
        tokenizer.consumeToken();
        tk = tokenizer.peekToken();
        if (tk == null || tk.getType() != TokenType.ASSIGN) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Not an assignment expression");
            tokenizer.restoreState(true);
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        tokenizer.discardState(true);
        tokenizer.consumeToken();
        AExpression value = this.invokeLowestPrecedenceParser(tokenizer);
        return new AssignmentExpression(new IdentifierExpression(identifier.getValue(), identifier, identifier, tokenizer.getRawText()), value, identifier, value.getTail(), tokenizer.getRawText());
    }

    private AExpression parseNullCoalesceExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new NullCoalesceExpression(lhs, rhs, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.NULL_COALESCE}, null);
    }

    private AExpression parseConcatenationExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new ConcatenationExpression(lhs, rhs, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.CONCATENATE}, null);
    }

    private AExpression parseDisjunctionExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new DisjunctionExpression(lhs, rhs, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.BOOL_OR}, null);
    }

    private AExpression parseConjunctionExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new ConjunctionExpression(lhs, rhs, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.BOOL_AND}, null);
    }

    private AExpression parseEqualityExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> {
            EqualityOperation operator = switch (op.getType()) {
                case TokenType.VALUE_EQUALS -> EqualityOperation.EQUAL;
                case TokenType.VALUE_NOT_EQUALS -> EqualityOperation.NOT_EQUAL;
                case TokenType.VALUE_EQUALS_EXACT -> EqualityOperation.EQUAL_EXACT;
                case TokenType.VALUE_NOT_EQUALS_EXACT -> EqualityOperation.NOT_EQUAL_EXACT;
                default -> throw new IllegalStateException();
            };
            return new EqualityExpression(lhs, rhs, operator, h, t, tokenizer.getRawText());
        }, tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.VALUE_EQUALS, TokenType.VALUE_NOT_EQUALS, TokenType.VALUE_EQUALS_EXACT, TokenType.VALUE_NOT_EQUALS_EXACT}, null);
    }

    private AExpression parseAdditiveExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> {
            MathOperation operator = MathOperation.ADDITION;
            if (op.getType() == TokenType.MINUS) {
                operator = MathOperation.SUBTRACTION;
            }
            return new MathExpression(lhs, rhs, operator, h, t, tokenizer.getRawText());
        }, tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.PLUS, TokenType.MINUS}, null);
    }

    private AExpression parseMultiplicativeExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> {
            MathOperation operator = MathOperation.MULTIPLICATION;
            if (op.getType() == TokenType.DIVISION) {
                operator = MathOperation.DIVISION;
            } else if (op.getType() == TokenType.MODULO) {
                operator = MathOperation.MODULO;
            }
            return new MathExpression(lhs, rhs, operator, h, t, tokenizer.getRawText());
        }, tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.MULTIPLICATION, TokenType.DIVISION, TokenType.MODULO}, null);
    }

    private AExpression parseExponentiationExpression(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.parseBinaryExpression((lhs, rhs, h, t, op) -> new MathExpression(lhs, rhs, MathOperation.POWER, h, t, tokenizer.getRawText()), tokenizer, PrecedenceMode.HIGHER, precedenceSelf, new TokenType[]{TokenType.EXPONENT}, null);
    }

    private AExpression parsePrimaryExpression(ITokenizer tokenizer) throws AEvaluatorError {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a primary expression");
        Token tk = tokenizer.consumeToken();
        if (tk == null) {
            throw new UnexpectedTokenError(tokenizer, null, TokenType.valueTypes);
        }
        return switch (tk.getType()) {
            case TokenType.LONG -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found an integer");
                yield new LongExpression(this.parseIntegerWithPossibleExponent(tk), tk, tk, tokenizer.getRawText());
            }
            case TokenType.DOUBLE -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found a double");
                yield new DoubleExpression(Double.parseDouble(tk.getValue()), tk, tk, tokenizer.getRawText());
            }
            case TokenType.STRING -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found a string");
                yield new StringExpression(tk.getValue(), tk, tk, tokenizer.getRawText());
            }
            case TokenType.IDENTIFIER -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found an identifier");
                yield new IdentifierExpression(tk.getValue(), tk, tk, tokenizer.getRawText());
            }
            case TokenType.TRUE -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found the true literal");
                yield new LiteralExpression(LiteralType.TRUE, tk, tk, tokenizer.getRawText());
            }
            case TokenType.FALSE -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found the false literal");
                yield new LiteralExpression(LiteralType.FALSE, tk, tk, tokenizer.getRawText());
            }
            case TokenType.NULL -> {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Found the null literal");
                yield new LiteralExpression(LiteralType.NULL, tk, tk, tokenizer.getRawText());
            }
            default -> throw new UnexpectedTokenError(tokenizer, tk, TokenType.valueTypes);
        };
    }

    private AExpression invokeLowestPrecedenceParser(ITokenizer tokenizer) throws AEvaluatorError {
        return this.precedenceLadder[0].apply(tokenizer, 0);
    }

    private AExpression invokeNextPrecedenceParser(ITokenizer tokenizer, int precedenceSelf) throws AEvaluatorError {
        return this.precedenceLadder[precedenceSelf + 1].apply(tokenizer, precedenceSelf + 1);
    }

    private int matchingTypeIndex(TokenType[] types, Token tk) {
        for (int i = 0; i < types.length; ++i) {
            if (tk.getType() != types[i]) continue;
            return i;
        }
        return -1;
    }

    private AExpression parseUnaryExpression(FUnaryExpressionWrapper wrapper, ITokenizer tokenizer, int precedenceSelf, boolean resetPrecedence, TokenType[] operators, @Nullable TokenType[] terminators) {
        int opInd;
        String requiredOperatorsString = Arrays.stream(operators).map(Enum::name).collect(Collectors.joining("|"));
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a unary expression for the operator " + requiredOperatorsString);
        Token tk = tokenizer.peekToken();
        if (tk == null || (opInd = this.matchingTypeIndex(operators, tk)) < 0) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Doesn't match any required operators of " + requiredOperatorsString);
            return this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        }
        Token operator = tokenizer.consumeToken();
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse an input for this expression");
        AExpression input = resetPrecedence ? this.invokeLowestPrecedenceParser(tokenizer) : this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        if (terminators != null && ((tk = tokenizer.consumeToken()) == null || tk.getType() != terminators[opInd])) {
            throw new UnexpectedTokenError(tokenizer, tk, terminators[opInd]);
        }
        return wrapper.apply(input, operator, input.getTail(), operator);
    }

    private AExpression parseBinaryExpression(FBinaryExpressionWrapper wrapper, ITokenizer tokenizer, PrecedenceMode rhsPrecedence, int precedenceSelf, TokenType[] operators, @Nullable TokenType[] terminators) throws AEvaluatorError {
        int opInd;
        Token tk;
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a binary expression for the operator " + Arrays.stream(operators).map(Enum::name).collect(Collectors.joining("|")));
        AExpression lhs = this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
        Token head = lhs.getHead();
        while ((tk = tokenizer.peekToken()) != null && (opInd = this.matchingTypeIndex(operators, tk)) >= 0) {
            AExpression rhs;
            tokenizer.consumeToken();
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.PARSER) + "Trying to parse a rhs for this operation");
            if (rhsPrecedence == PrecedenceMode.HIGHER) {
                rhs = this.invokeNextPrecedenceParser(tokenizer, precedenceSelf);
            } else if (rhsPrecedence == PrecedenceMode.RESET) {
                rhs = this.invokeLowestPrecedenceParser(tokenizer);
            } else {
                throw new IllegalStateException("Unimplemented precedence mode");
            }
            Token operator = tk;
            if (terminators != null && ((tk = tokenizer.consumeToken()) == null || tk.getType() != terminators[opInd])) {
                throw new UnexpectedTokenError(tokenizer, tk, terminators[opInd]);
            }
            lhs = wrapper.apply(lhs, rhs, head, rhs.getTail(), operator);
        }
        return lhs;
    }

    private int parseIntegerWithPossibleExponent(Token tk) {
        int number;
        String tokenValue = tk.getValue();
        int exponentIndicatorIndex = tokenValue.indexOf(101);
        if (exponentIndicatorIndex < 0) {
            number = Integer.parseInt(tokenValue);
        } else {
            int numberValue = Integer.parseInt(tokenValue.substring(0, exponentIndicatorIndex));
            int exponentValue = Integer.parseInt(tokenValue.substring(exponentIndicatorIndex + 1));
            number = numberValue * (int)Math.pow(10.0, exponentValue);
        }
        return number;
    }
}

