/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.parser;

import de.jexcellence.gpeee.GPEEE;
import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.error.AEvaluatorError;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.interpreter.Interpreter;
import de.jexcellence.gpeee.logging.DebugLogSource;
import de.jexcellence.gpeee.parser.LiteralType;
import de.jexcellence.gpeee.parser.expression.ABinaryExpression;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.parser.expression.AUnaryExpression;
import de.jexcellence.gpeee.parser.expression.CallbackExpression;
import de.jexcellence.gpeee.parser.expression.DoubleExpression;
import de.jexcellence.gpeee.parser.expression.FunctionInvocationExpression;
import de.jexcellence.gpeee.parser.expression.IdentifierExpression;
import de.jexcellence.gpeee.parser.expression.IfThenElseExpression;
import de.jexcellence.gpeee.parser.expression.LiteralExpression;
import de.jexcellence.gpeee.parser.expression.LongExpression;
import de.jexcellence.gpeee.parser.expression.ProgramExpression;
import de.jexcellence.gpeee.parser.expression.StringExpression;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class Optimizer {
    private final Logger logger;
    private final Interpreter interpreter;
    private final IStandardFunctionRegistry standardFunctionRegistry;

    public Optimizer(Logger logger, Interpreter interpreter, IStandardFunctionRegistry standardFunctionRegistry) {
        this.logger = logger;
        this.interpreter = interpreter;
        this.standardFunctionRegistry = standardFunctionRegistry;
    }

    public AExpression optimizeAST(AExpression expression) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Starting to optimize the expression " + expression.expressionify());
        return this.optimizeASTSub(expression, null);
    }

    private AExpression optimizeASTSub(AExpression expression, @Nullable Consumer<AExpression> substituteParent) throws AEvaluatorError {
        if (expression instanceof ProgramExpression) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Encountered a program expression");
            ProgramExpression program = (ProgramExpression)expression;
            program.getLines().replaceAll(aExpression -> this.optimizeASTSub((AExpression)aExpression, null));
            return expression;
        }
        if (expression instanceof ABinaryExpression) {
            ABinaryExpression lhsBinary;
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Encountered a binary expression");
            ABinaryExpression binary = (ABinaryExpression)expression;
            boolean lhsIs = this.isImmediatelyResolvable(binary.getLhs());
            boolean rhsIs = this.isImmediatelyResolvable(binary.getRhs());
            if (lhsIs && rhsIs) {
                AExpression result = this.wrapValue(binary.getLhs(), this.interpreter.evaluateExpression(binary, GPEEE.EMPTY_ENVIRONMENT));
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Resolved expression, value: " + result.expressionify());
                if (substituteParent == null) {
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Responding with result as root node");
                    return result;
                }
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Substituting result using provided callback");
                substituteParent.accept(result);
                return null;
            }
            if (!lhsIs) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize it's lhs");
                this.optimizeASTSub(binary.getLhs(), binary::setLhs);
            }
            if (!rhsIs) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize it's rhs");
                this.optimizeASTSub(binary.getRhs(), binary::setRhs);
            }
            rhsIs = this.isImmediatelyResolvable(binary.getRhs());
            if (this.isImmediatelyResolvable(binary.getLhs()) && rhsIs) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Is now resolvable, optimizing whole expression");
                return this.optimizeASTSub(binary, substituteParent);
            }
            if (rhsIs && binary.getClass() == binary.getLhs().getClass() && binary.canBeCombinedToOptimize(lhsBinary = (ABinaryExpression)binary.getLhs()) && this.isImmediatelyResolvable(lhsBinary.getRhs())) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Going to combine expression's RHS with LHS' RHS");
                AExpression lhsBinaryLhsSave = lhsBinary.getLhs();
                lhsBinary.setLhs(lhsBinary.getRhs());
                lhsBinary.setRhs(binary.getRhs());
                AExpression result = this.wrapValue(binary, this.interpreter.evaluateExpression(lhsBinary, GPEEE.EMPTY_ENVIRONMENT));
                binary.setRhs(result);
                binary.setLhs(lhsBinaryLhsSave);
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Done, optimized out expression's resolvable RHS");
                return binary;
            }
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Whole expression is not resolvable");
            return binary;
        }
        if (expression instanceof AUnaryExpression) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Encountered a unary expression");
            AUnaryExpression unary = (AUnaryExpression)expression;
            if (this.isImmediatelyResolvable(unary.getInput())) {
                AExpression result = this.wrapValue(unary.getInput(), this.interpreter.evaluateExpression(unary, GPEEE.EMPTY_ENVIRONMENT));
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Resolved expression, value: " + result.expressionify());
                if (substituteParent == null) {
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Responding with result as root node");
                    return result;
                }
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Substituting result using provided callback");
                substituteParent.accept(result);
                return null;
            }
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize it's input");
            this.optimizeASTSub(unary.getInput(), unary::setInput);
            if (this.isImmediatelyResolvable(unary.getInput())) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Is now resolvable, optimizing whole expression");
                return this.optimizeASTSub(unary, substituteParent);
            }
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Whole expression is not resolvable");
            return unary;
        }
        if (expression instanceof CallbackExpression) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Encountered a callback expression");
            CallbackExpression callback = (CallbackExpression)expression;
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize callback body");
            this.optimizeASTSub(callback.getBody(), callback::setBody);
        }
        if (expression instanceof FunctionInvocationExpression) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Encountered a function invocation expression");
            FunctionInvocationExpression invocation = (FunctionInvocationExpression)expression;
            String name = invocation.getName().getSymbol();
            boolean allArgsResolvable = true;
            for (int i = 0; i < invocation.getArguments().size(); ++i) {
                int argumentIndex = i;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize function argument " + (argumentIndex + 1));
                Tuple<AExpression, @Nullable IdentifierExpression> argument = invocation.getArguments().get(argumentIndex);
                this.optimizeASTSub((AExpression)argument.a, v -> {
                    argument.a = v;
                });
                if (this.isImmediatelyResolvable((AExpression)argument.a)) continue;
                allArgsResolvable = false;
            }
            AStandardFunction standardFunction = this.standardFunctionRegistry.lookup(name);
            if (standardFunction != null && standardFunction.returnsPrimaryResult() && allArgsResolvable) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Evaluating std-function call to " + name + " with all resolvable arguments");
                return this.wrapValue(invocation, this.interpreter.evaluateExpression(invocation, GPEEE.EMPTY_ENVIRONMENT));
            }
            return expression;
        }
        if (expression instanceof IfThenElseExpression) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Encountered a if then else expression");
            IfThenElseExpression ifExpression = (IfThenElseExpression)expression;
            if (!this.isImmediatelyResolvable(ifExpression.getCondition())) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize it's condition");
                this.optimizeASTSub(ifExpression.getCondition(), ifExpression::setCondition);
            }
            if (this.isImmediatelyResolvable(ifExpression.getCondition())) {
                AExpression result;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Condition has been evaluated, substituting body");
                Object condition = this.interpreter.evaluateExpression(ifExpression.getCondition(), GPEEE.EMPTY_ENVIRONMENT);
                AExpression aExpression2 = result = GPEEE.STD_VALUE_INTERPRETER.asBoolean(condition) ? ifExpression.getPositiveBody() : ifExpression.getNegativeBody();
                if (!this.isImmediatelyResolvable(result)) {
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Trying to optimize it's result");
                    result = this.optimizeASTSub(result, null);
                }
                if (this.isImmediatelyResolvable(result)) {
                    return this.wrapValue(result, this.interpreter.evaluateExpression(result, GPEEE.EMPTY_ENVIRONMENT));
                }
                return result;
            }
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.OPTIMIZER) + "Cannot optimize node " + expression.getClass().getSimpleName());
        return expression;
    }

    private AExpression wrapValue(AExpression previous, @Nullable Object value) {
        if (value == null) {
            return new LiteralExpression(LiteralType.NULL, previous.getHead(), previous.getTail(), previous.getFullContainingExpression());
        }
        if (value instanceof Boolean) {
            return new LiteralExpression((Boolean)value != false ? LiteralType.TRUE : LiteralType.FALSE, previous.getHead(), previous.getTail(), previous.getFullContainingExpression());
        }
        if (value instanceof String) {
            return new StringExpression((String)value, previous.getHead(), previous.getTail(), previous.getFullContainingExpression());
        }
        if (value instanceof Long || value instanceof Integer) {
            return new LongExpression(((Number)value).longValue(), previous.getHead(), previous.getTail(), previous.getFullContainingExpression());
        }
        if (value instanceof Double || value instanceof Float) {
            return new DoubleExpression(((Number)value).doubleValue(), previous.getHead(), previous.getTail(), previous.getFullContainingExpression());
        }
        throw new IllegalStateException("Unimplemented value type encountered");
    }

    private boolean isImmediatelyResolvable(AExpression expression) {
        return expression instanceof DoubleExpression || expression instanceof LongExpression || expression instanceof StringExpression || expression instanceof LiteralExpression;
    }
}

