/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.interpreter;

import de.jexcellence.gpeee.interpreter.IValueInterpreter;
import de.jexcellence.gpeee.parser.MathOperation;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.Nullable;

public class StandardValueInterpreter
implements IValueInterpreter {
    @Override
    public boolean asBoolean(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.compare(value, 0) > 0;
    }

    @Override
    public long asLong(@Nullable Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Boolean.class, Number.class, Collection.class, Map.class}, (Object)object, n)) {
            case -1: {
                return 0L;
            }
            case 0: {
                Long l = (Long)object;
                return l;
            }
            case 1: {
                Boolean b = (Boolean)object;
                return b != false ? 1L : 0L;
            }
            case 2: {
                Number number = (Number)object;
                return number.longValue();
            }
            case 3: {
                Collection collection = (Collection)object;
                return collection.isEmpty() ? 0L : 1L;
            }
            case 4: {
                Map map = (Map)object;
                return map.isEmpty() ? 0L : 1L;
            }
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0 ? 0L : 1L;
        }
        if (value instanceof String) {
            return this.isBlank((String)value) ? 0L : 1L;
        }
        return 0L;
    }

    private boolean isBlank(String input) {
        for (char c : input.toCharArray()) {
            if (c == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public double asDouble(@Nullable Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Number.class}, (Object)object, n)) {
            case -1 -> 0.0;
            case 0 -> {
                Double v = (Double)object;
                yield v;
            }
            case 1 -> {
                Number number = (Number)object;
                yield number.doubleValue();
            }
            default -> this.asLong(value);
        };
    }

    @Override
    public String asString(@Nullable Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Map.class, Map.Entry.class}, (Object)object, n)) {
            case -1: {
                return "<null>";
            }
            case 0: {
                String s = (String)object;
                return s;
            }
            case 1: {
                Map map = (Map)object;
                return this.asString(new ArrayList(map.entrySet()));
            }
            case 2: {
                Map.Entry entry = (Map.Entry)object;
                return "(" + this.asString(entry.getKey()) + " -> " + this.asString(entry.getValue()) + ")";
            }
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            StringBuilder result = new StringBuilder();
            if (value.getClass().isArray()) {
                for (i = 0; i < Array.getLength(value); ++i) {
                    result.append(i == 0 ? "" : ", ").append(this.asString(Array.get(value, i)));
                }
            } else {
                i = 0;
                for (Object item : (Collection)value) {
                    result.append(i == 0 ? "" : ", ").append(this.asString(item));
                    ++i;
                }
            }
            return "[" + String.valueOf(result) + "]";
        }
        return value.toString();
    }

    @Override
    public Component asComponent(@Nullable Object value) {
        if (value == null) {
            return MiniMessage.miniMessage().deserialize((Object)"<red><undefined></red>");
        }
        if (value instanceof Component) {
            Component component = (Component)value;
            return component;
        }
        return MiniMessage.miniMessage().deserialize((Object)value.toString());
    }

    @Override
    public List<Object> asCollection(@Nullable Object value) {
        if (value instanceof Collection) {
            return new ArrayList<Object>((Collection)value);
        }
        if (value instanceof Map) {
            return new ArrayList<Object>(((Map)value).entrySet());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (value == null) {
            return result;
        }
        result.add(value);
        return result;
    }

    @Override
    public boolean hasDecimalPoint(@Nullable Object value) {
        if (value instanceof Double || value instanceof Float) {
            return ((Number)value).doubleValue() % 1.0 != 0.0;
        }
        return false;
    }

    @Override
    public boolean areEqual(@Nullable Object a, @Nullable Object b, boolean strict) {
        if (a == null && b == null) {
            return true;
        }
        if (strict && (a == null || b == null)) {
            return false;
        }
        if (a instanceof String) {
            String sA = (String)a;
            if (b instanceof String) {
                String sB = (String)b;
                return strict ? sA.equals(sB) : sA.trim().equalsIgnoreCase(sB.trim());
            }
        }
        if (!strict && (a instanceof String && b instanceof Number || a instanceof Number && b instanceof String)) {
            Number stringNumber;
            Object numberValue;
            String stringValue = a instanceof String ? (String)a : (String)b;
            Object object = numberValue = a instanceof Number ? a : b;
            if (!this.hasDecimalPoint(numberValue)) {
                numberValue = this.asLong(numberValue);
            }
            try {
                stringNumber = stringValue.contains(".") ? (Number)Double.parseDouble(stringValue) : (Number)Long.parseLong(stringValue);
            }
            catch (Exception e) {
                return false;
            }
            return this.compare(stringNumber, numberValue) == 0;
        }
        if (strict && a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof Collection) {
            Collection cA = (Collection)a;
            if (b instanceof Collection) {
                Collection cB = (Collection)b;
                if (cA.size() != cB.size()) {
                    return false;
                }
                return this.doIterablesContainSameItems(cA, cB, strict, (vA, vB) -> this.areEqual(vA, vB, strict));
            }
        }
        if (a instanceof Map) {
            Map mA = (Map)a;
            if (b instanceof Map) {
                Map mB = (Map)b;
                if (mA.size() != mB.size()) {
                    return false;
                }
                return this.doIterablesContainSameItems(mA.entrySet(), mB.entrySet(), strict, (vA, vB) -> {
                    Map.Entry eA = (Map.Entry)vA;
                    Map.Entry eB = (Map.Entry)vB;
                    return this.areEqual(eA.getKey(), eB.getKey(), strict) && this.areEqual(eA.getValue(), eB.getValue(), strict);
                });
            }
        }
        if (a != null && a.getClass().isArray() && b != null && b.getClass().isArray()) {
            int lengthA = Array.getLength(a);
            if (lengthA != Array.getLength(b)) {
                return false;
            }
            return this.doIterablesContainSameItems(this.wrapArrayInIterable(a), this.wrapArrayInIterable(b), strict, (vA, vB) -> this.areEqual(vA, vB, strict));
        }
        return this.compare(a, b) == 0;
    }

    private Iterable<Object> wrapArrayInIterable(final Object array) {
        return () -> new Iterator<Object>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Array.getLength(array);
            }

            @Override
            public Object next() {
                return Array.get(array, this.i++);
            }
        };
    }

    private boolean doIterablesContainSameItems(Iterable<?> iterableA, Iterable<?> iterableB, boolean strict, BiFunction<Object, Object, Boolean> comparator) {
        if (strict) {
            Iterator<?> iterA = iterableA.iterator();
            Iterator<?> iterB = iterableB.iterator();
            while (iterA.hasNext()) {
                if (!iterB.hasNext()) {
                    return false;
                }
                if (comparator.apply(iterA.next(), iterB.next()).booleanValue()) continue;
                return false;
            }
            return true;
        }
        ArrayList<Integer> matchedBIndices = new ArrayList<Integer>();
        for (Object valueA : iterableA) {
            Iterator<?> iterB = iterableB.iterator();
            boolean anyMatched = false;
            int indexB = 0;
            while (iterB.hasNext()) {
                if (!comparator.apply(valueA, iterB.next()).booleanValue() || matchedBIndices.contains(indexB)) {
                    ++indexB;
                    continue;
                }
                anyMatched = true;
                matchedBIndices.add(indexB);
                break;
            }
            if (anyMatched) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object performMath(@Nullable Object a, @Nullable Object b, MathOperation operation) {
        switch (operation) {
            case ADDITION: {
                if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
                    return this.asDouble(a) + this.asDouble(b);
                }
                return this.asLong(a) + this.asLong(b);
            }
            case SUBTRACTION: {
                if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
                    return this.asDouble(a) - this.asDouble(b);
                }
                return this.asLong(a) - this.asLong(b);
            }
            case MULTIPLICATION: {
                if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
                    return this.asDouble(a) * this.asDouble(b);
                }
                return this.asLong(a) * this.asLong(b);
            }
            case DIVISION: {
                long lB;
                if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
                    return this.asDouble(a) / this.asDouble(b);
                }
                long lA = this.asLong(a);
                if (lA % (lB = this.asLong(b)) > 0L) {
                    return (double)lA / (double)lB;
                }
                return lA / lB;
            }
            case MODULO: {
                if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
                    return this.asDouble(a) % this.asDouble(b);
                }
                return this.asLong(a) % this.asLong(b);
            }
            case POWER: {
                if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
                    return Math.pow(this.asDouble(a), this.asDouble(b));
                }
                return (long)Math.pow(this.asDouble(a), this.asDouble(b));
            }
        }
        return null;
    }

    @Override
    public int compare(@Nullable Object a, @Nullable Object b) {
        if (a instanceof Comparable && b instanceof Comparable && a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        if (this.hasDecimalPoint(a) || this.hasDecimalPoint(b)) {
            return Double.compare(this.asDouble(a), this.asDouble(b));
        }
        return Long.compare(this.asLong(a), this.asLong(b));
    }
}

