/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.interpreter;

import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.error.AEvaluatorError;
import de.jexcellence.gpeee.error.FunctionInvocationError;
import de.jexcellence.gpeee.error.IdentifierInUseError;
import de.jexcellence.gpeee.error.InvalidFunctionInvocationError;
import de.jexcellence.gpeee.error.InvalidIndexError;
import de.jexcellence.gpeee.error.InvalidMapKeyError;
import de.jexcellence.gpeee.error.NonIndexableValueError;
import de.jexcellence.gpeee.error.NonNamedFunctionArgumentError;
import de.jexcellence.gpeee.error.UndefinedFunctionArgumentNameError;
import de.jexcellence.gpeee.error.UndefinedFunctionError;
import de.jexcellence.gpeee.error.UndefinedVariableError;
import de.jexcellence.gpeee.error.UnknownMemberError;
import de.jexcellence.gpeee.functions.AExpressionFunction;
import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.gpeee.interpreter.IValueInterpreter;
import de.jexcellence.gpeee.interpreter.InterpretationEnvironment;
import de.jexcellence.gpeee.logging.DebugLogSource;
import de.jexcellence.gpeee.parser.ComparisonOperation;
import de.jexcellence.gpeee.parser.EqualityOperation;
import de.jexcellence.gpeee.parser.MathOperation;
import de.jexcellence.gpeee.parser.expression.ABinaryExpression;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.parser.expression.AUnaryExpression;
import de.jexcellence.gpeee.parser.expression.AssignmentExpression;
import de.jexcellence.gpeee.parser.expression.CallbackExpression;
import de.jexcellence.gpeee.parser.expression.ComparisonExpression;
import de.jexcellence.gpeee.parser.expression.ConcatenationExpression;
import de.jexcellence.gpeee.parser.expression.ConjunctionExpression;
import de.jexcellence.gpeee.parser.expression.DisjunctionExpression;
import de.jexcellence.gpeee.parser.expression.DoubleExpression;
import de.jexcellence.gpeee.parser.expression.EqualityExpression;
import de.jexcellence.gpeee.parser.expression.FlipSignExpression;
import de.jexcellence.gpeee.parser.expression.FunctionInvocationExpression;
import de.jexcellence.gpeee.parser.expression.IdentifierExpression;
import de.jexcellence.gpeee.parser.expression.IfThenElseExpression;
import de.jexcellence.gpeee.parser.expression.IndexExpression;
import de.jexcellence.gpeee.parser.expression.InvertExpression;
import de.jexcellence.gpeee.parser.expression.LiteralExpression;
import de.jexcellence.gpeee.parser.expression.LongExpression;
import de.jexcellence.gpeee.parser.expression.MathExpression;
import de.jexcellence.gpeee.parser.expression.MemberAccessExpression;
import de.jexcellence.gpeee.parser.expression.NullCoalesceExpression;
import de.jexcellence.gpeee.parser.expression.ProgramExpression;
import de.jexcellence.gpeee.parser.expression.StringExpression;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class Interpreter {
    private final Logger logger;
    private final IStandardFunctionRegistry standardFunctionRegistry;

    public Interpreter(Logger logger, IStandardFunctionRegistry standardFunctionRegistry) {
        this.logger = logger;
        this.standardFunctionRegistry = standardFunctionRegistry;
    }

    public Object evaluateExpression(AExpression expression, IEvaluationEnvironment environment) throws AEvaluatorError {
        if (expression == null) {
            return null;
        }
        return this.evaluateExpressionSub(expression, environment, new InterpretationEnvironment());
    }

    public Object evaluateExpressionSub(AExpression expression, IEvaluationEnvironment evaluationEnvironment, final InterpretationEnvironment interpretationEnvironment) throws AEvaluatorError {
        if (expression == null) {
            return null;
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Evaluating " + expression.getClass().getSimpleName() + ": " + expression.expressionify());
        IValueInterpreter valueInterpreter = evaluationEnvironment.getValueInterpreter();
        AExpression aExpression = expression;
        Objects.requireNonNull(aExpression);
        AExpression aExpression2 = aExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProgramExpression.class, LongExpression.class, DoubleExpression.class, LiteralExpression.class, StringExpression.class, IdentifierExpression.class, FunctionInvocationExpression.class, CallbackExpression.class, IfThenElseExpression.class, MemberAccessExpression.class, ABinaryExpression.class}, (Object)aExpression2, n)) {
            case 0: {
                ProgramExpression program = (ProgramExpression)aExpression2;
                Object lastValue = null;
                int i = 0;
                while (i < program.getLines().size()) {
                    int programLine = i++;
                    AExpression line = program.getLines().get(programLine);
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Processing program line " + (programLine + 1));
                    lastValue = this.evaluateExpressionSub(line, evaluationEnvironment, interpretationEnvironment);
                }
                return lastValue;
            }
            case 1: {
                LongExpression longExpression = (LongExpression)aExpression2;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Taking the immediate long value");
                return longExpression.getNumber();
            }
            case 2: {
                DoubleExpression doubleExpression = (DoubleExpression)aExpression2;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Taking the immediate double value");
                return doubleExpression.getValue();
            }
            case 3: {
                LiteralExpression literalExpression = (LiteralExpression)aExpression2;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Taking the immediate literal value");
                return literalExpression.getValue();
            }
            case 4: {
                StringExpression stringExpression = (StringExpression)aExpression2;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Taking the immediate string value");
                return valueInterpreter.asString(stringExpression.getValue());
            }
            case 5: {
                IdentifierExpression identifierExpression = (IdentifierExpression)aExpression2;
                return this.lookupVariable(evaluationEnvironment, interpretationEnvironment, identifierExpression);
            }
            case 6: {
                FunctionInvocationExpression functionExpression = (FunctionInvocationExpression)aExpression2;
                AExpressionFunction function = this.lookupFunction(evaluationEnvironment, interpretationEnvironment, functionExpression.getName());
                if (function == null) {
                    if (functionExpression.isOptional()) {
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Function " + functionExpression.getName().getSymbol() + " not found, returning null (optional call)");
                        return null;
                    }
                    throw new UndefinedFunctionError(functionExpression.getName());
                }
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Evaluating arguments of function invocation " + functionExpression.getName().getSymbol());
                @Nullable List<ExpressionFunctionArgument> argDefinitions = function.getArguments();
                ArrayList<Object> arguments = new ArrayList<Object>();
                if (argDefinitions != null) {
                    while (arguments.size() < argDefinitions.size()) {
                        arguments.add(null);
                    }
                }
                boolean encounteredNamedArgument = false;
                int debugArgCounter = 0;
                int nonNamedArgCounter = 0;
                for (Tuple<AExpression, IdentifierExpression> argument : functionExpression.getArguments()) {
                    int debugArgIndex = ++debugArgCounter;
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Evaluating argument " + debugArgIndex);
                    Object argumentValue = this.evaluateExpressionSub((AExpression)argument.a, evaluationEnvironment, interpretationEnvironment);
                    if (argDefinitions != null && argument.b != null) {
                        encounteredNamedArgument = true;
                        boolean foundMatch = false;
                        int i = 0;
                        while (i < argDefinitions.size()) {
                            int argIndex = i++;
                            ExpressionFunctionArgument argDefinition = argDefinitions.get(argIndex);
                            String argName = ((IdentifierExpression)argument.b).getSymbol();
                            if (!argDefinition.getName().equalsIgnoreCase(argName)) continue;
                            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Matched named argument " + argName + " to index " + argIndex);
                            arguments.set(i, argumentValue);
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) continue;
                        throw new UndefinedFunctionArgumentNameError(function, (IdentifierExpression)argument.b);
                    }
                    if (encounteredNamedArgument) {
                        throw new NonNamedFunctionArgumentError((AExpression)argument.a);
                    }
                    if (argDefinitions == null) {
                        IdentifierExpression argNameExpression = (IdentifierExpression)argument.b;
                        if (argNameExpression != null) {
                            throw new UndefinedFunctionArgumentNameError(function, argNameExpression);
                        }
                        arguments.add(argumentValue);
                        continue;
                    }
                    if (nonNamedArgCounter >= arguments.size()) continue;
                    arguments.set(nonNamedArgCounter++, argumentValue);
                }
                function.validateArguments(functionExpression, evaluationEnvironment.getValueInterpreter(), arguments);
                Object result = function.apply(evaluationEnvironment, arguments);
                if (result instanceof FunctionInvocationError) {
                    FunctionInvocationError error = (FunctionInvocationError)result;
                    int index = error.getArgumentIndex();
                    Object value = arguments.size() > index ? arguments.get(index) : null;
                    throw new InvalidFunctionInvocationError(functionExpression, index, value, error.getMessage());
                }
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Invoked function, result: " + String.valueOf(result));
                return result;
            }
            case 7: {
                final CallbackExpression callbackExpression = (CallbackExpression)aExpression2;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Setting up the java endpoint for a callback expression");
                return new AExpressionFunction(){

                    @Override
                    public Object apply(final IEvaluationEnvironment environment, List<@Nullable Object> args) {
                        final HashMap combinedVariables = new HashMap(environment.getStaticVariables());
                        for (int i = 0; i < callbackExpression.getSignature().size(); ++i) {
                            String variableIdentifier = callbackExpression.getSignature().get(i).getSymbol();
                            Object variableValue = i < args.size() ? args.get(i) : null;
                            Interpreter.this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Adding " + variableIdentifier + "=" + String.valueOf(variableValue) + " to a callback's environment");
                            combinedVariables.put(variableIdentifier, variableValue);
                        }
                        Interpreter.this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Evaluating a callback's body");
                        Object result = Interpreter.this.evaluateExpressionSub(callbackExpression.getBody(), new IEvaluationEnvironment(){

                            @Override
                            public Map<String, AExpressionFunction> getFunctions() {
                                return environment.getFunctions();
                            }

                            @Override
                            public Map<String, Supplier<?>> getLiveVariables() {
                                return environment.getLiveVariables();
                            }

                            @Override
                            public Map<String, ?> getStaticVariables() {
                                return combinedVariables;
                            }

                            @Override
                            public IValueInterpreter getValueInterpreter() {
                                return environment.getValueInterpreter();
                            }
                        }, interpretationEnvironment);
                        Interpreter.this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Callback result=" + String.valueOf(result));
                        return result;
                    }

                    @Override
                    @Nullable
                    public List<ExpressionFunctionArgument> getArguments() {
                        return null;
                    }
                };
            }
            case 8: {
                IfThenElseExpression ifExpression = (IfThenElseExpression)aExpression2;
                Object condition = this.evaluateExpressionSub(ifExpression.getCondition(), evaluationEnvironment, interpretationEnvironment);
                if (evaluationEnvironment.getValueInterpreter().asBoolean(condition)) {
                    return this.evaluateExpressionSub(ifExpression.getPositiveBody(), evaluationEnvironment, interpretationEnvironment);
                }
                return this.evaluateExpressionSub(ifExpression.getNegativeBody(), evaluationEnvironment, interpretationEnvironment);
            }
            case 9: {
                MemberAccessExpression memberExpression = (MemberAccessExpression)aExpression2;
                Object value = this.evaluateExpressionSub(memberExpression.getLhs(), evaluationEnvironment, interpretationEnvironment);
                AExpression access = memberExpression.getRhs();
                String fieldName = access instanceof IdentifierExpression ? ((IdentifierExpression)access).getSymbol() : valueInterpreter.asString(this.evaluateExpressionSub(access, evaluationEnvironment, interpretationEnvironment));
                if (value == null) {
                    if (memberExpression.isOptional()) {
                        return null;
                    }
                    throw new UnknownMemberError(memberExpression, null, fieldName);
                }
                for (Field f : value.getClass().getDeclaredFields()) {
                    if (!f.getName().equalsIgnoreCase(fieldName)) continue;
                    try {
                        f.setAccessible(true);
                        return f.get(value);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, e, () -> "Could not access an object's member");
                        return "<error>";
                    }
                }
                if (memberExpression.isOptional()) {
                    return null;
                }
                throw new UnknownMemberError(memberExpression, value, fieldName);
            }
            case 10: {
                ABinaryExpression aBinaryExpression = (ABinaryExpression)aExpression2;
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Evaluating LHS and RHS of a binary expression");
                Object rhs = this.evaluateExpressionSub(aBinaryExpression.getRhs(), evaluationEnvironment, interpretationEnvironment);
                if (expression instanceof AssignmentExpression) {
                    String identifier = ((IdentifierExpression)((ABinaryExpression)expression).getLhs()).getSymbol();
                    boolean isFunction = rhs instanceof AExpressionFunction;
                    if (!isFunction) {
                        if (evaluationEnvironment.getLiveVariables().containsKey(identifier) || evaluationEnvironment.getStaticVariables().containsKey(identifier) || interpretationEnvironment.getVariables().containsKey(identifier)) {
                            throw new IdentifierInUseError((IdentifierExpression)((AssignmentExpression)expression).getLhs());
                        }
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Storing variable " + identifier + " within the interpretation environment");
                        interpretationEnvironment.getVariables().put(identifier, rhs);
                    } else {
                        if (this.standardFunctionRegistry.lookup(identifier) != null || evaluationEnvironment.getFunctions().containsKey(identifier) || interpretationEnvironment.getFunctions().containsKey(identifier)) {
                            throw new IdentifierInUseError((IdentifierExpression)((AssignmentExpression)expression).getLhs());
                        }
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Storing function " + identifier + " within the interpretation environment");
                        interpretationEnvironment.getFunctions().put(identifier, (AExpressionFunction)rhs);
                    }
                    return rhs;
                }
                Object lhs = this.evaluateExpressionSub(aBinaryExpression.getLhs(), evaluationEnvironment, interpretationEnvironment);
                AExpression aExpression3 = expression;
                Objects.requireNonNull(aExpression3);
                AExpression aExpression4 = aExpression3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MathExpression.class, NullCoalesceExpression.class, EqualityExpression.class, ComparisonExpression.class, ConjunctionExpression.class, DisjunctionExpression.class, ConcatenationExpression.class, IndexExpression.class}, (Object)aExpression4, n2)) {
                    case 0: {
                        MathExpression mathExpression = (MathExpression)aExpression4;
                        MathOperation operation = mathExpression.getOperation();
                        Object result = valueInterpreter.performMath(lhs, rhs, operation);
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Math Operation operation " + String.valueOf((Object)operation) + " result: " + String.valueOf(result));
                        return result;
                    }
                    case 1: {
                        NullCoalesceExpression nullCoalesce = (NullCoalesceExpression)aExpression4;
                        Object inputValue = this.evaluateExpressionSub(nullCoalesce.getLhs(), evaluationEnvironment, interpretationEnvironment);
                        if (inputValue != null) {
                            return inputValue;
                        }
                        return this.evaluateExpressionSub(nullCoalesce.getRhs(), evaluationEnvironment, interpretationEnvironment);
                    }
                    case 2: {
                        EqualityExpression equalityExpression = (EqualityExpression)aExpression4;
                        EqualityOperation operation = equalityExpression.getOperation();
                        boolean result = switch (operation) {
                            default -> throw new MatchException(null, null);
                            case EqualityOperation.EQUAL -> valueInterpreter.areEqual(lhs, rhs, false);
                            case EqualityOperation.NOT_EQUAL -> {
                                if (!valueInterpreter.areEqual(lhs, rhs, false)) {
                                    yield true;
                                }
                                yield false;
                            }
                            case EqualityOperation.EQUAL_EXACT -> valueInterpreter.areEqual(lhs, rhs, true);
                            case EqualityOperation.NOT_EQUAL_EXACT -> !valueInterpreter.areEqual(lhs, rhs, true);
                        };
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Equality Operation operation " + String.valueOf((Object)operation) + " result: " + result);
                        return result;
                    }
                    case 3: {
                        ComparisonExpression comparisonExpression = (ComparisonExpression)aExpression4;
                        ComparisonOperation operation = comparisonExpression.getOperation();
                        int comparisonResult = valueInterpreter.compare(lhs, rhs);
                        boolean result = switch (operation) {
                            case ComparisonOperation.LESS_THAN -> {
                                if (comparisonResult < 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case ComparisonOperation.GREATER_THAN -> {
                                if (comparisonResult > 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case ComparisonOperation.LESS_THAN_OR_EQUAL -> {
                                if (comparisonResult <= 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case ComparisonOperation.GREATER_THAN_OR_EQUAL -> {
                                if (comparisonResult >= 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> false;
                        };
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Comparison Operation operation " + String.valueOf((Object)operation) + " result: " + result);
                        return result;
                    }
                    case 4: {
                        ConjunctionExpression conjunctionExpression = (ConjunctionExpression)aExpression4;
                        boolean result = valueInterpreter.asBoolean(lhs) && valueInterpreter.asBoolean(rhs);
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Conjunction Operation result: " + result);
                        return result;
                    }
                    case 5: {
                        DisjunctionExpression disjunctionExpression = (DisjunctionExpression)aExpression4;
                        boolean result = valueInterpreter.asBoolean(lhs) || valueInterpreter.asBoolean(rhs);
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Disjunction Operation result: " + result);
                        return result;
                    }
                    case 6: {
                        ConcatenationExpression concatenationExpression = (ConcatenationExpression)aExpression4;
                        String result = valueInterpreter.asString(lhs) + valueInterpreter.asString(rhs);
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Concatenation Operation result: " + result);
                        return result;
                    }
                    case 7: {
                        IndexExpression indexExpression = (IndexExpression)aExpression4;
                        if (lhs instanceof List) {
                            int listLength;
                            List list = (List)lhs;
                            int key = (int)valueInterpreter.asLong(rhs);
                            if (key >= (listLength = list.size())) {
                                if (indexExpression.isOptional()) {
                                    return null;
                                }
                                throw new InvalidIndexError(indexExpression, key, listLength);
                            }
                            Object result = list.get(key);
                            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Indexing a list at " + key + ": " + String.valueOf(result));
                            return result;
                        }
                        if (lhs != null && lhs.getClass().isArray()) {
                            int arrayLength;
                            int key = (int)valueInterpreter.asLong(rhs);
                            if (key >= (arrayLength = Array.getLength(lhs))) {
                                if (indexExpression.isOptional()) {
                                    return null;
                                }
                                throw new InvalidIndexError(indexExpression, key, arrayLength);
                            }
                            Object result = Array.get(lhs, key);
                            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Indexing an array at " + key + ": " + String.valueOf(result));
                            return result;
                        }
                        if (lhs instanceof Map) {
                            Map map = (Map)lhs;
                            String key = valueInterpreter.asString(rhs);
                            if (!map.containsKey(key)) {
                                if (indexExpression.isOptional()) {
                                    return null;
                                }
                                throw new InvalidMapKeyError(indexExpression, key);
                            }
                            Object result = map.get(key);
                            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Indexing a map at " + key + ": " + String.valueOf(result));
                            return result;
                        }
                        throw new NonIndexableValueError(indexExpression, lhs);
                    }
                }
                break;
            }
        }
        if (expression instanceof AUnaryExpression) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Evaluating input of a unary expression");
            Object input = this.evaluateExpressionSub(((AUnaryExpression)expression).getInput(), evaluationEnvironment, interpretationEnvironment);
            if (expression instanceof FlipSignExpression) {
                Number result = valueInterpreter.hasDecimalPoint(input) ? (Number)(-1.0 * valueInterpreter.asDouble(input)) : (Number)(-1L * valueInterpreter.asLong(input));
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Flip Sign Operation result: " + String.valueOf(result));
                return result;
            }
            if (expression instanceof InvertExpression) {
                boolean result = !valueInterpreter.asBoolean(input);
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Invert Operation result: " + result);
                return result;
            }
        }
        throw new IllegalStateException("Cannot parse unknown expression type " + String.valueOf(expression.getClass()));
    }

    @Nullable
    private AExpressionFunction lookupFunction(IEvaluationEnvironment evaluationEnvironment, InterpretationEnvironment interpretationEnvironment, IdentifierExpression identifier) {
        String symbol = identifier.getSymbol().toLowerCase(Locale.ROOT);
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Looking up function " + symbol);
        AStandardFunction stdFunction = this.standardFunctionRegistry.lookup(symbol);
        if (stdFunction != null) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Resolved standard function");
            return stdFunction;
        }
        if (evaluationEnvironment.getFunctions().containsKey(symbol)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Resolved environment function");
            return evaluationEnvironment.getFunctions().get(symbol);
        }
        if (interpretationEnvironment.getFunctions().containsKey(symbol)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Resolved interpretation function");
            return interpretationEnvironment.getFunctions().get(symbol);
        }
        return null;
    }

    private Object lookupVariable(IEvaluationEnvironment evaluationEnvironment, InterpretationEnvironment interpretationEnvironment, IdentifierExpression identifier) throws UndefinedVariableError {
        String symbol = identifier.getSymbol().toLowerCase(Locale.ROOT);
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Looking up variable " + symbol);
        if (evaluationEnvironment.getStaticVariables().containsKey(symbol)) {
            Object value = evaluationEnvironment.getStaticVariables().get(symbol);
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Resolved static variable value: " + String.valueOf(value));
            return value;
        }
        Supplier<?> valueSupplier = evaluationEnvironment.getLiveVariables().get(symbol);
        if (valueSupplier != null) {
            Object value = valueSupplier.get();
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Resolved dynamic variable value: " + String.valueOf(value));
            return value;
        }
        if (interpretationEnvironment.getVariables().containsKey(symbol)) {
            Object value = interpretationEnvironment.getVariables().get(symbol);
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.INTERPRETER) + "Resolved interpretation environment variable value: " + String.valueOf(value));
            return value;
        }
        throw new UndefinedVariableError(identifier);
    }
}

