/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.interpreter;

import de.jexcellence.gpeee.GPEEE;
import de.jexcellence.gpeee.functions.AExpressionFunction;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.gpeee.interpreter.IValueInterpreter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class EvaluationEnvironmentBuilder {
    private IValueInterpreter valueInterpreter;
    private final Map<String, Object> staticVariables;
    private final Map<String, Supplier<?>> liveVariables;
    private final Map<String, AExpressionFunction> functions;

    private EvaluationEnvironmentBuilder(IValueInterpreter valueInterpreter, Map<String, Object> staticVariables, Map<String, Supplier<?>> liveVariables, Map<String, AExpressionFunction> functions) {
        this.valueInterpreter = valueInterpreter;
        this.staticVariables = staticVariables;
        this.liveVariables = liveVariables;
        this.functions = functions;
    }

    public EvaluationEnvironmentBuilder() {
        this.valueInterpreter = GPEEE.STD_VALUE_INTERPRETER;
        this.staticVariables = new HashMap<String, Object>();
        this.liveVariables = new HashMap();
        this.functions = new HashMap<String, AExpressionFunction>();
    }

    public EvaluationEnvironmentBuilder withValueInterpreter(IValueInterpreter valueInterpreter) {
        this.valueInterpreter = valueInterpreter;
        return this;
    }

    public EvaluationEnvironmentBuilder withStaticVariable(String identifier, Object value) {
        this.staticVariables.put(identifier, value);
        return this;
    }

    public EvaluationEnvironmentBuilder withLiveVariable(String identifier, Supplier<?> value) {
        this.liveVariables.put(identifier, value);
        return this;
    }

    public EvaluationEnvironmentBuilder withFunction(String identifier, AExpressionFunction function) {
        this.functions.put(identifier, function);
        return this;
    }

    public EvaluationEnvironmentBuilder duplicate() {
        return new EvaluationEnvironmentBuilder(this.valueInterpreter, new HashMap<String, Object>(this.staticVariables), new HashMap(this.liveVariables), new HashMap<String, AExpressionFunction>(this.functions));
    }

    public IEvaluationEnvironment build() {
        return this.build(null);
    }

    public IEvaluationEnvironment build(@Nullable IEvaluationEnvironment environmentToExtend) {
        final HashMap<String, AExpressionFunction> resultingFunctions = new HashMap<String, AExpressionFunction>(this.functions);
        final HashMap resultingLiveVariables = new HashMap(this.liveVariables);
        final HashMap<String, Object> resultingStaticVariables = new HashMap<String, Object>(this.staticVariables);
        if (environmentToExtend != null) {
            resultingFunctions.putAll(environmentToExtend.getFunctions());
            resultingLiveVariables.putAll(environmentToExtend.getLiveVariables());
            resultingStaticVariables.putAll(environmentToExtend.getStaticVariables());
        }
        return new IEvaluationEnvironment(){

            @Override
            public Map<String, AExpressionFunction> getFunctions() {
                return resultingFunctions;
            }

            @Override
            public Map<String, Supplier<?>> getLiveVariables() {
                return resultingLiveVariables;
            }

            public Map<String, Object> getStaticVariables() {
                return resultingStaticVariables;
            }

            @Override
            public IValueInterpreter getValueInterpreter() {
                return EvaluationEnvironmentBuilder.this.valueInterpreter;
            }
        };
    }
}

