/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.functions.std;

import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TitleCaseFunction
extends AStandardFunction {
    @Override
    public Object apply(IEvaluationEnvironment environment, List<@Nullable Object> args) {
        return this.toTitleCase((String)this.nonNull(args, 0));
    }

    @Override
    @Nullable
    public List<ExpressionFunctionArgument> getArguments() {
        return Collections.singletonList(new ExpressionFunctionArgument("input", "Input to title-case", true, String.class));
    }

    @Override
    public void registerSelf(IStandardFunctionRegistry registry) {
        registry.register("title_case", this);
    }

    @Override
    public boolean returnsPrimaryResult() {
        return true;
    }

    private String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder(input.length());
        boolean nextTitleCase = true;
        for (char c : input.toCharArray()) {
            if (this.isTitleCaseResetChar(c = Character.toLowerCase(c))) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    private boolean isTitleCaseResetChar(char c) {
        return Character.isSpaceChar(c) || c == ',' || c == '_';
    }
}

