/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.functions.std;

import de.jexcellence.gpeee.error.FunctionInvocationError;
import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SubstringFunction
extends AStandardFunction {
    @Override
    public Object apply(IEvaluationEnvironment environment, List<@Nullable Object> args) {
        String input = (String)this.nonNull(args, 0);
        Long start = (Long)this.nonNull(args, 1);
        Long end = (Long)this.nullable(args, 2);
        int inputLength = input.length();
        if (start < 0L || start >= (long)inputLength) {
            return new FunctionInvocationError(1, "Start index out of bounds");
        }
        if (end != null) {
            if (end < 0L || end >= (long)inputLength) {
                return new FunctionInvocationError(1, "End index out of bounds");
            }
            if (end < start) {
                return new FunctionInvocationError(1, "Start (" + start + ") cannot be larger than end");
            }
            return input.substring(start.intValue(), end.intValue());
        }
        return input.substring(start.intValue());
    }

    @Override
    @Nullable
    public List<ExpressionFunctionArgument> getArguments() {
        return Arrays.asList(new ExpressionFunctionArgument("input", "Input to search in", true, String.class), new ExpressionFunctionArgument("start", "Start index (inclusive)", true, Long.class), new ExpressionFunctionArgument("end", "End index (exclusive)", false, Long.class));
    }

    @Override
    public void registerSelf(IStandardFunctionRegistry registry) {
        registry.register("substring", this);
    }

    @Override
    public boolean returnsPrimaryResult() {
        return true;
    }
}

