/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.functions.std;

import de.jexcellence.gpeee.functions.AExpressionFunction;
import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IterCatFunction
extends AStandardFunction {
    @Override
    public Object apply(IEvaluationEnvironment env, List<@Nullable Object> args) {
        Collection items = (Collection)this.nonNull(args, 0);
        AExpressionFunction mapper = (AExpressionFunction)this.nonNull(args, 1);
        @Nullable String separator = this.nullableWithFallback(args, 2, ", ");
        @Nullable String fallback = (String)this.nullable(args, 3);
        StringBuilder result = new StringBuilder();
        int c = 0;
        for (Object item : items) {
            result.append(result.length() == 0 ? "" : separator).append(mapper.apply(env, Arrays.asList(item, c++)));
        }
        if (items.size() == 0 && fallback != null) {
            return fallback;
        }
        return result.toString();
    }

    @Override
    @Nullable
    public List<ExpressionFunctionArgument> getArguments() {
        return Arrays.asList(new ExpressionFunctionArgument("items", "Collection to iterate", true, Collection.class), new ExpressionFunctionArgument("mapper", "Iteration item mapper function", true, AExpressionFunction.class), new ExpressionFunctionArgument("separator", "Item separator", false, String.class), new ExpressionFunctionArgument("fallback", "Fallback when collection is empty", false, String.class));
    }

    @Override
    public void registerSelf(IStandardFunctionRegistry registry) {
        registry.register("iter_cat", this);
    }

    @Override
    public boolean returnsPrimaryResult() {
        return true;
    }
}

