/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.functions.std;

import de.jexcellence.gpeee.error.FunctionInvocationError;
import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public class DateFormatFunction
extends AStandardFunction {
    private final Map<String, Map<TimeZone, DateFormat>> dateFormatByStringFormatAndZone = new HashMap<String, Map<TimeZone, DateFormat>>();

    @Override
    public Object apply(IEvaluationEnvironment environment, List<@Nullable Object> args) {
        DateFormat format;
        TimeZone formatTimeZone;
        Object date = this.nonNull(args, 0);
        String type = (String)this.nonNull(args, 1);
        String formatString = (String)this.nonNull(args, 2);
        String timeZone = this.nullableWithFallback(args, 3, "UTC");
        try {
            ZoneId timeZoneId = ZoneId.of(timeZone);
            formatTimeZone = TimeZone.getTimeZone(timeZoneId);
        }
        catch (Exception e) {
            return new FunctionInvocationError(3, "Invalid timezone provided");
        }
        try {
            format = this.getDateFormat(formatString, formatTimeZone);
        }
        catch (Exception e) {
            return new FunctionInvocationError(2, "Malformed date format");
        }
        type = type.toLowerCase(Locale.ROOT);
        if (type.equals("date")) {
            if (!(date instanceof Date)) {
                return new FunctionInvocationError(0, "Not an instance of Date");
            }
            return format.format((Date)date);
        }
        boolean isMillis = type.equals("millis");
        if (type.equals("seconds") || isMillis) {
            if (!(date instanceof Number)) {
                return new FunctionInvocationError(0, "Not an instance of Number");
            }
            long stamp = ((Number)date).longValue();
            if (!isMillis) {
                stamp *= 1000L;
            }
            return format.format(new Date(stamp));
        }
        return new FunctionInvocationError(1, "Invalid date type provided");
    }

    private DateFormat getDateFormat(String format, TimeZone zone) {
        Map dateFormatByZone = this.dateFormatByStringFormatAndZone.computeIfAbsent(format, key -> new HashMap());
        DateFormat dateFormat = (DateFormat)dateFormatByZone.get(zone);
        if (dateFormat != null) {
            return dateFormat;
        }
        dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(zone);
        dateFormatByZone.put(zone, dateFormat);
        return dateFormat;
    }

    @Override
    @Nullable
    public List<ExpressionFunctionArgument> getArguments() {
        return Arrays.asList(new ExpressionFunctionArgument("date", "Input date to format", true, new Class[0]), new ExpressionFunctionArgument("type", "Type of date provided (seconds, millis, date)", true, String.class), new ExpressionFunctionArgument("format", "Date format to apply", true, String.class), new ExpressionFunctionArgument("timezone", "Timezone to use, defaults to UTC", false, String.class));
    }

    @Override
    public void registerSelf(IStandardFunctionRegistry registry) {
        registry.register("date_format", this);
    }

    @Override
    public boolean returnsPrimaryResult() {
        return true;
    }
}

