/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.functions;

import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.interpreter.IValueInterpreter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionFunctionArgument {
    private final String name;
    private final String description;
    private final boolean required;
    private final Class<?>[] allowedTypes;

    public ExpressionFunctionArgument(String name, String description, boolean required, Class<?> ... allowedTypes) {
        this.name = name;
        this.description = description;
        this.required = required;
        this.allowedTypes = allowedTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Class<?>[] getAllowedTypes() {
        return this.allowedTypes;
    }

    public Tuple<Boolean, @Nullable Object> checkDescriptionAndPossiblyConvert(@Nullable Object o, IValueInterpreter valueInterpreter) {
        if (this.required && o == null) {
            return new Tuple<Boolean, Object>(false, null);
        }
        if (this.allowedTypes.length == 0) {
            return new Tuple<Boolean, Object>(true, o);
        }
        if (!this.required && o == null) {
            return new Tuple<Boolean, Object>(true, null);
        }
        Class<?> type = o.getClass();
        boolean anyAllowedMatches = false;
        for (Class<?> allowedType : this.allowedTypes) {
            if (!allowedType.isAssignableFrom(type)) {
                Object convertedSubstitution = this.tryConvertValue(o, allowedType, valueInterpreter);
                if (convertedSubstitution == null) continue;
                o = convertedSubstitution;
            }
            anyAllowedMatches = true;
            break;
        }
        return new Tuple<Boolean, Object>(anyAllowedMatches, o);
    }

    @Nullable
    private Object tryConvertValue(@NotNull Object value, Class<?> targetType, IValueInterpreter valueInterpreter) {
        if (targetType == String.class) {
            return valueInterpreter.asString(value);
        }
        if (targetType == Component.class) {
            return valueInterpreter.asComponent(value);
        }
        if (targetType == Long.class) {
            return valueInterpreter.asLong(value);
        }
        if (targetType == Double.class) {
            return valueInterpreter.asDouble(value);
        }
        if (targetType == Boolean.class) {
            return valueInterpreter.asBoolean(value);
        }
        if (Iterable.class.isAssignableFrom(targetType) && Map.class.isAssignableFrom(value.getClass())) {
            return new ArrayList(((Map)value).entrySet());
        }
        return null;
    }

    public String stringifyAllowedTypes() {
        if (this.allowedTypes.length == 0) {
            if (this.required) {
                return "<any, non-null>";
            }
            return "<any, nullable>";
        }
        return Arrays.stream(this.allowedTypes).map(Class::getName).collect(Collectors.joining(" | "));
    }
}

